<?php
/**
 * أداة لاختبار API الحصول على الرقم التسلسلي التالي
 * تستخدم هذه الأداة للتأكد من أن API يعمل بشكل صحيح
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/config.php';

// رموز الفروع للاختبار
$branchCodes = [
    'MKL25-',
    'SNA25-',
    'ADN25-',
    'SH25-',
    'CN25-'
];

// عرض نموذج الاختبار
echo "<h1>اختبار API الحصول على الرقم التسلسلي التالي</h1>";
echo "<p>استخدم هذه الأداة لاختبار API الحصول على الرقم التسلسلي التالي لكل فرع.</p>";

// عرض حالة جدول order_sequences
$stmt = $pdo->query("SELECT * FROM order_sequences");
$sequences = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h2>حالة جدول order_sequences:</h2>";
echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
echo "<tr><th>المعرف</th><th>رمز الفرع</th><th>آخر رقم تسلسلي</th><th>تاريخ الإنشاء</th><th>تاريخ التحديث</th></tr>";

foreach ($sequences as $sequence) {
    echo "<tr>";
    echo "<td>{$sequence['id']}</td>";
    echo "<td>{$sequence['branch_code']}</td>";
    echo "<td>{$sequence['last_sequence_number']}</td>";
    echo "<td>{$sequence['created_at']}</td>";
    echo "<td>{$sequence['updated_at']}</td>";
    echo "</tr>";
}

echo "</table>";

// عرض نتائج الاختبار
echo "<h2>نتائج الاختبار:</h2>";
echo "<div id='results'></div>";

// عرض أزرار الاختبار
echo "<h2>اختبار API:</h2>";
echo "<div style='display: flex; flex-wrap: wrap; gap: 10px;'>";

foreach ($branchCodes as $branchCode) {
    echo "<button onclick='testAPI(\"$branchCode\", true)' style='padding: 10px 15px; background-color: #4f46e5; color: white; border: none; border-radius: 5px; cursor: pointer;'>اختبار $branchCode (مع حجز)</button>";
    echo "<button onclick='testAPI(\"$branchCode\", false)' style='padding: 10px 15px; background-color: #6366f1; color: white; border: none; border-radius: 5px; cursor: pointer;'>اختبار $branchCode (بدون حجز)</button>";
}

echo "</div>";

// عرض زر إعادة تعيين أرقام التسلسل
echo "<div style='display: flex; flex-wrap: wrap; gap: 10px; margin-top: 20px;'>";
echo "<a href='reset_sequences.php?reset=true' style='display: inline-block; padding: 10px 15px; background-color: #ef4444; color: white; text-decoration: none; border-radius: 5px;'>إعادة تعيين جميع أرقام التسلسل</a>";
echo "<a href='sync_backup_orders.php' style='display: inline-block; padding: 10px 15px; background-color: #10b981; color: white; text-decoration: none; border-radius: 5px;'>مزامنة أرقام الطلبات الاحتياطية</a>";
echo "<a href='check_duplicate_orders.php' style='display: inline-block; padding: 10px 15px; background-color: #3b82f6; color: white; text-decoration: none; border-radius: 5px;'>التحقق من أرقام الطلبات المكررة</a>";
echo "<a href='fix_branch_sequences.php' style='display: inline-block; padding: 10px 15px; background-color: #8b5cf6; color: white; text-decoration: none; border-radius: 5px;'>إصلاح تسلسل أرقام الطلبات للفروع</a>";
echo "</div>";

// إضافة سكريبت JavaScript للاختبار
echo "<script>
function testAPI(branchCode, reserve = true) {
    const resultsDiv = document.getElementById('results');
    const resultItem = document.createElement('div');
    resultItem.style.padding = '10px';
    resultItem.style.margin = '5px 0';
    resultItem.style.borderRadius = '5px';
    resultItem.style.backgroundColor = '#f3f4f6';

    resultItem.innerHTML = `<strong>جاري اختبار ${branchCode} ${reserve ? '(مع حجز)' : '(بدون حجز)'}...</strong>`;
    resultsDiv.prepend(resultItem);

    fetch(`../api/get_next_sequence.php?branch_code=${branchCode}&reserve=${reserve}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                resultItem.style.backgroundColor = '#d1fae5';
                resultItem.innerHTML = `
                    <strong>نجاح!</strong><br>
                    رمز الفرع: ${branchCode}<br>
                    رقم الطلب: ${data.order_number}<br>
                    الرقم التسلسلي: ${data.sequence_number}<br>
                    الرقم التسلسلي المنسق: ${data.formatted_sequence}<br>
                    <small>${new Date().toLocaleTimeString()}</small>
                `;
            } else {
                resultItem.style.backgroundColor = '#fee2e2';
                resultItem.innerHTML = `
                    <strong>خطأ!</strong><br>
                    رمز الفرع: ${branchCode}<br>
                    الرسالة: ${data.message}<br>
                    <small>${new Date().toLocaleTimeString()}</small>
                `;
            }
        })
        .catch(error => {
            resultItem.style.backgroundColor = '#fee2e2';
            resultItem.innerHTML = `
                <strong>خطأ في الاتصال!</strong><br>
                رمز الفرع: ${branchCode}<br>
                الرسالة: ${error.message}<br>
                <small>${new Date().toLocaleTimeString()}</small>
            `;
        });
}
</script>";
?>
