<?php
/**
 * أداة اختبار تسلسل أرقام الطلبات للفروع
 * تستخدم هذه الأداة لاختبار توليد أرقام الطلبات التسلسلية لكل فرع
 * والتأكد من أنها تعمل بشكل صحيح
 */

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/config.php';

// تعيين رأس الصفحة
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>اختبار تسلسل أرقام الطلبات للفروع</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 20px;
            background-color: #f8f9fa;
            color: #333;
        }
        h1, h2 {
            color: #3730a3;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 12px;
            text-align: right;
            border: 1px solid #ddd;
        }
        th {
            background-color: #4f46e5;
            color: white;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .btn {
            display: inline-block;
            padding: 10px 15px;
            background-color: #4f46e5;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-right: 10px;
            border: none;
            cursor: pointer;
            font-size: 14px;
        }
        .btn-danger {
            background-color: #ef4444;
        }
        .btn-success {
            background-color: #10b981;
        }
        .btn-info {
            background-color: #3b82f6;
        }
        .test-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }
        .test-card {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            background-color: white;
        }
        .success {
            background-color: #d1fae5;
            border-color: #10b981;
        }
        .error {
            background-color: #fee2e2;
            border-color: #ef4444;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>اختبار تسلسل أرقام الطلبات للفروع</h1>
        <p>تستخدم هذه الأداة لاختبار توليد أرقام الطلبات التسلسلية لكل فرع والتأكد من أنها تعمل بشكل صحيح.</p>

        <?php
        // عرض حالة جدول order_sequences
        $stmt = $pdo->query("SELECT * FROM order_sequences");
        $sequences = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "<h2>حالة جدول order_sequences:</h2>";
        echo "<table>";
        echo "<tr><th>المعرف</th><th>رمز الفرع</th><th>آخر رقم تسلسلي</th><th>تاريخ الإنشاء</th><th>تاريخ التحديث</th></tr>";
        
        foreach ($sequences as $sequence) {
            echo "<tr>";
            echo "<td>{$sequence['id']}</td>";
            echo "<td>{$sequence['branch_code']}</td>";
            echo "<td>{$sequence['last_sequence_number']}</td>";
            echo "<td>{$sequence['created_at']}</td>";
            echo "<td>{$sequence['updated_at']}</td>";
            echo "</tr>";
        }
        
        echo "</table>";

        // التحقق من وجود جميع رموز الفروع المطلوبة
        $requiredBranchCodes = ['MKL', 'SNA', 'ADN', 'SH', 'CN'];
        $missingCodes = [];
        
        foreach ($requiredBranchCodes as $code) {
            $found = false;
            foreach ($sequences as $sequence) {
                if ($sequence['branch_code'] === $code) {
                    $found = true;
                    break;
                }
            }
            if (!$found) {
                $missingCodes[] = $code;
            }
        }

        if (!empty($missingCodes)) {
            echo "<div style='margin: 20px 0; padding: 15px; background-color: #fee2e2; border: 1px solid #ef4444; border-radius: 5px;'>";
            echo "<h3 style='color: #b91c1c; margin-top: 0;'>تنبيه: رموز فروع مفقودة</h3>";
            echo "<p>الرموز التالية غير موجودة في جدول order_sequences:</p>";
            echo "<ul>";
            foreach ($missingCodes as $code) {
                echo "<li>{$code}</li>";
            }
            echo "</ul>";
            echo "<form method='post'>";
            echo "<button type='submit' name='add_missing_codes' class='btn btn-success'>إضافة الرموز المفقودة</button>";
            echo "</form>";
            echo "</div>";
        }

        // إضافة الرموز المفقودة إذا تم طلب ذلك
        if (isset($_POST['add_missing_codes']) && !empty($missingCodes)) {
            foreach ($missingCodes as $code) {
                $stmt = $pdo->prepare("INSERT INTO order_sequences (branch_code, last_sequence_number) VALUES (?, 0)");
                $stmt->execute([$code]);
                echo "<p style='color: green;'>تم إضافة رمز الفرع {$code} بنجاح.</p>";
            }
            echo "<script>window.location.reload();</script>";
        }

        // إعادة تعيين أرقام التسلسل إذا تم طلب ذلك
        if (isset($_GET['reset']) && $_GET['reset'] === 'true') {
            $stmt = $pdo->prepare("UPDATE order_sequences SET last_sequence_number = 0");
            $stmt->execute();
            echo "<p style='color: green;'>تم إعادة تعيين جميع أرقام التسلسل بنجاح.</p>";
            echo "<script>window.location.href = 'test_branch_sequences.php';</script>";
        }
        ?>

        <div style="margin: 20px 0;">
            <a href="?reset=true" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من إعادة تعيين جميع أرقام التسلسل؟')">إعادة تعيين جميع أرقام التسلسل</a>
            <a href="../api/get_next_sequence.php?branch_code=MKL&reserve=false" target="_blank" class="btn btn-info">اختبار API مباشرة (MKL)</a>
        </div>

        <h2>اختبار توليد أرقام الطلبات:</h2>
        <div class="test-container" id="testResults">
            <?php foreach ($requiredBranchCodes as $code): ?>
            <div class="test-card" id="test-<?php echo $code; ?>">
                <h3><?php echo $code; ?></h3>
                <p>جاري الاختبار...</p>
                <button class="btn" onclick="testBranchCode('<?php echo $code; ?>')">اختبار</button>
            </div>
            <?php endforeach; ?>
        </div>

        <script>
            function testBranchCode(branchCode) {
                const resultItem = document.getElementById(`test-${branchCode}`);
                resultItem.innerHTML = `<h3>${branchCode}</h3><p>جاري الاختبار...</p>`;
                
                fetch(`../api/get_next_sequence.php?branch_code=${branchCode}&reserve=true`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            resultItem.className = 'test-card success';
                            resultItem.innerHTML = `
                                <h3>${branchCode}</h3>
                                <p><strong>نجاح!</strong></p>
                                <p>رقم الطلب: ${data.order_number}</p>
                                <p>الرقم التسلسلي: ${data.sequence_number}</p>
                                <p>الرقم المنسق: ${data.formatted_sequence}</p>
                                <small>${new Date().toLocaleTimeString()}</small>
                                <br><br>
                                <button class="btn" onclick="testBranchCode('${branchCode}')">اختبار مرة أخرى</button>
                            `;
                        } else {
                            resultItem.className = 'test-card error';
                            resultItem.innerHTML = `
                                <h3>${branchCode}</h3>
                                <p><strong>خطأ!</strong></p>
                                <p>الرسالة: ${data.message}</p>
                                <small>${new Date().toLocaleTimeString()}</small>
                                <br><br>
                                <button class="btn" onclick="testBranchCode('${branchCode}')">اختبار مرة أخرى</button>
                            `;
                        }
                    })
                    .catch(error => {
                        resultItem.className = 'test-card error';
                        resultItem.innerHTML = `
                            <h3>${branchCode}</h3>
                            <p><strong>خطأ في الاتصال!</strong></p>
                            <p>تفاصيل: ${error.message}</p>
                            <small>${new Date().toLocaleTimeString()}</small>
                            <br><br>
                            <button class="btn" onclick="testBranchCode('${branchCode}')">اختبار مرة أخرى</button>
                        `;
                    });
            }

            // اختبار جميع الفروع عند تحميل الصفحة
            window.onload = function() {
                <?php foreach ($requiredBranchCodes as $code): ?>
                setTimeout(() => testBranchCode('<?php echo $code; ?>'), <?php echo array_search($code, $requiredBranchCodes) * 500; ?>);
                <?php endforeach; ?>
            };
        </script>
    </div>
</body>
</html>
