<?php
/**
 * أداة لإعادة تعيين أرقام التسلسل في جدول order_sequences
 * تستخدم هذه الأداة للتأكد من أن جميع الفروع تبدأ بترقيم تسلسلي من 01
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/config.php';

// التحقق من وجود جدول order_sequences
try {
    $tableExists = $pdo->query("SHOW TABLES LIKE 'order_sequences'")->rowCount() > 0;

    if (!$tableExists) {
        // إنشاء جدول order_sequences إذا لم يكن موجوداً
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS `order_sequences` (
              `id` INT AUTO_INCREMENT PRIMARY KEY,
              `branch_code` VARCHAR(10) NOT NULL UNIQUE COMMENT 'رمز الفرع',
              `last_sequence_number` INT NOT NULL DEFAULT 0 COMMENT 'آخر رقم تسلسلي',
              `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
              `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
        ");
        echo "<p style='color:green'>تم إنشاء جدول order_sequences بنجاح.</p>";
    }

    // الحصول على بيانات الفروع
    $stmt = $pdo->query("SELECT code FROM branches");
    $branches = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // رموز الفروع الأساسية
    $baseBranchCodes = ['MKL', 'SNA', 'ADN', 'SH', 'CN'];

    // إضافة رموز الفروع من قاعدة البيانات
    foreach ($branches as $branchCode) {
        // استخراج الجزء الأساسي من رمز الفرع (بدون أرقام أو رموز)
        $baseCode = preg_replace('/[0-9-]/', '', $branchCode);
        if (!empty($baseCode) && !in_array($baseCode, $baseBranchCodes)) {
            $baseBranchCodes[] = $baseCode;
        }
    }

    // عرض حالة جدول order_sequences قبل التحديث
    $stmt = $pdo->query("SELECT * FROM order_sequences");
    $sequences = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "<h2>حالة جدول order_sequences قبل التحديث:</h2>";
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>المعرف</th><th>رمز الفرع</th><th>آخر رقم تسلسلي</th><th>تاريخ الإنشاء</th><th>تاريخ التحديث</th></tr>";
    
    foreach ($sequences as $sequence) {
        echo "<tr>";
        echo "<td>{$sequence['id']}</td>";
        echo "<td>{$sequence['branch_code']}</td>";
        echo "<td>{$sequence['last_sequence_number']}</td>";
        echo "<td>{$sequence['created_at']}</td>";
        echo "<td>{$sequence['updated_at']}</td>";
        echo "</tr>";
    }
    
    echo "</table>";

    // التحقق من وجود جميع رموز الفروع في جدول order_sequences
    foreach ($baseBranchCodes as $branchCode) {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM order_sequences WHERE branch_code = ?");
        $stmt->execute([$branchCode]);
        $exists = $stmt->fetchColumn() > 0;

        if (!$exists) {
            // إضافة رمز الفرع إلى جدول order_sequences
            $stmt = $pdo->prepare("INSERT INTO order_sequences (branch_code, last_sequence_number) VALUES (?, 0)");
            $stmt->execute([$branchCode]);
            echo "<p style='color:green'>تم إضافة رمز الفرع {$branchCode} إلى جدول order_sequences.</p>";
        }
    }

    // إعادة تعيين أرقام التسلسل إذا تم تحديد ذلك
    if (isset($_GET['reset']) && $_GET['reset'] === 'true') {
        $stmt = $pdo->prepare("UPDATE order_sequences SET last_sequence_number = 0");
        $stmt->execute();
        echo "<p style='color:green'>تم إعادة تعيين جميع أرقام التسلسل إلى 0 بنجاح.</p>";
    }

    // عرض حالة جدول order_sequences بعد التحديث
    $stmt = $pdo->query("SELECT * FROM order_sequences");
    $sequences = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "<h2>حالة جدول order_sequences بعد التحديث:</h2>";
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>المعرف</th><th>رمز الفرع</th><th>آخر رقم تسلسلي</th><th>تاريخ الإنشاء</th><th>تاريخ التحديث</th></tr>";
    
    foreach ($sequences as $sequence) {
        echo "<tr>";
        echo "<td>{$sequence['id']}</td>";
        echo "<td>{$sequence['branch_code']}</td>";
        echo "<td>{$sequence['last_sequence_number']}</td>";
        echo "<td>{$sequence['created_at']}</td>";
        echo "<td>{$sequence['updated_at']}</td>";
        echo "</tr>";
    }
    
    echo "</table>";

    // عرض رابط لإعادة تعيين أرقام التسلسل
    echo "<p><a href='?reset=true' style='display: inline-block; padding: 10px 15px; background-color: #4f46e5; color: white; text-decoration: none; border-radius: 5px; margin-top: 20px;'>إعادة تعيين جميع أرقام التسلسل إلى 0</a></p>";

} catch (PDOException $e) {
    echo "<p style='color:red'>حدث خطأ: " . $e->getMessage() . "</p>";
}
?>
