<?php
/**
 * أداة للتحقق من وجود أرقام طلبات مكررة
 * تستخدم هذه الأداة للتحقق من وجود أرقام طلبات مكررة في قاعدة البيانات
 * وإصلاحها إذا لزم الأمر
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/config.php';

// دالة لإنشاء رقم طلب جديد فريد
function generateUniqueOrderNumber($pdo, $branchCode, $originalOrderNumber) {
    // استخراج السنة والشهر من رقم الطلب الأصلي
    if (preg_match('/^([A-Z]+)(\d{2})(\d{2})-(\d{3})/', $originalOrderNumber, $matches)) {
        $branchCode = $matches[1];
        $year = $matches[2];
        $month = $matches[3];
        
        // الحصول على آخر رقم تسلسلي للفرع
        $stmt = $pdo->prepare("SELECT last_sequence_number FROM order_sequences WHERE branch_code = ?");
        $stmt->execute([$branchCode]);
        $sequence = $stmt->fetch();
        
        $sequenceNumber = 1;
        if ($sequence) {
            $sequenceNumber = $sequence['last_sequence_number'] + 1;
            $stmt = $pdo->prepare("UPDATE order_sequences SET last_sequence_number = ? WHERE branch_code = ?");
            $stmt->execute([$sequenceNumber, $branchCode]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO order_sequences (branch_code, last_sequence_number) VALUES (?, ?)");
            $stmt->execute([$branchCode, $sequenceNumber]);
        }
        
        // تنسيق رقم الطلب الجديد
        $newOrderNumber = $branchCode . $year . $month . '-' . str_pad($sequenceNumber, 3, '0', STR_PAD_LEFT);
        
        return $newOrderNumber;
    }
    
    // إذا فشل التعبير المنتظم، إنشاء رقم طلب عشوائي
    $randomPart = mt_rand(1000, 9999);
    return $branchCode . date('y') . date('m') . '-' . $randomPart . 'R';
}

// التحقق من وجود أرقام طلبات مكررة
$stmt = $pdo->query("
    SELECT order_number, COUNT(*) as count
    FROM orders
    GROUP BY order_number
    HAVING COUNT(*) > 1
");

$duplicates = $stmt->fetchAll(PDO::FETCH_ASSOC);

// عرض نتائج التحقق
echo "<h1>نتائج التحقق من أرقام الطلبات المكررة</h1>";

if (empty($duplicates)) {
    echo "<p style='color:green'>لا توجد أرقام طلبات مكررة في قاعدة البيانات.</p>";
} else {
    echo "<h2>أرقام الطلبات المكررة:</h2>";
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>رقم الطلب</th><th>عدد التكرارات</th><th>الإجراء</th></tr>";
    
    foreach ($duplicates as $duplicate) {
        echo "<tr>";
        echo "<td>{$duplicate['order_number']}</td>";
        echo "<td>{$duplicate['count']}</td>";
        echo "<td><a href='?fix={$duplicate['order_number']}' style='color:blue'>إصلاح</a></td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    // إصلاح رقم طلب مكرر
    if (isset($_GET['fix'])) {
        $orderNumber = $_GET['fix'];
        
        // الحصول على جميع الطلبات بنفس الرقم
        $stmt = $pdo->prepare("
            SELECT id, order_number, branch_id
            FROM orders
            WHERE order_number = ?
            ORDER BY id
        ");
        $stmt->execute([$orderNumber]);
        $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // الاحتفاظ بأول طلب كما هو وتغيير أرقام الطلبات الأخرى
        $firstOrder = array_shift($orders);
        
        echo "<h3>إصلاح رقم الطلب المكرر: {$orderNumber}</h3>";
        echo "<p>تم الاحتفاظ بالطلب الأول (معرف: {$firstOrder['id']}) برقم الطلب الأصلي.</p>";
        
        echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
        echo "<tr><th>معرف الطلب</th><th>رقم الطلب القديم</th><th>رقم الطلب الجديد</th></tr>";
        
        foreach ($orders as $order) {
            // الحصول على معرف الفرع
            $branchId = $order['branch_id'];
            $branchCode = 'SHP';
            
            // الحصول على رمز الفرع من معرف الفرع
            if ($branchId) {
                $stmt = $pdo->prepare("SELECT code FROM branches WHERE id = ?");
                $stmt->execute([$branchId]);
                $branch = $stmt->fetch();
                
                if ($branch) {
                    $branchCode = $branch['code'];
                }
            }
            
            // إنشاء رقم طلب جديد فريد
            $newOrderNumber = generateUniqueOrderNumber($pdo, $branchCode, $orderNumber);
            
            // تحديث رقم الطلب في قاعدة البيانات
            $stmt = $pdo->prepare("UPDATE orders SET order_number = ? WHERE id = ?");
            $stmt->execute([$newOrderNumber, $order['id']]);
            
            echo "<tr>";
            echo "<td>{$order['id']}</td>";
            echo "<td>{$orderNumber}</td>";
            echo "<td>{$newOrderNumber}</td>";
            echo "</tr>";
        }
        
        echo "</table>";
        
        // تسجيل عملية الإصلاح
        $logMessage = date('Y-m-d H:i:s') . " - تم إصلاح رقم الطلب المكرر: {$orderNumber}\n";
        file_put_contents('../logs/fixed_duplicate_orders.log', $logMessage, FILE_APPEND);
        
        echo "<p style='color:green'>تم إصلاح رقم الطلب المكرر بنجاح.</p>";
        echo "<p><a href='check_duplicate_orders.php' style='color:blue'>العودة إلى قائمة الأرقام المكررة</a></p>";
    }
}

// عرض رابط للعودة إلى صفحة الأدوات
echo "<p><a href='test_sequence_api.php' style='display: inline-block; padding: 10px 15px; background-color: #4f46e5; color: white; text-decoration: none; border-radius: 5px; margin-top: 20px;'>العودة إلى اختبار API</a></p>";
?>
