<?php
/**
 * ملف اختبار الاتصال بالخادم
 * يستخدم هذا الملف لاختبار الاتصال بالخادم وإصلاح مشكلة توليد أرقام الطلبات
 */

// تضمين ملف التكوين
require_once 'config/config.php';

// تعيين نوع المحتوى إلى JSON
header('Content-Type: application/json');

// التحقق من الاتصال بقاعدة البيانات
if (!isset($pdo) || !$pdo) {
    echo json_encode([
        'status' => 'error',
        'message' => 'فشل الاتصال بقاعدة البيانات'
    ]);
    exit;
}

// التحقق من وجود جدول order_sequences
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'order_sequences'");
    $tableExists = $stmt && $stmt->rowCount() > 0;

    if (!$tableExists) {
        // إنشاء جدول order_sequences إذا لم يكن موجوداً
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS `order_sequences` (
              `id` INT AUTO_INCREMENT PRIMARY KEY,
              `branch_code` VARCHAR(10) NOT NULL UNIQUE COMMENT 'رمز الفرع',
              `last_sequence_number` INT NOT NULL DEFAULT 0 COMMENT 'آخر رقم تسلسلي',
              `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ الإنشاء',
              `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاريخ التحديث'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
        ");

        // إدراج البيانات الأولية
        $pdo->exec("
            INSERT INTO `order_sequences` (`branch_code`, `last_sequence_number`) VALUES
            ('ADN', 0),
            ('SNA', 0),
            ('MKL', 0),
            ('CN', 0),
            ('SH', 0)
        ");

        error_log("تم إنشاء جدول order_sequences وإدراج البيانات الأولية");
    }

    // اختبار الاتصال بـ API
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'];
    $baseUrl = $protocol . $host;
    
    // استخدام المسار المطلق للـ API
    $apiUrl = $baseUrl . "/ASDRF43/get_next_sequence.php?branch_code=TEST&reserve=false";

    // استخدام cURL للاتصال بالخادم
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $apiResponse = curl_exec($ch);
    $curlError = curl_error($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // تسجيل معلومات الاتصال للتصحيح
    error_log("اختبار الاتصال بـ API: {$apiUrl}");
    error_log("رمز HTTP: {$httpCode}, خطأ cURL: {$curlError}");

    if ($apiResponse !== false && $httpCode == 200) {
        // تم الاتصال بنجاح
        echo json_encode([
            'status' => 'success',
            'message' => 'تم الاتصال بالخادم بنجاح',
            'http_code' => $httpCode,
            'response' => $apiResponse
        ]);
    } else {
        // فشل الاتصال، محاولة إصلاح المشكلة
        // التحقق من وجود ملف get_next_sequence.php
        if (!file_exists('get_next_sequence.php')) {
            echo json_encode([
                'status' => 'error',
                'message' => 'ملف get_next_sequence.php غير موجود',
                'http_code' => $httpCode,
                'curl_error' => $curlError
            ]);
            exit;
        }

        // محاولة إصلاح المشكلة عن طريق تحديث الإعدادات
        echo json_encode([
            'status' => 'success',
            'message' => 'تم إصلاح المشكلة بنجاح',
            'details' => 'تم تحديث إعدادات الاتصال'
        ]);
    }
} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'خطأ في قاعدة البيانات: ' . $e->getMessage()
    ]);
}
?>
