<?php
/**
 * ملف التحقق من تسجيل دخول المستخدم
 * يستخدم هذا الملف للتحقق من تسجيل دخول المستخدم قبل عرض صفحات الدعم الفني
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// بدء الجلسة
session_start();

// تضمين ملف التكوين
require_once '../config/config.php';

// تضمين ملف إدارة الصلاحيات
require_once '../includes/permissions.php';

// التحقق من وجود وضع التطوير
$devMode = defined('DEBUG_MODE') && DEBUG_MODE === true;

// التحقق من تسجيل دخول المستخدم
if (!isset($_SESSION['user_id']) && !$devMode) {
    // إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
    header('Location: ../auth/login.php');
    exit;
}

// التحقق من صلاحية عرض الدعم الفني
if (!hasPermission('support_view')) {
    // إعادة توجيه المستخدم إلى صفحة رفض الوصول
    header('Location: ../auth/access_denied.php');
    exit;
}

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

// إذا كان في وضع التطوير ولم يتم تعيين معرف المستخدم، قم بتعيينه
if ($devMode && !isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1;
    $_SESSION['username'] = 'admin';
    $_SESSION['full_name'] = 'مدير النظام';
    $_SESSION['role'] = 'admin';
    $_SESSION['branch_id'] = 1;
    $_SESSION['logged_in'] = true;
}

// الحصول على معلومات المستخدم الحالي
$userId = $_SESSION['user_id'];

try {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$userId]);
    $currentUser = $stmt->fetch();

    // التحقق من وجود المستخدم
    if (!$currentUser) {
        if ($devMode) {
            // في وضع التطوير، قم بإنشاء مستخدم افتراضي
            $hashedPassword = password_hash('admin123', PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("
                INSERT INTO users (id, username, full_name, email, password, role, status, phone)
                VALUES (1, 'admin', 'مدير النظام', 'admin@example.com', ?, 'admin', 'active', '+967 123456789')
                ON DUPLICATE KEY UPDATE id = 1
            ");
            $stmt->execute([$hashedPassword]);

            // إعادة محاولة الحصول على معلومات المستخدم
            $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
            $stmt->execute([$userId]);
            $currentUser = $stmt->fetch();

            if (!$currentUser) {
                throw new Exception("فشل إنشاء المستخدم الافتراضي");
            }
        } else {
            // في وضع الإنتاج، قم بتسجيل خروج المستخدم
            session_destroy();
            header('Location: ../auth/login.php');
            exit;
        }
    }

    // التحقق من حالة المستخدم (تجاهل في وضع التطوير)
    if (!$devMode && isset($currentUser['is_active']) && $currentUser['is_active'] != 1) {
        // تسجيل خروج المستخدم وإعادة توجيهه إلى صفحة تسجيل الدخول مع رسالة خطأ
        session_destroy();
        $_SESSION['login_error'] = 'تم تعطيل حسابك. يرجى التواصل مع مسؤول النظام.';
        header('Location: ../auth/login.php');
        exit;
    }
} catch (Exception $e) {
    if ($devMode) {
        // في وضع التطوير، عرض رسالة الخطأ
        echo "<div style='background-color: #ffdddd; color: #990000; padding: 10px; margin: 10px 0; border: 1px solid #990000;'>";
        echo "<h3>خطأ في التحقق من المستخدم:</h3>";
        echo "<p>" . $e->getMessage() . "</p>";
        echo "<p>يرجى التأكد من إعداد قاعدة البيانات بشكل صحيح.</p>";
        echo "<p><a href='../setup_database.php'>انقر هنا لإعداد قاعدة البيانات</a></p>";
        echo "</div>";
    } else {
        // في وضع الإنتاج، إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
        session_destroy();
        header('Location: ../auth/login.php');
        exit;
    }
}
?>
