<?php
/**
 * ملف لإصلاح هيكل جدول المستخدمين في SQLite
 */

// تضمين ملف التكوين
require_once 'config/config_new.php';

// عرض رسالة بداية العملية
echo "<h1>بدء عملية إصلاح جدول المستخدمين في SQLite</h1>";
echo "<p>جاري التحقق من هيكل الجدول...</p>";

try {
    // الحصول على هيكل الجدول
    $tableInfoStmt = $pdo->prepare("PRAGMA table_info(users)");
    $tableInfoStmt->execute();
    $columns = $tableInfoStmt->fetchAll(PDO::FETCH_ASSOC);
    
    // التحقق من وجود عمود fullname
    $fullnameExists = false;
    $fullNameExists = false;
    
    foreach ($columns as $column) {
        if ($column['name'] === 'fullname') {
            $fullnameExists = true;
        }
        if ($column['name'] === 'full_name') {
            $fullNameExists = true;
        }
    }
    
    if ($fullnameExists && !$fullNameExists) {
        echo "<p>تم العثور على عمود 'fullname'. جاري تغيير اسمه إلى 'full_name'...</p>";
        
        // في SQLite، لا يمكن تغيير اسم العمود مباشرة، لذلك نحتاج إلى إنشاء جدول جديد ونسخ البيانات
        
        // 1. إنشاء جدول مؤقت بالهيكل الجديد
        $pdo->exec("CREATE TABLE users_new (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            username TEXT NOT NULL UNIQUE,
            full_name TEXT NOT NULL,
            email TEXT NOT NULL UNIQUE,
            password TEXT NOT NULL,
            role TEXT NOT NULL DEFAULT 'user',
            status TEXT NOT NULL DEFAULT 'pending',
            phone TEXT,
            registration_date TIMESTAMP,
            branch_id INTEGER,
            last_login TIMESTAMP,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (branch_id) REFERENCES branches(id) ON DELETE SET NULL
        )");
        
        // 2. نسخ البيانات من الجدول القديم إلى الجدول الجديد
        $pdo->exec("INSERT INTO users_new (id, username, full_name, email, password, role, status, phone, registration_date, branch_id, last_login, created_at, updated_at)
                    SELECT id, username, fullname, email, password, role, status, phone, registration_date, branch_id, last_login, created_at, updated_at FROM users");
        
        // 3. حذف الجدول القديم
        $pdo->exec("DROP TABLE users");
        
        // 4. إعادة تسمية الجدول الجديد
        $pdo->exec("ALTER TABLE users_new RENAME TO users");
        
        echo "<p style='color: green;'>تم تغيير اسم العمود بنجاح!</p>";
    } else if ($fullNameExists) {
        echo "<p style='color: green;'>العمود 'full_name' موجود بالفعل. لا حاجة للتعديل.</p>";
    } else {
        echo "<p style='color: red;'>لم يتم العثور على عمود 'fullname' أو 'full_name'. يرجى التحقق من هيكل الجدول.</p>";
    }
    
    // عرض هيكل الجدول بعد التعديل
    echo "<h2>هيكل جدول المستخدمين بعد التعديل:</h2>";
    $tableInfoStmt = $pdo->prepare("PRAGMA table_info(users)");
    $tableInfoStmt->execute();
    $columns = $tableInfoStmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>cid</th><th>اسم العمود</th><th>النوع</th><th>NotNull</th><th>Default</th><th>PK</th></tr>";
    
    foreach ($columns as $column) {
        echo "<tr>";
        echo "<td>{$column['cid']}</td>";
        echo "<td>{$column['name']}</td>";
        echo "<td>{$column['type']}</td>";
        echo "<td>{$column['notnull']}</td>";
        echo "<td>{$column['dflt_value']}</td>";
        echo "<td>{$column['pk']}</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    echo "<p>تم الانتهاء من عملية الإصلاح. يمكنك الآن <a href='register.php'>إنشاء حساب جديد</a> أو <a href='login.php'>تسجيل الدخول</a>.</p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>حدث خطأ أثناء تعديل الجدول: " . $e->getMessage() . "</p>";
}
?>
