<?php
/**
 * ملف لإصلاح قاعدة البيانات بشكل شامل
 */

// تفعيل عرض الأخطاء
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// عرض رسالة بداية العملية
echo "<h1>إصلاح قاعدة البيانات بشكل شامل</h1>";

// تضمين ملف التكوين
echo "<h2>تضمين ملف التكوين</h2>";
try {
    require_once 'config/config.php';
    echo "<p style='color: green;'>تم تضمين ملف التكوين بنجاح.</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>حدث خطأ أثناء تضمين ملف التكوين: " . $e->getMessage() . "</p>";
    exit;
}

// التحقق من اتصال قاعدة البيانات
echo "<h2>التحقق من اتصال قاعدة البيانات</h2>";
if (isset($pdo)) {
    echo "<p style='color: green;'>تم الاتصال بقاعدة البيانات بنجاح.</p>";
    
    // عرض معلومات قاعدة البيانات
    $dbType = $pdo->getAttribute(PDO::ATTR_DRIVER_NAME);
    echo "<p>نوع قاعدة البيانات: " . $dbType . "</p>";
    echo "<p>إصدار قاعدة البيانات: " . $pdo->getAttribute(PDO::ATTR_SERVER_VERSION) . "</p>";
} else {
    echo "<p style='color: red;'>فشل الاتصال بقاعدة البيانات.</p>";
    exit;
}

// التحقق من وجود جدول المستخدمين
echo "<h2>التحقق من وجود جدول المستخدمين</h2>";
try {
    if ($dbType === 'mysql') {
        $tableCheckStmt = $pdo->prepare("SHOW TABLES LIKE 'users'");
    } else {
        $tableCheckStmt = $pdo->prepare("SELECT name FROM sqlite_master WHERE type='table' AND name='users'");
    }
    
    $tableCheckStmt->execute();
    $tableExists = $tableCheckStmt->rowCount() > 0;
    
    if ($tableExists) {
        echo "<p style='color: green;'>جدول المستخدمين موجود.</p>";
    } else {
        echo "<p style='color: red;'>جدول المستخدمين غير موجود.</p>";
        
        // إنشاء جدول المستخدمين
        echo "<h3>إنشاء جدول المستخدمين</h3>";
        
        if ($dbType === 'mysql') {
            $createTableStmt = $pdo->prepare("
                CREATE TABLE users (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    username VARCHAR(50) NOT NULL UNIQUE,
                    password VARCHAR(255) NOT NULL,
                    full_name VARCHAR(100) NOT NULL,
                    email VARCHAR(100) NOT NULL UNIQUE,
                    phone VARCHAR(20),
                    role ENUM('admin', 'manager', 'employee', 'client') NOT NULL DEFAULT 'client',
                    status ENUM('pending', 'active', 'inactive') NOT NULL DEFAULT 'pending',
                    registration_date TIMESTAMP NULL DEFAULT NULL,
                    branch_id INT,
                    last_login DATETIME,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
            ");
        } else {
            $createTableStmt = $pdo->prepare("
                CREATE TABLE users (
                    id INTEGER PRIMARY KEY AUTOINCREMENT,
                    username TEXT NOT NULL UNIQUE,
                    password TEXT NOT NULL,
                    full_name TEXT NOT NULL,
                    email TEXT NOT NULL UNIQUE,
                    phone TEXT,
                    role TEXT NOT NULL DEFAULT 'client',
                    status TEXT NOT NULL DEFAULT 'pending',
                    registration_date TIMESTAMP,
                    branch_id INTEGER,
                    last_login TIMESTAMP,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
                )
            ");
        }
        
        $createTableStmt->execute();
        echo "<p style='color: green;'>تم إنشاء جدول المستخدمين بنجاح.</p>";
    }
} catch (PDOException $e) {
    echo "<p style='color: red;'>حدث خطأ أثناء التحقق من وجود جدول المستخدمين: " . $e->getMessage() . "</p>";
}

// التحقق من هيكل جدول المستخدمين
echo "<h2>التحقق من هيكل جدول المستخدمين</h2>";
try {
    if ($dbType === 'mysql') {
        $tableStructureStmt = $pdo->prepare("DESCRIBE users");
    } else {
        $tableStructureStmt = $pdo->prepare("PRAGMA table_info(users)");
    }
    
    $tableStructureStmt->execute();
    $columns = $tableStructureStmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h3>هيكل جدول المستخدمين الحالي:</h3>";
    echo "<table border='1' cellpadding='5'>";
    
    if ($dbType === 'mysql') {
        echo "<tr><th>اسم العمود</th><th>النوع</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        
        foreach ($columns as $column) {
            echo "<tr>";
            echo "<td>{$column['Field']}</td>";
            echo "<td>{$column['Type']}</td>";
            echo "<td>{$column['Null']}</td>";
            echo "<td>{$column['Key']}</td>";
            echo "<td>{$column['Default']}</td>";
            echo "<td>{$column['Extra']}</td>";
            echo "</tr>";
        }
    } else {
        echo "<tr><th>cid</th><th>اسم العمود</th><th>النوع</th><th>NotNull</th><th>Default</th><th>PK</th></tr>";
        
        foreach ($columns as $column) {
            echo "<tr>";
            echo "<td>{$column['cid']}</td>";
            echo "<td>{$column['name']}</td>";
            echo "<td>{$column['type']}</td>";
            echo "<td>{$column['notnull']}</td>";
            echo "<td>{$column['dflt_value']}</td>";
            echo "<td>{$column['pk']}</td>";
            echo "</tr>";
        }
    }
    
    echo "</table>";
    
    // التحقق من وجود عمود full_name أو fullname
    $fullNameColumnExists = false;
    $fullnameColumnExists = false;
    
    if ($dbType === 'mysql') {
        foreach ($columns as $column) {
            if ($column['Field'] === 'full_name') {
                $fullNameColumnExists = true;
            } else if ($column['Field'] === 'fullname') {
                $fullnameColumnExists = true;
            }
        }
    } else {
        foreach ($columns as $column) {
            if ($column['name'] === 'full_name') {
                $fullNameColumnExists = true;
            } else if ($column['name'] === 'fullname') {
                $fullnameColumnExists = true;
            }
        }
    }
    
    echo "<p>عمود full_name موجود: " . ($fullNameColumnExists ? 'نعم' : 'لا') . "</p>";
    echo "<p>عمود fullname موجود: " . ($fullnameColumnExists ? 'نعم' : 'لا') . "</p>";
    
    // إصلاح هيكل جدول المستخدمين
    if ($fullnameColumnExists && !$fullNameColumnExists) {
        echo "<h3>تغيير اسم العمود من fullname إلى full_name</h3>";
        
        if ($dbType === 'mysql') {
            $alterTableStmt = $pdo->prepare("ALTER TABLE users CHANGE fullname full_name VARCHAR(100) NOT NULL");
            $alterTableStmt->execute();
            echo "<p style='color: green;'>تم تغيير اسم العمود بنجاح.</p>";
        } else {
            // في SQLite، لا يمكن تغيير اسم العمود مباشرة، لذلك نحتاج إلى إنشاء جدول جديد ونسخ البيانات
            echo "<p>في SQLite، لا يمكن تغيير اسم العمود مباشرة. جاري إنشاء جدول جديد ونسخ البيانات...</p>";
            
            // 1. إنشاء جدول مؤقت بالهيكل الجديد
            $pdo->exec("CREATE TABLE users_new (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                username TEXT NOT NULL UNIQUE,
                full_name TEXT NOT NULL,
                email TEXT NOT NULL UNIQUE,
                password TEXT NOT NULL,
                role TEXT NOT NULL DEFAULT 'client',
                status TEXT NOT NULL DEFAULT 'pending',
                phone TEXT,
                registration_date TIMESTAMP,
                branch_id INTEGER,
                last_login TIMESTAMP,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )");
            
            // 2. نسخ البيانات من الجدول القديم إلى الجدول الجديد
            $pdo->exec("INSERT INTO users_new (id, username, full_name, email, password, role, status, phone, registration_date, branch_id, last_login, created_at, updated_at)
                        SELECT id, username, fullname, email, password, role, status, phone, registration_date, branch_id, last_login, created_at, updated_at FROM users");
            
            // 3. حذف الجدول القديم
            $pdo->exec("DROP TABLE users");
            
            // 4. إعادة تسمية الجدول الجديد
            $pdo->exec("ALTER TABLE users_new RENAME TO users");
            
            echo "<p style='color: green;'>تم تغيير اسم العمود بنجاح.</p>";
        }
        
        // عرض هيكل الجدول بعد التعديل
        echo "<h3>هيكل جدول المستخدمين بعد التعديل:</h3>";
        
        if ($dbType === 'mysql') {
            $tableStructureStmt = $pdo->prepare("DESCRIBE users");
        } else {
            $tableStructureStmt = $pdo->prepare("PRAGMA table_info(users)");
        }
        
        $tableStructureStmt->execute();
        $columns = $tableStructureStmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<table border='1' cellpadding='5'>";
        
        if ($dbType === 'mysql') {
            echo "<tr><th>اسم العمود</th><th>النوع</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
            
            foreach ($columns as $column) {
                echo "<tr>";
                echo "<td>{$column['Field']}</td>";
                echo "<td>{$column['Type']}</td>";
                echo "<td>{$column['Null']}</td>";
                echo "<td>{$column['Key']}</td>";
                echo "<td>{$column['Default']}</td>";
                echo "<td>{$column['Extra']}</td>";
                echo "</tr>";
            }
        } else {
            echo "<tr><th>cid</th><th>اسم العمود</th><th>النوع</th><th>NotNull</th><th>Default</th><th>PK</th></tr>";
            
            foreach ($columns as $column) {
                echo "<tr>";
                echo "<td>{$column['cid']}</td>";
                echo "<td>{$column['name']}</td>";
                echo "<td>{$column['type']}</td>";
                echo "<td>{$column['notnull']}</td>";
                echo "<td>{$column['dflt_value']}</td>";
                echo "<td>{$column['pk']}</td>";
                echo "</tr>";
            }
        }
        
        echo "</table>";
    } else if ($fullNameColumnExists) {
        echo "<p style='color: green;'>العمود full_name موجود بالفعل. لا حاجة للتعديل.</p>";
    } else if (!$fullNameColumnExists && !$fullnameColumnExists) {
        echo "<p style='color: red;'>لم يتم العثور على عمود full_name أو fullname في جدول المستخدمين.</p>";
        
        // إضافة عمود full_name
        echo "<h3>إضافة عمود full_name</h3>";
        
        if ($dbType === 'mysql') {
            $alterTableStmt = $pdo->prepare("ALTER TABLE users ADD COLUMN full_name VARCHAR(100) NOT NULL AFTER password");
        } else {
            $alterTableStmt = $pdo->prepare("ALTER TABLE users ADD COLUMN full_name TEXT NOT NULL DEFAULT ''");
        }
        
        $alterTableStmt->execute();
        echo "<p style='color: green;'>تم إضافة عمود full_name بنجاح.</p>";
        
        // عرض هيكل الجدول بعد التعديل
        echo "<h3>هيكل جدول المستخدمين بعد التعديل:</h3>";
        
        if ($dbType === 'mysql') {
            $tableStructureStmt = $pdo->prepare("DESCRIBE users");
        } else {
            $tableStructureStmt = $pdo->prepare("PRAGMA table_info(users)");
        }
        
        $tableStructureStmt->execute();
        $columns = $tableStructureStmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<table border='1' cellpadding='5'>";
        
        if ($dbType === 'mysql') {
            echo "<tr><th>اسم العمود</th><th>النوع</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
            
            foreach ($columns as $column) {
                echo "<tr>";
                echo "<td>{$column['Field']}</td>";
                echo "<td>{$column['Type']}</td>";
                echo "<td>{$column['Null']}</td>";
                echo "<td>{$column['Key']}</td>";
                echo "<td>{$column['Default']}</td>";
                echo "<td>{$column['Extra']}</td>";
                echo "</tr>";
            }
        } else {
            echo "<tr><th>cid</th><th>اسم العمود</th><th>النوع</th><th>NotNull</th><th>Default</th><th>PK</th></tr>";
            
            foreach ($columns as $column) {
                echo "<tr>";
                echo "<td>{$column['cid']}</td>";
                echo "<td>{$column['name']}</td>";
                echo "<td>{$column['type']}</td>";
                echo "<td>{$column['notnull']}</td>";
                echo "<td>{$column['dflt_value']}</td>";
                echo "<td>{$column['pk']}</td>";
                echo "</tr>";
            }
        }
        
        echo "</table>";
    }
} catch (PDOException $e) {
    echo "<p style='color: red;'>حدث خطأ أثناء التحقق من هيكل جدول المستخدمين: " . $e->getMessage() . "</p>";
}

echo "<p>تم الانتهاء من عملية الإصلاح. يمكنك الآن <a href='register.php'>إنشاء حساب جديد</a> أو <a href='login.php'>تسجيل الدخول</a>.</p>";
?>
