<?php
/**
 * ملف لإصلاح هيكل جدول المستخدمين
 */

// تضمين ملف التكوين
require_once 'config/config.php';

// عرض رسالة بداية العملية
echo "<h1>بدء عملية إصلاح جدول المستخدمين</h1>";
echo "<p>جاري التحقق من هيكل الجدول...</p>";

try {
    // التحقق من وجود عمود fullname
    $checkColumnStmt = $pdo->prepare("SHOW COLUMNS FROM `users` LIKE 'fullname'");
    $checkColumnStmt->execute();
    $columnExists = $checkColumnStmt->rowCount() > 0;

    if ($columnExists) {
        echo "<p>تم العثور على عمود 'fullname'. جاري تغيير اسمه إلى 'full_name'...</p>";
        
        // تغيير اسم العمود من fullname إلى full_name
        $alterTableStmt = $pdo->prepare("ALTER TABLE `users` CHANGE `fullname` `full_name` VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL");
        $alterTableStmt->execute();
        
        echo "<p style='color: green;'>تم تغيير اسم العمود بنجاح!</p>";
    } else {
        // التحقق من وجود عمود full_name
        $checkNewColumnStmt = $pdo->prepare("SHOW COLUMNS FROM `users` LIKE 'full_name'");
        $checkNewColumnStmt->execute();
        $newColumnExists = $checkNewColumnStmt->rowCount() > 0;
        
        if ($newColumnExists) {
            echo "<p style='color: green;'>العمود 'full_name' موجود بالفعل. لا حاجة للتعديل.</p>";
        } else {
            echo "<p style='color: red;'>لم يتم العثور على عمود 'fullname' أو 'full_name'. يرجى التحقق من هيكل الجدول.</p>";
        }
    }
    
    // عرض هيكل الجدول بعد التعديل
    echo "<h2>هيكل جدول المستخدمين بعد التعديل:</h2>";
    $tableStructureStmt = $pdo->prepare("DESCRIBE `users`");
    $tableStructureStmt->execute();
    $columns = $tableStructureStmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>اسم العمود</th><th>النوع</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    
    foreach ($columns as $column) {
        echo "<tr>";
        echo "<td>{$column['Field']}</td>";
        echo "<td>{$column['Type']}</td>";
        echo "<td>{$column['Null']}</td>";
        echo "<td>{$column['Key']}</td>";
        echo "<td>{$column['Default']}</td>";
        echo "<td>{$column['Extra']}</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    echo "<p>تم الانتهاء من عملية الإصلاح. يمكنك الآن <a href='register.php'>إنشاء حساب جديد</a> أو <a href='login.php'>تسجيل الدخول</a>.</p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>حدث خطأ أثناء تعديل الجدول: " . $e->getMessage() . "</p>";
}
?>
