<?php
/**
 * ملف تشخيصي لعرض معلومات عن قاعدة البيانات
 */

// تضمين ملف التكوين
require_once 'config/config_new.php';

// التحقق من وجود جدول المستخدمين
function checkUsersTable() {
    global $conn;
    
    try {
        // التحقق من وجود جدول المستخدمين
        $result = $conn->query("SELECT name FROM sqlite_master WHERE type='table' AND name='users'");
        $tableExists = $result->rowCount() > 0;
        
        if ($tableExists) {
            // الحصول على هيكل الجدول
            $result = $conn->query("PRAGMA table_info(users)");
            $columns = $result->fetchAll();
            
            // الحصول على عدد المستخدمين
            $result = $conn->query("SELECT COUNT(*) as count FROM users");
            $count = $result->fetch()['count'];
            
            return [
                'exists' => true,
                'columns' => $columns,
                'count' => $count
            ];
        } else {
            return [
                'exists' => false
            ];
        }
    } catch (Exception $e) {
        return [
            'exists' => false,
            'error' => $e->getMessage()
        ];
    }
}

// الحصول على معلومات قاعدة البيانات
$dbInfo = [
    'type' => $use_mysql ? 'MySQL' : 'SQLite',
    'file' => $use_mysql ? 'N/A' : $db_file,
    'users_table' => checkUsersTable()
];
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>معلومات قاعدة البيانات</title>
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        h1, h2 {
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
        .success {
            color: green;
        }
        .error {
            color: red;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>معلومات قاعدة البيانات</h1>
        
        <h2>معلومات عامة</h2>
        <table>
            <tr>
                <th>نوع قاعدة البيانات</th>
                <td><?php echo $dbInfo['type']; ?></td>
            </tr>
            <tr>
                <th>مسار الملف</th>
                <td><?php echo $dbInfo['file']; ?></td>
            </tr>
        </table>
        
        <h2>جدول المستخدمين</h2>
        <?php if ($dbInfo['users_table']['exists']): ?>
            <p class="success">جدول المستخدمين موجود</p>
            <p>عدد المستخدمين: <?php echo $dbInfo['users_table']['count']; ?></p>
            
            <h3>هيكل الجدول</h3>
            <table>
                <tr>
                    <th>اسم العمود</th>
                    <th>النوع</th>
                    <th>إلزامي</th>
                    <th>افتراضي</th>
                </tr>
                <?php foreach ($dbInfo['users_table']['columns'] as $column): ?>
                <tr>
                    <td><?php echo $column['name']; ?></td>
                    <td><?php echo $column['type']; ?></td>
                    <td><?php echo $column['notnull'] ? 'نعم' : 'لا'; ?></td>
                    <td><?php echo $column['dflt_value'] ?? 'لا يوجد'; ?></td>
                </tr>
                <?php endforeach; ?>
            </table>
        <?php else: ?>
            <p class="error">جدول المستخدمين غير موجود</p>
            <?php if (isset($dbInfo['users_table']['error'])): ?>
                <p>الخطأ: <?php echo $dbInfo['users_table']['error']; ?></p>
            <?php endif; ?>
        <?php endif; ?>
        
        <p><a href="register.php">العودة إلى صفحة التسجيل</a></p>
    </div>
</body>
</html>
