<?php
/**
 * ملف إنشاء قاعدة البيانات
 * يستخدم هذا الملف لإنشاء قاعدة البيانات إذا لم تكن موجودة
 */

// عرض جميع الأخطاء للمساعدة في التشخيص
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<!DOCTYPE html>
<html dir='rtl' lang='ar'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>إنشاء قاعدة البيانات</title>
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
            margin: 20px;
            line-height: 1.6;
            direction: rtl;
        }
        h1, h2 {
            color: #0a2056;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f8fafc;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .success {
            color: green;
            background-color: #e6f7e6;
            padding: 10px;
            border-radius: 5px;
            margin: 10px 0;
        }
        .error {
            color: red;
            background-color: #fee2e2;
            padding: 10px;
            border-radius: 5px;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class='container'>
        <h1>إنشاء قاعدة البيانات</h1>";

// معلومات الاتصال بقاعدة البيانات
$host = 'localhost';
$dbname = 'shipping_db';
$username = 'root';
$password = '';

// اختبار الاتصال بالخادم أولاً (بدون تحديد قاعدة البيانات)
try {
    $serverConn = new PDO("mysql:host=$host", $username, $password);
    $serverConn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<div class='success'>تم الاتصال بخادم قاعدة البيانات بنجاح.</div>";
    
    // التحقق من وجود قاعدة البيانات
    $stmt = $serverConn->query("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '$dbname'");
    $dbExists = $stmt->rowCount() > 0;
    
    if (!$dbExists) {
        echo "<div class='error'>قاعدة البيانات '$dbname' غير موجودة.</div>";
        echo "<div>سيتم محاولة إنشاء قاعدة البيانات...</div>";
        
        // إنشاء قاعدة البيانات
        $serverConn->exec("CREATE DATABASE `$dbname` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        echo "<div class='success'>تم إنشاء قاعدة البيانات '$dbname' بنجاح.</div>";
        
        echo "<div>يمكنك الآن تشغيل ملف <a href='test_db_connection_updated.php'>test_db_connection_updated.php</a> للتحقق من صحة الاتصال بقاعدة البيانات.</div>";
    } else {
        echo "<div class='success'>قاعدة البيانات '$dbname' موجودة بالفعل.</div>";
        echo "<div>يمكنك الآن تشغيل ملف <a href='test_db_connection_updated.php'>test_db_connection_updated.php</a> للتحقق من صحة الاتصال بقاعدة البيانات.</div>";
    }
    
} catch (PDOException $e) {
    echo "<div class='error'>فشل الاتصال بخادم قاعدة البيانات: " . $e->getMessage() . "</div>";
}

echo "</div></body></html>";
?>
