<?php
/**
 * صفحة إعداد قاعدة البيانات
 * تستخدم هذه الصفحة لإنشاء قاعدة البيانات وجداولها
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تعيين وقت التنفيذ الأقصى
set_time_limit(300);

// تعيين حد الذاكرة
ini_set('memory_limit', '256M');

// تضمين ملف التكوين
require_once 'config/config.php';

// دالة لإنشاء قاعدة البيانات
function createDatabase($host, $user, $pass, $dbname) {
    try {
        // إنشاء اتصال بالخادم بدون تحديد قاعدة البيانات
        $pdo = new PDO("mysql:host=$host", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // إنشاء قاعدة البيانات إذا لم تكن موجودة
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        
        return [
            'status' => 'success',
            'message' => "تم إنشاء قاعدة البيانات $dbname بنجاح أو كانت موجودة بالفعل."
        ];
    } catch (PDOException $e) {
        return [
            'status' => 'error',
            'message' => "خطأ في إنشاء قاعدة البيانات: " . $e->getMessage()
        ];
    }
}

// دالة لتنفيذ ملف SQL
function executeSqlFile($pdo, $filename) {
    try {
        // التحقق من وجود الملف
        if (!file_exists($filename)) {
            return [
                'status' => 'error',
                'message' => "الملف $filename غير موجود"
            ];
        }

        // قراءة محتوى الملف
        $sql = file_get_contents($filename);
        if ($sql === false) {
            return [
                'status' => 'error',
                'message' => "فشل في قراءة محتوى الملف $filename"
            ];
        }

        // تقسيم الاستعلامات
        $queries = explode(';', $sql);

        // تنفيذ كل استعلام
        foreach ($queries as $query) {
            $query = trim($query);
            if (!empty($query)) {
                // استبدال DELIMITER لتجنب الأخطاء
                if (strpos($query, 'DELIMITER') === 0) {
                    continue;
                }

                // تجاهل الأسطر التي تبدأ بـ -- (تعليقات SQL)
                if (strpos($query, '--') === 0) {
                    continue;
                }

                // تجاهل استعلامات USE و CREATE DATABASE
                if (strpos($query, 'USE ') === 0 || strpos($query, 'CREATE DATABASE') === 0) {
                    continue;
                }

                $pdo->exec($query);
            }
        }

        return [
            'status' => 'success',
            'message' => "تم تنفيذ الملف $filename بنجاح"
        ];
    } catch (PDOException $e) {
        return [
            'status' => 'error',
            'message' => "خطأ في تنفيذ الملف $filename: " . $e->getMessage()
        ];
    }
}

// معالجة النموذج
$result = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // إنشاء قاعدة البيانات
    $dbResult = createDatabase($db_host, $db_user, $db_pass, $db_name);
    
    if ($dbResult['status'] === 'success') {
        // إنشاء اتصال بقاعدة البيانات
        try {
            $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // تنفيذ ملف SQL
            $sqlResult = executeSqlFile($pdo, 'database/final_unified_database.sql');
            
            if ($sqlResult['status'] === 'success') {
                $result = [
                    'status' => 'success',
                    'message' => "تم إعداد قاعدة البيانات بنجاح."
                ];
            } else {
                $result = $sqlResult;
            }
        } catch (PDOException $e) {
            $result = [
                'status' => 'error',
                'message' => "خطأ في الاتصال بقاعدة البيانات: " . $e->getMessage()
            ];
        }
    } else {
        $result = $dbResult;
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعداد قاعدة البيانات</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        h1 {
            color: #333;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .btn {
            padding: 10px 15px;
            background-color: #4f46e5;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #3730a3;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        .alert-success {
            background-color: #d1fae5;
            color: #065f46;
            border: 1px solid #10b981;
        }
        .alert-danger {
            background-color: #fee2e2;
            color: #b91c1c;
            border: 1px solid #ef4444;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>إعداد قاعدة البيانات</h1>
        
        <?php if ($result): ?>
            <div class="alert <?php echo $result['status'] === 'success' ? 'alert-success' : 'alert-danger'; ?>">
                <?php echo $result['message']; ?>
            </div>
            
            <?php if ($result['status'] === 'success'): ?>
                <p>تم إعداد قاعدة البيانات بنجاح. يمكنك الآن:</p>
                <ul>
                    <li><a href="admin/dashboard-direct.php">الذهاب إلى لوحة تحكم الإدارة</a></li>
                    <li><a href="home.php">الذهاب إلى الصفحة الرئيسية</a></li>
                </ul>
            <?php endif; ?>
        <?php endif; ?>
        
        <form method="post" action="">
            <div class="form-group">
                <p>سيقوم هذا الإجراء بإنشاء قاعدة البيانات وجداولها. هل أنت متأكد من المتابعة؟</p>
                <p><strong>ملاحظة:</strong> إذا كانت قاعدة البيانات موجودة بالفعل، سيتم استخدامها.</p>
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn">إعداد قاعدة البيانات</button>
            </div>
        </form>
    </div>
</body>
</html>
