<?php
// تضمين ملف التحقق من تسجيل الدخول
require_once '../orders/check_auth.php';

// التحقق من صلاحيات المستخدم
if (!isset($_SESSION['role']) || ($_SESSION['role'] !== 'admin' && $_SESSION['role'] !== 'manager')) {
    // إعادة توجيه المستخدم إلى الصفحة الرئيسية
    header('Location: ../index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>نظام طلبات الشحن | إعدادات النظام</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap');

    body {
      font-family: 'Tajawal', sans-serif;
      background-color: #f1f5f9;
      color: #1e293b;
    }

    /* تصميم المحتوى الرئيسي */
    .main-content {
      transition: margin-right 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    /* كروت الإحصائيات */
    .stat-card {
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .stat-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }

    /* أزرار */
    .btn-primary {
      background: linear-gradient(135deg, #4f46e5 0%, #818cf8 100%);
      transition: all 0.3s ease;
      box-shadow: 0 4px 6px -1px rgba(79, 70, 229, 0.3);
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 15px -3px rgba(79, 70, 229, 0.4);
    }

    /* حقول الإدخال */
    .form-input {
      transition: all 0.3s ease;
      border: 1px solid #e2e8f0;
      background-color: #f8fafc;
    }

    .form-input:focus {
      border-color: #818cf8;
      box-shadow: 0 0 0 3px rgba(129, 140, 248, 0.3);
      background-color: white;
    }

    /* تأثيرات الحركة */
    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(10px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .animate-fadeIn {
      animation: fadeIn 0.5s ease-out forwards;
    }
  </style>
</head>

<body class="bg-gray-50">

  <!-- تضمين القائمة الجانبية المشتركة -->
  <?php include_once '../includes/sidebar.php'; ?>

  <!-- المحتوى الرئيسي -->
  <main class="main-content min-h-screen">
    <!-- شريط التنقل العلوي -->
    <header class="bg-white shadow-sm sticky top-0 z-20">
      <div class="flex items-center justify-between p-4">
        <!-- زر القائمة للجوال -->
        <button id="mobileMenuButton" class="md:hidden text-gray-600 hover:text-indigo-600">
          <i class="fas fa-bars text-xl"></i>
        </button>

        <!-- شريط البحث -->
        <div class="relative flex-1 max-w-md mx-4">
          <input type="text" placeholder="ابحث في الإعدادات..." class="form-input w-full pl-10 pr-4 py-2 rounded-full">
          <i class="fas fa-search absolute right-3 top-3 text-gray-400"></i>
        </div>

        <!-- إشعارات وملف المستخدم -->
        <div class="flex items-center space-x-4 space-x-reverse">
          <button class="relative text-gray-600 hover:text-indigo-600">
            <i class="fas fa-bell text-xl"></i>
            <span
              class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center">3</span>
          </button>

          <div class="flex items-center space-x-2 space-x-reverse">
            <div class="text-right">
              <p class="font-medium text-sm"><?php echo htmlspecialchars($currentUser['full_name']); ?></p>
              <p class="text-xs text-gray-500"><?php echo htmlspecialchars($currentUser['role']); ?></p>
            </div>
            <div
              class="h-10 w-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 font-bold">
              <?php echo mb_substr($currentUser['full_name'], 0, 1, 'UTF-8'); ?>
            </div>
          </div>
        </div>
      </div>
    </header>

    <!-- محتوى الصفحة -->
    <div class="p-6">
      <!-- رأس الصفحة -->
      <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <div>
          <h1 class="text-2xl font-bold text-gray-800 flex items-center">
            <i class="fas fa-cog text-indigo-600 ml-3"></i>
            إعدادات النظام
          </h1>
          <p class="text-gray-600 mt-1">إدارة إعدادات النظام والفروع والخيارات العامة</p>
        </div>

        <div class="mt-4 md:mt-0">
          <button id="saveSettingsBtn" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg font-medium flex items-center transition-colors duration-300">
            <i class="fas fa-save ml-2"></i>
            <span>حفظ الإعدادات</span>
          </button>
        </div>
      </div>

      <!-- تبويبات الإعدادات -->
      <div class="bg-white rounded-xl shadow-sm overflow-hidden animate-fadeIn">
        <div class="border-b border-gray-200">
          <nav class="flex -mb-px">
            <a href="#" class="tab-link active py-4 px-6 border-b-2 border-indigo-500 font-medium text-indigo-600" data-tab="general">
              <i class="fas fa-sliders-h ml-2"></i>
              الإعدادات العامة
            </a>
            <a href="#" class="tab-link py-4 px-6 border-b-2 border-transparent font-medium text-gray-500 hover:text-gray-700 hover:border-gray-300" data-tab="branches">
              <i class="fas fa-building ml-2"></i>
              إدارة الفروع
            </a>
            <a href="#" class="tab-link py-4 px-6 border-b-2 border-transparent font-medium text-gray-500 hover:text-gray-700 hover:border-gray-300" data-tab="notifications">
              <i class="fas fa-bell ml-2"></i>
              إعدادات الإشعارات
            </a>
            <a href="#" class="tab-link py-4 px-6 border-b-2 border-transparent font-medium text-gray-500 hover:text-gray-700 hover:border-gray-300" data-tab="backup">
              <i class="fas fa-database ml-2"></i>
              النسخ الاحتياطي
            </a>
          </nav>
        </div>

        <!-- محتوى التبويبات -->
        <div class="p-6">
          <!-- الإعدادات العامة -->
          <div id="general-tab" class="tab-content active">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div>
                <h3 class="text-lg font-medium text-gray-800 mb-4">إعدادات النظام الأساسية</h3>
                <div class="space-y-4">
                  <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">اسم النظام</label>
                    <input type="text" id="systemName" name="systemName" class="form-input w-full" value="نظام طلبات الشحن">
                  </div>
                  <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">شعار النظام</label>
                    <div class="flex items-center">
                      <div class="w-16 h-16 bg-indigo-100 rounded-lg flex items-center justify-center text-indigo-600 ml-4">
                        <i class="fas fa-truck text-3xl"></i>
                      </div>
                      <button class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg font-medium flex items-center transition-colors duration-300">
                        <i class="fas fa-upload ml-2"></i>
                        <span>تغيير الشعار</span>
                      </button>
                    </div>
                  </div>
                  <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">العملة الافتراضية</label>
                    <select id="defaultCurrency" name="defaultCurrency" class="form-input w-full">
                      <option value="دولار">دولار</option>
                      <option value="سعودي">سعودي</option>
                      <option value="يمني">يمني</option>
                    </select>
                  </div>
                </div>
              </div>
              
              <div>
                <h3 class="text-lg font-medium text-gray-800 mb-4">إعدادات متقدمة</h3>
                <div class="space-y-4">
                  <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">مدة أرشفة الطلبات (بالأيام)</label>
                    <input type="number" id="archiveDays" name="archiveDays" class="form-input w-full" value="30">
                  </div>
                  <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">عدد العناصر في الصفحة</label>
                    <input type="number" id="itemsPerPage" name="itemsPerPage" class="form-input w-full" value="10">
                  </div>
                  <div class="flex items-center">
                    <input type="checkbox" id="enableDebugMode" name="enableDebugMode" class="h-4 w-4 text-indigo-600 focus:ring-indigo-500 border-gray-300 rounded ml-2">
                    <label for="enableDebugMode" class="text-sm font-medium text-gray-700">تفعيل وضع التصحيح</label>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- إدارة الفروع -->
          <div id="branches-tab" class="tab-content hidden">
            <div class="flex justify-between items-center mb-4">
              <h3 class="text-lg font-medium text-gray-800">إدارة الفروع</h3>
              <button class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg font-medium flex items-center transition-colors duration-300">
                <i class="fas fa-plus ml-2"></i>
                <span>إضافة فرع جديد</span>
              </button>
            </div>
            
            <div class="overflow-x-auto">
              <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                  <tr>
                    <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                      اسم الفرع
                    </th>
                    <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                      الرمز
                    </th>
                    <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                      العنوان
                    </th>
                    <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                      رقم الهاتف
                    </th>
                    <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                      البريد الإلكتروني
                    </th>
                    <th scope="col" class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">
                      إجراء
                    </th>
                  </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                  <tr>
                    <td class="px-3 py-4 whitespace-nowrap">
                      <div class="text-sm font-medium text-gray-900">عدن</div>
                    </td>
                    <td class="px-3 py-4 whitespace-nowrap">
                      <div class="text-sm text-gray-900">ADN</div>
                    </td>
                    <td class="px-3 py-4 whitespace-nowrap">
                      <div class="text-sm text-gray-900">عدن، اليمن</div>
                    </td>
                    <td class="px-3 py-4 whitespace-nowrap">
                      <div class="text-sm text-gray-900">+967 2 123456</div>
                    </td>
                    <td class="px-3 py-4 whitespace-nowrap">
                      <div class="text-sm text-gray-900">aden@shipping.com</div>
                    </td>
                    <td class="px-3 py-4 whitespace-nowrap text-center">
                      <button class="text-indigo-600 hover:text-indigo-900 ml-2">
                        <i class="fas fa-edit"></i>
                      </button>
                      <button class="text-red-600 hover:text-red-900">
                        <i class="fas fa-trash-alt"></i>
                      </button>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>

          <!-- إعدادات الإشعارات -->
          <div id="notifications-tab" class="tab-content hidden">
            <h3 class="text-lg font-medium text-gray-800 mb-4">إعدادات الإشعارات</h3>
            <div class="space-y-4">
              <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                  <h4 class="font-medium">إشعارات الطلبات الجديدة</h4>
                  <p class="text-sm text-gray-600">إرسال إشعار عند إنشاء طلب جديد</p>
                </div>
                <div class="relative inline-block w-12 h-6 ml-2">
                  <input type="checkbox" id="newOrderNotification" class="opacity-0 w-0 h-0" checked>
                  <span class="slider absolute cursor-pointer top-0 right-0 left-0 bottom-0 bg-indigo-600 rounded-full transition-all duration-300"></span>
                </div>
              </div>
              
              <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                  <h4 class="font-medium">إشعارات تحديث الطلبات</h4>
                  <p class="text-sm text-gray-600">إرسال إشعار عند تحديث حالة الطلب</p>
                </div>
                <div class="relative inline-block w-12 h-6 ml-2">
                  <input type="checkbox" id="updateOrderNotification" class="opacity-0 w-0 h-0" checked>
                  <span class="slider absolute cursor-pointer top-0 right-0 left-0 bottom-0 bg-indigo-600 rounded-full transition-all duration-300"></span>
                </div>
              </div>
              
              <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                  <h4 class="font-medium">إشعارات البريد الإلكتروني</h4>
                  <p class="text-sm text-gray-600">إرسال إشعارات عبر البريد الإلكتروني</p>
                </div>
                <div class="relative inline-block w-12 h-6 ml-2">
                  <input type="checkbox" id="emailNotification" class="opacity-0 w-0 h-0">
                  <span class="slider absolute cursor-pointer top-0 right-0 left-0 bottom-0 bg-gray-300 rounded-full transition-all duration-300"></span>
                </div>
              </div>
            </div>
          </div>

          <!-- النسخ الاحتياطي -->
          <div id="backup-tab" class="tab-content hidden">
            <h3 class="text-lg font-medium text-gray-800 mb-4">النسخ الاحتياطي واستعادة البيانات</h3>
            <div class="space-y-6">
              <div class="bg-gray-50 p-4 rounded-lg">
                <h4 class="font-medium mb-2">إنشاء نسخة احتياطية</h4>
                <p class="text-sm text-gray-600 mb-4">قم بإنشاء نسخة احتياطية كاملة من قاعدة البيانات</p>
                <button class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg font-medium flex items-center transition-colors duration-300">
                  <i class="fas fa-download ml-2"></i>
                  <span>إنشاء نسخة احتياطية</span>
                </button>
              </div>
              
              <div class="bg-gray-50 p-4 rounded-lg">
                <h4 class="font-medium mb-2">استعادة من نسخة احتياطية</h4>
                <p class="text-sm text-gray-600 mb-4">قم باستعادة البيانات من نسخة احتياطية سابقة</p>
                <div class="flex items-center">
                  <input type="file" id="backupFile" class="hidden">
                  <label for="backupFile" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium flex items-center transition-colors duration-300 cursor-pointer">
                    <i class="fas fa-upload ml-2"></i>
                    <span>اختيار ملف</span>
                  </label>
                  <button class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg font-medium flex items-center transition-colors duration-300 mr-2" disabled>
                    <i class="fas fa-undo ml-2"></i>
                    <span>استعادة</span>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- تضمين مكتبة SweetAlert2 للتنبيهات الجميلة -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // تبديل التبويبات
      const tabLinks = document.querySelectorAll('.tab-link');
      const tabContents = document.querySelectorAll('.tab-content');
      
      tabLinks.forEach(link => {
        link.addEventListener('click', function(e) {
          e.preventDefault();
          
          // إزالة الحالة النشطة من جميع الروابط
          tabLinks.forEach(l => l.classList.remove('active', 'border-indigo-500', 'text-indigo-600'));
          tabLinks.forEach(l => l.classList.add('border-transparent', 'text-gray-500'));
          
          // إضافة الحالة النشطة للرابط الحالي
          this.classList.add('active', 'border-indigo-500', 'text-indigo-600');
          this.classList.remove('border-transparent', 'text-gray-500');
          
          // إخفاء جميع المحتويات
          tabContents.forEach(content => content.classList.add('hidden'));
          tabContents.forEach(content => content.classList.remove('active'));
          
          // إظهار المحتوى المطلوب
          const tabId = this.getAttribute('data-tab');
          document.getElementById(tabId + '-tab').classList.remove('hidden');
          document.getElementById(tabId + '-tab').classList.add('active');
        });
      });
      
      // حفظ الإعدادات
      const saveSettingsBtn = document.getElementById('saveSettingsBtn');
      if (saveSettingsBtn) {
        saveSettingsBtn.addEventListener('click', function() {
          Swal.fire({
            icon: 'success',
            title: 'تم حفظ الإعدادات بنجاح',
            showConfirmButton: false,
            timer: 1500
          });
        });
      }
    });
  </script>
</body>

</html>
