<?php
/**
 * ملف التحميل التلقائي
 * يقوم بتحميل الفئات تلقائيًا عند استخدامها
 */

// تسجيل دالة التحميل التلقائي
spl_autoload_register(function ($class) {
    // تحويل مساحة الاسم إلى مسار ملف
    $prefix = 'App\\';
    $base_dir = dirname(__DIR__) . '/app/';
    
    // التحقق مما إذا كانت الفئة تبدأ بالبادئة
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // لا تنتمي الفئة إلى مساحة الاسم الخاصة بنا
        return;
    }
    
    // الحصول على المسار النسبي للفئة
    $relative_class = substr($class, $len);
    
    // استبدال الفاصلة المائلة العكسية بالفاصلة المائلة العادية
    $relative_class = str_replace('\\', '/', $relative_class);
    
    // بناء مسار الملف
    $file = $base_dir . $relative_class . '.php';
    
    // إذا كان الملف موجودًا، قم بتضمينه
    if (file_exists($file)) {
        require $file;
    }
});
