/**
 * ملف JavaScript لتأثيرات صفحة تسجيل الدخول المميزة
 */

document.addEventListener('DOMContentLoaded', function() {
  // إنشاء الجسيمات المتحركة
  createParticles();
  
  // تأثير التموج عند النقر على الزر
  const loginButton = document.querySelector('.login-button');
  
  if (loginButton) {
    loginButton.addEventListener('click', function(e) {
      const x = e.clientX - this.getBoundingClientRect().left;
      const y = e.clientY - this.getBoundingClientRect().top;
      
      const ripple = document.createElement('span');
      ripple.className = 'ripple';
      ripple.style.left = x + 'px';
      ripple.style.top = y + 'px';
      
      this.appendChild(ripple);
      
      setTimeout(function() {
        ripple.remove();
      }, 800);
    });
  }
  
  // تحريك الخلفية عند تحريك الماوس
  const background = document.querySelector('.premium-background');
  const container = document.querySelector('.login-container');
  
  if (background && container) {
    document.addEventListener('mousemove', function(e) {
      const x = e.clientX / window.innerWidth;
      const y = e.clientY / window.innerHeight;
      
      background.style.transform = `translate(${x * -20}px, ${y * -20}px)`;
      container.style.transform = `translate(${x * 10}px, ${y * 10}px)`;
    });
  }
  
  // تأثير الكتابة في حقول الإدخال
  const inputs = document.querySelectorAll('.login-input');
  
  inputs.forEach(function(input) {
    input.addEventListener('focus', function() {
      this.parentElement.classList.add('focused');
    });
    
    input.addEventListener('blur', function() {
      this.parentElement.classList.remove('focused');
    });
  });
  
  // التحقق من صحة النموذج
  const loginForm = document.getElementById('loginForm');
  
  if (loginForm) {
    loginForm.addEventListener('submit', function(e) {
      const emailInput = document.querySelector('input[name="email"]');
      const passwordInput = document.querySelector('input[name="password"]');
      const branchSelect = document.querySelector('select[name="branch_id"]');
      
      let isValid = true;
      
      // التحقق من البريد الإلكتروني
      if (!emailInput.value.trim()) {
        showError(emailInput, 'يرجى إدخال البريد الإلكتروني');
        isValid = false;
      } else {
        clearError(emailInput);
      }
      
      // التحقق من كلمة المرور
      if (!passwordInput.value.trim()) {
        showError(passwordInput, 'يرجى إدخال كلمة المرور');
        isValid = false;
      } else {
        clearError(passwordInput);
      }
      
      // التحقق من الفرع (إذا كان مطلوبًا)
      if (branchSelect && branchSelect.required && !branchSelect.value) {
        showError(branchSelect, 'يرجى اختيار الفرع');
        isValid = false;
      } else if (branchSelect) {
        clearError(branchSelect);
      }
      
      if (!isValid) {
        e.preventDefault();
      }
    });
  }
});

/**
 * إنشاء الجسيمات المتحركة
 */
function createParticles() {
  const particles = document.querySelector('.particles');
  
  if (!particles) {
    return;
  }
  
  // إزالة الجسيمات الموجودة
  while (particles.firstChild) {
    particles.removeChild(particles.firstChild);
  }
  
  // إنشاء جسيمات جديدة
  for (let i = 0; i < 50; i++) {
    const particle = document.createElement('div');
    particle.className = 'particle';
    
    // تعيين خصائص الجسيم
    const size = Math.random() * 5 + 1;
    const posX = Math.random() * 100;
    const posY = Math.random() * 100;
    const opacity = Math.random() * 0.5 + 0.1;
    const duration = Math.random() * 20 + 10;
    const delay = Math.random() * 5;
    
    // تطبيق الأنماط
    particle.style.cssText = `
      position: absolute;
      top: ${posY}%;
      left: ${posX}%;
      width: ${size}px;
      height: ${size}px;
      background-color: rgba(255, 255, 255, ${opacity});
      border-radius: 50%;
      animation: float ${duration}s ease-in-out ${delay}s infinite;
      z-index: -1;
    `;
    
    particles.appendChild(particle);
  }
  
  // إضافة أنماط الرسوم المتحركة
  if (!document.getElementById('particle-animation')) {
    const style = document.createElement('style');
    style.id = 'particle-animation';
    style.textContent = `
      @keyframes float {
        0%, 100% {
          transform: translateY(0) translateX(0);
        }
        25% {
          transform: translateY(-20px) translateX(10px);
        }
        50% {
          transform: translateY(0) translateX(20px);
        }
        75% {
          transform: translateY(20px) translateX(10px);
        }
      }
    `;
    
    document.head.appendChild(style);
  }
}

/**
 * عرض رسالة خطأ لحقل الإدخال
 */
function showError(input, message) {
  const inputGroup = input.parentElement;
  
  // إزالة رسالة الخطأ السابقة إن وجدت
  const existingError = inputGroup.querySelector('.error-text');
  if (existingError) {
    existingError.remove();
  }
  
  // إضافة فئة الخطأ
  inputGroup.classList.add('error');
  
  // إنشاء رسالة الخطأ
  const errorText = document.createElement('div');
  errorText.className = 'error-text';
  errorText.textContent = message;
  errorText.style.cssText = `
    color: #ffcdd2;
    font-size: 12px;
    margin-top: 5px;
    animation: fadeIn 0.3s ease-out;
  `;
  
  // إضافة رسالة الخطأ
  inputGroup.appendChild(errorText);
}

/**
 * إزالة رسالة الخطأ من حقل الإدخال
 */
function clearError(input) {
  const inputGroup = input.parentElement;
  
  // إزالة فئة الخطأ
  inputGroup.classList.remove('error');
  
  // إزالة رسالة الخطأ
  const errorText = inputGroup.querySelector('.error-text');
  if (errorText) {
    errorText.remove();
  }
}
