-- إنشاء جدول المستخدمين
CREATE TABLE IF NOT EXISTS users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    username TEXT NOT NULL UNIQUE,
    full_name TEXT NOT NULL,
    email TEXT NOT NULL UNIQUE,
    password TEXT NOT NULL,
    role TEXT NOT NULL DEFAULT 'user',
    branch_id INTEGER,
    is_active INTEGER NOT NULL DEFAULT 1,
    created_at DATETIME,
    updated_at DATETIME
);

-- إنشاء جدول الفروع
CREATE TABLE IF NOT EXISTS branches (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    code TEXT NOT NULL UNIQUE,
    address TEXT,
    phone TEXT,
    email TEXT,
    is_active INTEGER NOT NULL DEFAULT 1,
    created_at DATETIME,
    updated_at DATETIME
);

-- إنشاء جدول تسلسل الطلبات
CREATE TABLE IF NOT EXISTS order_sequences (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    branch_code TEXT NOT NULL UNIQUE,
    last_sequence_number INTEGER NOT NULL DEFAULT 0,
    created_at DATETIME,
    updated_at DATETIME
);

-- إنشاء جدول الطلبات
CREATE TABLE IF NOT EXISTS orders (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    order_number TEXT NOT NULL UNIQUE,
    branch_id INTEGER NOT NULL,
    customer_name TEXT NOT NULL,
    customer_phone TEXT,
    customer_address TEXT,
    order_date DATE NOT NULL,
    delivery_date DATE,
    status TEXT NOT NULL DEFAULT 'قيد المعالجة',
    amount_paid REAL NOT NULL DEFAULT 0,
    amount_due REAL NOT NULL DEFAULT 0,
    total_amount REAL NOT NULL DEFAULT 0,
    notes TEXT,
    created_by INTEGER,
    employee_name TEXT,
    created_at DATETIME,
    updated_at DATETIME,
    FOREIGN KEY (branch_id) REFERENCES branches(id),
    FOREIGN KEY (created_by) REFERENCES users(id)
);

-- إنشاء جدول سجل النشاط
CREATE TABLE IF NOT EXISTS activity_log (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    user_id INTEGER,
    action TEXT NOT NULL,
    details TEXT,
    ip_address TEXT,
    user_agent TEXT,
    created_at DATETIME,
    FOREIGN KEY (user_id) REFERENCES users(id)
);

-- إنشاء جدول الإعدادات
CREATE TABLE IF NOT EXISTS settings (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    setting_key TEXT NOT NULL UNIQUE,
    setting_value TEXT,
    setting_group TEXT,
    is_system INTEGER NOT NULL DEFAULT 0,
    created_at DATETIME,
    updated_at DATETIME
);

-- إدراج مستخدم مدير النظام الافتراضي
INSERT OR IGNORE INTO users (username, full_name, email, password, role, created_at)
VALUES ('admin', 'مدير النظام', 'admin@al-ahmadigroup.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', datetime('now'));

-- إدراج الفروع الافتراضية
INSERT OR IGNORE INTO branches (name, code, is_active, created_at)
VALUES 
('المركز الرئيسي', 'HQ', 1, datetime('now')),
('المكلا', 'MKL', 1, datetime('now')),
('صنعاء', 'SNA', 1, datetime('now')),
('فرع عدن', 'ADN', 1, datetime('now')),
('شحن', 'SH', 1, datetime('now')),
('الصين', 'CN', 1, datetime('now'));

-- إدراج تسلسل الطلبات للفروع
INSERT OR IGNORE INTO order_sequences (branch_code, last_sequence_number, created_at)
VALUES 
('HQ', 0, datetime('now')),
('MKL', 0, datetime('now')),
('SNA', 0, datetime('now')),
('ADN', 0, datetime('now')),
('SH', 0, datetime('now')),
('CN', 0, datetime('now'));

-- إدراج الإعدادات الافتراضية
INSERT OR IGNORE INTO settings (setting_key, setting_value, setting_group, is_system, created_at)
VALUES 
('company_name', 'مجموعة ابراهيم الاحمدي اليمنية', 'general', 1, datetime('now')),
('company_address', 'اليمن، حضرموت، المكلا', 'general', 1, datetime('now')),
('company_phone', '05318281', 'general', 1, datetime('now')),
('company_email', 'ibrahim@al-ahmadigroup.com', 'general', 1, datetime('now')),
('order_prefix', '25', 'orders', 1, datetime('now')),
('currency_symbol', 'ر.ي', 'general', 1, datetime('now'));
