<?php
/**
 * إنشاء قاعدة بيانات SQLite وتنفيذ ملف SQL
 */

// تحديد مسار ملف قاعدة البيانات
$db_file = __DIR__ . '/shipping.sqlite';

// تحديد مسار ملف SQL
$sql_file = __DIR__ . '/schema.sql';

// التحقق من وجود ملف SQL
if (!file_exists($sql_file)) {
    die("ملف SQL غير موجود: {$sql_file}");
}

try {
    // إنشاء اتصال PDO مع SQLite
    $pdo = new PDO("sqlite:{$db_file}");
    
    // ضبط خيارات PDO
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // قراءة محتوى ملف SQL
    $sql = file_get_contents($sql_file);
    
    // تنفيذ استعلامات SQL
    $pdo->exec($sql);
    
    echo "تم إنشاء قاعدة البيانات وتنفيذ ملف SQL بنجاح.\n";
} catch (PDOException $e) {
    die("خطأ في إنشاء قاعدة البيانات: " . $e->getMessage());
}
