<?php
/**
 * ملف التكوين المركزي للنظام
 * يحتوي على جميع إعدادات النظام
 */

// تحديد وضع التطوير (تفعيل لعرض الأخطاء)
define('DEVELOPMENT_MODE', true);

// تفعيل عرض الأخطاء للتصحيح
if (DEVELOPMENT_MODE) {
    // وضع التطوير: عرض جميع الأخطاء
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    // وضع الإنتاج: إخفاء الأخطاء
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT);

    // تسجيل الأخطاء في ملف
    ini_set('log_errors', 1);
    ini_set('error_log', dirname(__DIR__) . '/storage/logs/error.log');
}

// تعيين منطقة زمنية افتراضية
date_default_timezone_set('Asia/Riyadh');

// تعيين ترميز افتراضي
ini_set('default_charset', 'UTF-8');

// تعيين حد الذاكرة
ini_set('memory_limit', '256M');

// تعيين وقت التنفيذ الأقصى
set_time_limit(300);

// معلومات النظام
return [
    // معلومات النظام
    'system_name' => 'نظام طلبات الشحن',
    'company_name' => 'مجموعة ابراهيم الاحمدي اليمنية',
    'company_logo' => 'assets/images/logo.png',
    'company_address' => 'اليمن، حضرموت، المكلا',
    'company_phone' => '05318281',
    'company_email' => 'ibrahim@al-ahmadigroup.com',
    
    // إعدادات URL
    'base_url' => 'http://localhost',
    'use_https' => false,
    
    // إعدادات المسار
    'base_path' => dirname(__DIR__),
    
    // إعدادات الجلسة
    'session_name' => 'shipping_system',
    'session_lifetime' => 7200, // ساعتان
    
    // إعدادات التخزين المؤقت
    'cache_enabled' => true,
    'cache_lifetime' => 300, // 5 دقائق
    
    // إعدادات التحميل
    'upload_max_size' => 10 * 1024 * 1024, // 10 ميجابايت
    'allowed_extensions' => ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx', 'xls', 'xlsx'],
    
    // إعدادات الأمان
    'csrf_protection' => true,
    'password_min_length' => 8,
    
    // إعدادات البريد الإلكتروني
    'mail_from' => 'noreply@al-ahmadigroup.com',
    'mail_from_name' => 'نظام طلبات الشحن',
    
    // إعدادات التقارير
    'reports_per_page' => 20,
    
    // إعدادات الفروع
    'branches' => [
        ['name' => 'المركز الرئيسي', 'code' => 'HQ'],
        ['name' => 'المكلا', 'code' => 'MKL'],
        ['name' => 'صنعاء', 'code' => 'SNA'],
        ['name' => 'فرع عدن', 'code' => 'ADN'],
        ['name' => 'شحن', 'code' => 'SH'],
        ['name' => 'الصين', 'code' => 'CN']
    ],
    
    // إعدادات حالات الطلب
    'order_statuses' => [
        'قيد المعالجة',
        'قيد التوصيل',
        'تم التسليم',
        'ملغى'
    ]
];
