<?php
// بدء مخزن مؤقت للمحتوى
ob_start();
?>

<div class="page-header">
  <h2 class="page-title">
    <i class="fas fa-cog"></i>
    إعدادات النظام
  </h2>
</div>

<div class="settings-container">
  <form action="/settings/update" method="post" class="settings-form">
    <!-- رمز CSRF للحماية من هجمات CSRF -->
    <input type="hidden" name="csrf_token" value="<?php echo $auth->generateCSRFToken(); ?>">

    <div class="settings-section">
      <h3 class="section-title">
        <i class="fas fa-info-circle"></i>
        معلومات النظام
      </h3>

      <div class="form-row">
        <div class="form-group">
          <label for="system_name">اسم النظام</label>
          <input type="text" id="system_name" name="system_name" class="form-control" value="<?php echo htmlspecialchars($config['system_name']); ?>" required>
        </div>

        <div class="form-group">
          <label for="company_name">اسم الشركة</label>
          <input type="text" id="company_name" name="company_name" class="form-control" value="<?php echo htmlspecialchars($config['company_name']); ?>" required>
        </div>
      </div>

      <div class="form-row">
        <div class="form-group">
          <label for="company_address">عنوان الشركة</label>
          <input type="text" id="company_address" name="company_address" class="form-control" value="<?php echo htmlspecialchars($config['company_address']); ?>">
        </div>

        <div class="form-group">
          <label for="company_phone">رقم الهاتف</label>
          <input type="text" id="company_phone" name="company_phone" class="form-control" value="<?php echo htmlspecialchars($config['company_phone']); ?>">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group">
          <label for="company_email">البريد الإلكتروني</label>
          <input type="email" id="company_email" name="company_email" class="form-control" value="<?php echo htmlspecialchars($config['company_email']); ?>">
        </div>
      </div>
    </div>

    <div class="settings-section">
      <h3 class="section-title">
        <i class="fas fa-globe"></i>
        إعدادات الموقع
      </h3>

      <div class="form-row">
        <div class="form-group">
          <label for="base_url">عنوان الموقع</label>
          <input type="text" id="base_url" name="base_url" class="form-control" value="<?php echo htmlspecialchars($config['base_url']); ?>" required>
        </div>

        <div class="form-group checkbox-group">
          <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" id="use_https" name="use_https" <?php echo $config['use_https'] ? 'checked' : ''; ?>>
            <label class="custom-control-label" for="use_https">استخدام HTTPS</label>
          </div>
        </div>
      </div>
    </div>

    <div class="settings-section">
      <h3 class="section-title">
        <i class="fas fa-database"></i>
        إعدادات التخزين المؤقت
      </h3>

      <div class="form-row">
        <div class="form-group checkbox-group">
          <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" id="cache_enabled" name="cache_enabled" <?php echo $config['cache_enabled'] ? 'checked' : ''; ?>>
            <label class="custom-control-label" for="cache_enabled">تفعيل التخزين المؤقت</label>
          </div>
        </div>

        <div class="form-group">
          <label for="cache_lifetime">مدة التخزين المؤقت (بالثواني)</label>
          <input type="number" id="cache_lifetime" name="cache_lifetime" class="form-control" value="<?php echo (int)$config['cache_lifetime']; ?>" min="60" required>
        </div>
      </div>

      <div class="form-row">
        <div class="form-group">
          <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#clearCacheModal">
            <i class="fas fa-trash-alt"></i>
            تنظيف ملفات التخزين المؤقت
          </button>
        </div>
      </div>
    </div>

    <div class="settings-section">
      <h3 class="section-title">
        <i class="fas fa-upload"></i>
        إعدادات التحميل
      </h3>

      <div class="form-row">
        <div class="form-group">
          <label for="upload_max_size">الحد الأقصى لحجم الملف (بالبايت)</label>
          <input type="number" id="upload_max_size" name="upload_max_size" class="form-control" value="<?php echo (int)$config['upload_max_size']; ?>" min="1048576" required>
          <small class="form-text">1048576 بايت = 1 ميجابايت</small>
        </div>
      </div>
    </div>

    <div class="settings-section">
      <h3 class="section-title">
        <i class="fas fa-shield-alt"></i>
        إعدادات الأمان
      </h3>

      <div class="form-row">
        <div class="form-group checkbox-group">
          <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" id="csrf_protection" name="csrf_protection" <?php echo $config['csrf_protection'] ? 'checked' : ''; ?>>
            <label class="custom-control-label" for="csrf_protection">تفعيل حماية CSRF</label>
          </div>
        </div>

        <div class="form-group">
          <label for="password_min_length">الحد الأدنى لطول كلمة المرور</label>
          <input type="number" id="password_min_length" name="password_min_length" class="form-control" value="<?php echo (int)$config['password_min_length']; ?>" min="6" required>
        </div>
      </div>
    </div>

    <div class="settings-section">
      <h3 class="section-title">
        <i class="fas fa-envelope"></i>
        إعدادات البريد الإلكتروني
      </h3>

      <div class="form-row">
        <div class="form-group">
          <label for="mail_from">عنوان المرسل</label>
          <input type="email" id="mail_from" name="mail_from" class="form-control" value="<?php echo htmlspecialchars($config['mail_from']); ?>" required>
        </div>

        <div class="form-group">
          <label for="mail_from_name">اسم المرسل</label>
          <input type="text" id="mail_from_name" name="mail_from_name" class="form-control" value="<?php echo htmlspecialchars($config['mail_from_name']); ?>" required>
        </div>
      </div>
    </div>

    <div class="settings-section">
      <h3 class="section-title">
        <i class="fas fa-file-alt"></i>
        إعدادات التقارير
      </h3>

      <div class="form-row">
        <div class="form-group">
          <label for="reports_per_page">عدد العناصر في الصفحة</label>
          <input type="number" id="reports_per_page" name="reports_per_page" class="form-control" value="<?php echo (int)$config['reports_per_page']; ?>" min="10" required>
        </div>
      </div>
    </div>

    <div class="form-actions">
      <button type="submit" class="btn btn-primary">
        <i class="fas fa-save"></i>
        حفظ الإعدادات
      </button>
      <a href="/dashboard" class="btn btn-secondary">
        <i class="fas fa-times"></i>
        إلغاء
      </a>
    </div>
  </form>
</div>

<!-- نافذة تأكيد تنظيف ملفات التخزين المؤقت -->
<div class="modal fade" id="clearCacheModal" tabindex="-1" role="dialog" aria-labelledby="clearCacheModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="clearCacheModalLabel">تأكيد تنظيف ملفات التخزين المؤقت</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>هل أنت متأكد من تنظيف جميع ملفات التخزين المؤقت؟</p>
        <div class="alert alert-info">
          <i class="fas fa-info-circle"></i>
          سيؤدي هذا إلى إعادة إنشاء جميع ملفات التخزين المؤقت، مما قد يؤثر مؤقتًا على أداء النظام.
        </div>
      </div>
      <div class="modal-footer">
        <form action="/settings/clear-cache" method="post">
          <!-- رمز CSRF للحماية من هجمات CSRF -->
          <input type="hidden" name="csrf_token" value="<?php echo $auth->generateCSRFToken(); ?>">

          <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
          <button type="submit" class="btn btn-warning">تنظيف</button>
        </form>
      </div>
    </div>
  </div>
</div>

<?php
// الحصول على محتوى المخزن المؤقت
$content = ob_get_clean();

// تضمين القالب الرئيسي
include dirname(__DIR__) . '/layouts/main.php';
?>
