<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo $pageTitle ?? 'نظام طلبات الشحن'; ?> - مجموعة ابراهيم الاحمدي اليمنية</title>
  <!-- Font Awesome للأيقونات -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <!-- خط Tajawal -->
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <!-- تم إزالة Tailwind CSS لتجنب التعارض مع ملف CSS الموحد -->
  <!-- ملف CSS الرئيسي -->
  <link rel="stylesheet" href="/assets/css/unified-design.css">
  <?php if (isset($extraStyles)): ?>
    <?php echo $extraStyles; ?>
  <?php endif; ?>
</head>

<body class="bg-gray-100">
  <!-- الشريط الجانبي -->
  <div class="sidebar">
    <!-- شعار الشركة -->
    <div class="sidebar-logo">
      <img src="/assets/images/logo.png" alt="مجموعة ابراهيم الاحمدي اليمنية" class="logo-image">
      <h2 class="company-name">مجموعة ابراهيم الاحمدي اليمنية</h2>
    </div>

    <!-- قائمة الشريط الجانبي -->
    <ul class="sidebar-menu">
      <li class="sidebar-item <?php echo $activePage === 'dashboard' ? 'active' : ''; ?>">
        <a href="/dashboard">
          <i class="fas fa-tachometer-alt"></i>
          <span>لوحة التحكم</span>
        </a>
      </li>
      <li class="sidebar-item <?php echo $activePage === 'orders' ? 'active' : ''; ?>">
        <a href="/orders">
          <i class="fas fa-shipping-fast"></i>
          <span>الطلبات</span>
        </a>
      </li>
      <li class="sidebar-item <?php echo $activePage === 'create-order' ? 'active' : ''; ?>">
        <a href="/orders/create">
          <i class="fas fa-plus-circle"></i>
          <span>إنشاء طلب جديد</span>
        </a>
      </li>
      <li class="sidebar-item <?php echo $activePage === 'weekly-reports' ? 'active' : ''; ?>">
        <a href="/reports/weekly">
          <i class="fas fa-chart-bar"></i>
          <span>التقارير الأسبوعية</span>
        </a>
      </li>
      <li class="sidebar-item <?php echo $activePage === 'monthly-reports' ? 'active' : ''; ?>">
        <a href="/reports/monthly">
          <i class="fas fa-chart-line"></i>
          <span>التقارير الشهرية</span>
        </a>
      </li>
      <?php if ($user['role'] === 'admin'): ?>
      <li class="sidebar-item <?php echo $activePage === 'users' ? 'active' : ''; ?>">
        <a href="/users">
          <i class="fas fa-users"></i>
          <span>إدارة المستخدمين</span>
        </a>
      </li>
      <li class="sidebar-item <?php echo $activePage === 'branches' ? 'active' : ''; ?>">
        <a href="/branches">
          <i class="fas fa-building"></i>
          <span>إدارة الفروع</span>
        </a>
      </li>
      <li class="sidebar-item <?php echo $activePage === 'settings' ? 'active' : ''; ?>">
        <a href="/settings">
          <i class="fas fa-cog"></i>
          <span>إعدادات النظام</span>
        </a>
      </li>
      <?php endif; ?>
      <li class="sidebar-item">
        <a href="/logout">
          <i class="fas fa-sign-out-alt"></i>
          <span>تسجيل الخروج</span>
        </a>
      </li>
    </ul>

    <!-- معلومات المستخدم -->
    <div class="user-info">
      <div class="user-avatar">
        <i class="fas fa-user"></i>
      </div>
      <div class="user-details">
        <h3 class="user-name"><?php echo htmlspecialchars($user['full_name']); ?></h3>
        <p class="user-role"><?php echo $user['role'] === 'admin' ? 'مدير النظام' : 'مستخدم'; ?></p>
        <?php if ($user['role'] !== 'admin' && !empty($user['branch_name'])): ?>
        <p class="user-branch"><?php echo htmlspecialchars($user['branch_name']); ?></p>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- المحتوى الرئيسي -->
  <div class="main-content">
    <!-- الشريط العلوي -->
    <div class="top-bar">
      <div class="top-bar-left">
        <button class="sidebar-toggle">
          <i class="fas fa-bars"></i>
        </button>
        <h1 class="page-title"><?php echo $pageTitle ?? 'نظام طلبات الشحن'; ?></h1>
      </div>
      <div class="top-bar-right">
        <div class="user-dropdown">
          <button class="user-dropdown-toggle">
            <i class="fas fa-user"></i>
            <span><?php echo htmlspecialchars($user['full_name']); ?></span>
            <i class="fas fa-chevron-down"></i>
          </button>
          <div class="user-dropdown-menu">
            <a href="/profile">
              <i class="fas fa-user-circle"></i>
              <span>الملف الشخصي</span>
            </a>
            <a href="/logout">
              <i class="fas fa-sign-out-alt"></i>
              <span>تسجيل الخروج</span>
            </a>
          </div>
        </div>
      </div>
    </div>

    <!-- محتوى الصفحة -->
    <div class="page-content">
      <?php if (isset($_SESSION['flash_message'])): ?>
      <div class="alert alert-<?php echo $_SESSION['flash_type'] ?? 'success'; ?>">
        <?php echo $_SESSION['flash_message']; ?>
        <button class="alert-close">&times;</button>
      </div>
      <?php
        unset($_SESSION['flash_message']);
        unset($_SESSION['flash_type']);
      ?>
      <?php endif; ?>

      <?php echo $content ?? ''; ?>
    </div>

    <!-- تذييل الصفحة -->
    <div class="footer">
      <p>جميع الحقوق محفوظة &copy; <?php echo date('Y'); ?> مجموعة ابراهيم الاحمدي اليمنية</p>
    </div>
  </div>

  <!-- ملف JavaScript الرئيسي -->
  <script src="/assets/js/main.js"></script>
  <?php if (isset($extraScripts)): ?>
    <?php echo $extraScripts; ?>
  <?php endif; ?>
</body>

</html>
