<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>404 - الصفحة غير موجودة</title>
  <!-- Font Awesome للأيقونات -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <!-- خط Tajawal -->
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <!-- ملف CSS الرئيسي -->
  <link rel="stylesheet" href="/assets/css/unified-design.css">
  <style>
    .error-container {
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
      text-align: center;
      padding: 2rem;
      background-color: #f8f9fa;
    }

    .error-code {
      font-size: 8rem;
      font-weight: 700;
      color: #f8b500;
      margin: 0;
      line-height: 1;
      text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
    }

    .error-title {
      font-size: 2rem;
      font-weight: 600;
      color: #333;
      margin: 1rem 0;
    }

    .error-message {
      font-size: 1.2rem;
      color: #666;
      margin-bottom: 2rem;
      max-width: 600px;
    }

    .error-image {
      max-width: 300px;
      margin-bottom: 2rem;
    }

    .back-button {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 0.75rem 1.5rem;
      background-color: #f8b500;
      color: #fff;
      border-radius: 4px;
      font-weight: 500;
      text-decoration: none;
      transition: all 0.3s ease;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .back-button:hover {
      background-color: #e5a800;
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
    }

    .back-button i {
      margin-left: 0.5rem;
    }
  </style>
</head>

<body>
  <div class="error-container">
    <h1 class="error-code">404</h1>
    <h2 class="error-title">الصفحة غير موجودة</h2>
    <p class="error-message">عذراً، الصفحة التي تبحث عنها غير موجودة أو تم نقلها أو حذفها.</p>
    
    <a href="/" class="back-button">
      <i class="fas fa-home"></i>
      العودة للصفحة الرئيسية
    </a>
  </div>
</body>

</html>
