<?php
// بدء مخزن مؤقت للمحتوى
ob_start();
?>

<div class="page-header">
  <h2 class="page-title">
    <i class="fas fa-building"></i>
    إدارة الفروع
  </h2>

  <div class="page-actions">
    <a href="/branches/create" class="btn btn-primary">
      <i class="fas fa-plus-circle"></i>
      إضافة فرع جديد
    </a>
  </div>
</div>

<div class="table-responsive">
  <table class="data-table">
    <thead>
      <tr>
        <th>#</th>
        <th>اسم الفرع</th>
        <th>الرمز</th>
        <th>العنوان</th>
        <th>رقم الهاتف</th>
        <th>البريد الإلكتروني</th>
        <th>الحالة</th>
        <th>الإجراءات</th>
      </tr>
    </thead>
    <tbody>
      <?php if (empty($branches)): ?>
      <tr>
        <td colspan="8" class="text-center">لا يوجد فروع</td>
      </tr>
      <?php else: ?>
        <?php foreach ($branches as $index => $branch): ?>
        <tr>
          <td><?php echo $index + 1; ?></td>
          <td><?php echo htmlspecialchars($branch['name']); ?></td>
          <td><?php echo htmlspecialchars($branch['code']); ?></td>
          <td><?php echo htmlspecialchars($branch['address'] ?? 'غير محدد'); ?></td>
          <td><?php echo htmlspecialchars($branch['phone'] ?? 'غير محدد'); ?></td>
          <td><?php echo htmlspecialchars($branch['email'] ?? 'غير محدد'); ?></td>
          <td>
            <span class="status-badge status-<?php echo $branch['is_active'] ? 'active' : 'inactive'; ?>">
              <?php echo $branch['is_active'] ? 'نشط' : 'غير نشط'; ?>
            </span>
          </td>
          <td>
            <div class="actions">
              <a href="/branches/edit/<?php echo $branch['id']; ?>" class="action-btn edit-btn" title="تعديل">
                <i class="fas fa-edit"></i>
              </a>

              <button type="button" class="action-btn delete-btn" title="حذف" data-toggle="modal" data-target="#deleteModal" data-id="<?php echo $branch['id']; ?>" data-name="<?php echo htmlspecialchars($branch['name']); ?>">
                <i class="fas fa-trash-alt"></i>
              </button>
            </div>
          </td>
        </tr>
        <?php endforeach; ?>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<!-- نافذة تأكيد الحذف -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>هل أنت متأكد من حذف الفرع <span id="branchName"></span>؟</p>
        <div class="alert alert-warning">
          <i class="fas fa-exclamation-triangle"></i>
          تحذير: لا يمكن حذف الفرع إذا كان يحتوي على طلبات.
        </div>
      </div>
      <div class="modal-footer">
        <form action="/branches/delete" method="post" id="deleteForm">
          <!-- رمز CSRF للحماية من هجمات CSRF -->
          <input type="hidden" name="csrf_token" value="<?php echo $auth->generateCSRFToken(); ?>">
          <input type="hidden" name="branch_id" id="branchId">

          <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
          <button type="submit" class="btn btn-danger">حذف</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    // تحديث بيانات نافذة تأكيد الحذف
    const deleteModal = document.getElementById('deleteModal');
    if (deleteModal) {
      deleteModal.addEventListener('show.bs.modal', function(event) {
        const button = event.relatedTarget;
        const branchId = button.getAttribute('data-id');
        const branchName = button.getAttribute('data-name');

        document.getElementById('branchId').value = branchId;
        document.getElementById('branchName').textContent = branchName;
      });
    }
  });
</script>

<?php
// الحصول على محتوى المخزن المؤقت
$content = ob_get_clean();

// تضمين القالب الرئيسي
include dirname(__DIR__) . '/layouts/main.php';
?>
