<?php
/**
 * متحكم المصادقة
 * يتعامل مع تسجيل الدخول والخروج وإدارة الجلسات
 *
 * @version 1.0
 * @author فريق التطوير
 */

namespace App\Controllers;

use App\Core\Auth;
use App\Models\Branch;

class AuthController {
    private $auth;
    private $branchModel;

    /**
     * إنشاء متحكم المصادقة
     */
    public function __construct() {
        $this->auth = Auth::getInstance();
        $this->branchModel = new Branch();
    }

    /**
     * عرض صفحة تسجيل الدخول
     */
    public function showLogin() {
        // التحقق مما إذا كان المستخدم مسجل الدخول بالفعل
        if ($this->auth->isLoggedIn()) {
            header('Location: /dashboard');
            exit;
        }

        // الحصول على قائمة الفروع النشطة
        $branches = $this->branchModel->getActive();

        // تمرير متغير $auth إلى الصفحة
        $auth = $this->auth;

        // عرض صفحة تسجيل الدخول
        include dirname(__DIR__) . '/views/auth/login.php';
    }

    /**
     * معالجة تسجيل الدخول
     */
    public function login() {
        // التحقق من طريقة الطلب
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header('Location: /login');
            exit;
        }

        // التحقق من رمز CSRF
        if (!isset($_POST['csrf_token']) || !$this->auth->verifyCSRFToken($_POST['csrf_token'])) {
            $_SESSION['login_error'] = 'خطأ في التحقق من الأمان. يرجى المحاولة مرة أخرى.';
            header('Location: /login');
            exit;
        }

        // الحصول على بيانات النموذج
        $email = $_POST['email'] ?? '';
        $password = $_POST['password'] ?? '';
        $branch_id = $_POST['branch_id'] ?? null;
        $remember = isset($_POST['remember']) ? true : false;

        // التحقق من البيانات
        if (empty($email) || empty($password)) {
            $_SESSION['login_error'] = 'يرجى إدخال البريد الإلكتروني وكلمة المرور.';
            header('Location: /login');
            exit;
        }

        // محاولة تسجيل الدخول
        $loginSuccess = $this->auth->login($email, $password, $branch_id);

        if ($loginSuccess) {
            // تعيين ملف تعريف الارتباط إذا تم تحديد "تذكرني"
            if ($remember) {
                $this->setRememberMeCookie();
            }

            // إعادة توجيه المستخدم إلى لوحة التحكم
            header('Location: /dashboard');
            exit;
        } else {
            // فشل تسجيل الدخول
            $_SESSION['login_error'] = 'بيانات الاعتماد غير صحيحة. يرجى المحاولة مرة أخرى.';
            header('Location: /login');
            exit;
        }
    }

    /**
     * تسجيل خروج المستخدم
     */
    public function logout() {
        // تسجيل خروج المستخدم
        $this->auth->logout();

        // حذف ملف تعريف الارتباط "تذكرني"
        $this->clearRememberMeCookie();

        // إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
        header('Location: /login');
        exit;
    }

    /**
     * تعيين ملف تعريف الارتباط "تذكرني"
     */
    private function setRememberMeCookie() {
        $user = $this->auth->getUser();
        if (!$user) {
            return;
        }

        // إنشاء رمز فريد
        $token = bin2hex(random_bytes(32));
        $userId = $user['id'];

        // حفظ الرمز في قاعدة البيانات
        // يمكن إضافة جدول remember_tokens لتخزين الرموز
        // $this->userModel->saveRememberToken($userId, $token);

        // تعيين ملف تعريف الارتباط (صالح لمدة 30 يومًا)
        $expiry = time() + (30 * 24 * 60 * 60);
        setcookie('remember_token', $token, $expiry, '/', '', false, true);
        setcookie('remember_user', $userId, $expiry, '/', '', false, true);
    }

    /**
     * حذف ملف تعريف الارتباط "تذكرني"
     */
    private function clearRememberMeCookie() {
        // حذف ملفات تعريف الارتباط
        setcookie('remember_token', '', time() - 3600, '/', '', false, true);
        setcookie('remember_user', '', time() - 3600, '/', '', false, true);
    }

    /**
     * التحقق من ملف تعريف الارتباط "تذكرني"
     */
    public function checkRememberMe() {
        if ($this->auth->isLoggedIn()) {
            return true;
        }

        if (isset($_COOKIE['remember_token']) && isset($_COOKIE['remember_user'])) {
            $token = $_COOKIE['remember_token'];
            $userId = $_COOKIE['remember_user'];

            // التحقق من صحة الرمز في قاعدة البيانات
            // $isValid = $this->userModel->validateRememberToken($userId, $token);

            // إذا كان الرمز صالحًا، قم بتسجيل دخول المستخدم تلقائيًا
            // if ($isValid) {
            //     $user = $this->userModel->findById($userId);
            //     if ($user) {
            //         // تعيين بيانات المستخدم في الجلسة
            //         $_SESSION['user_id'] = $user['id'];
            //         $_SESSION['username'] = $user['username'];
            //         $_SESSION['full_name'] = $user['full_name'];
            //         $_SESSION['email'] = $user['email'];
            //         $_SESSION['role'] = $user['role'];
            //         $_SESSION['logged_in'] = true;
            //
            //         // تحديث ملف تعريف الارتباط
            //         $this->setRememberMeCookie();
            //
            //         return true;
            //     }
            // }
        }

        return false;
    }

    /**
     * عرض صفحة نسيت كلمة المرور
     */
    public function showForgotPassword() {
        // عرض صفحة نسيت كلمة المرور
        include dirname(__DIR__) . '/views/auth/forgot_password.php';
    }

    /**
     * معالجة طلب إعادة تعيين كلمة المرور
     */
    public function forgotPassword() {
        // التحقق من طريقة الطلب
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header('Location: /forgot-password');
            exit;
        }

        // الحصول على البريد الإلكتروني
        $email = $_POST['email'] ?? '';

        if (empty($email)) {
            $_SESSION['forgot_error'] = 'يرجى إدخال البريد الإلكتروني.';
            header('Location: /forgot-password');
            exit;
        }

        // التحقق من وجود المستخدم
        // $user = $this->userModel->findByEmail($email);
        // if (!$user) {
        //     $_SESSION['forgot_error'] = 'البريد الإلكتروني غير مسجل في النظام.';
        //     header('Location: /forgot-password');
        //     exit;
        // }

        // إنشاء رمز إعادة تعيين كلمة المرور
        // $token = bin2hex(random_bytes(32));
        // $this->userModel->saveResetToken($user['id'], $token);

        // إرسال بريد إلكتروني بالرمز
        // $resetLink = "http://{$_SERVER['HTTP_HOST']}/reset-password?token={$token}";
        // $this->sendResetEmail($email, $resetLink);

        // عرض رسالة نجاح
        $_SESSION['forgot_success'] = 'تم إرسال رابط إعادة تعيين كلمة المرور إلى بريدك الإلكتروني.';
        header('Location: /forgot-password');
        exit;
    }
}
