<?php
// تضمين ملف التحقق من تسجيل الدخول
require_once 'check_auth.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>نظام طلبات الشحن | إدارة الطلبات</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="../assets/css/unified-design.css">
  <style>
    /* كروت الإحصائيات */
    .stat-card {
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .stat-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }

    /* حقول الإدخال */
    .form-input {
      transition: all 0.3s ease;
      border: 1px solid #e2e8f0;
      background-color: #f8fafc;
    }

    .form-input:focus {
      border-color: var(--primary-light);
      box-shadow: 0 0 0 3px rgba(129, 140, 248, 0.3);
      background-color: white;
    }

    /* شريط التقدم */
    .progress-bar {
      height: 6px;
      border-radius: 3px;
      background-color: #e2e8f0;
      overflow: hidden;
    }

    .progress-bar-fill {
      height: 100%;
      background: linear-gradient(90deg, var(--primary) 0%, var(--primary-light) 100%);
      transition: width 0.6s ease;
    }

    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
      width: 8px;
      height: 8px;
    }

    ::-webkit-scrollbar-track {
      background: #f1f5f9;
    }

    ::-webkit-scrollbar-thumb {
      background-color: #c7d2fe;
      border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
      background-color: #a5b4fc;
    }

    /* تنسيق القائمة المنسدلة */
    .dropdown-menu {
      max-height: 0;
      overflow: hidden;
      transition: max-height 0.3s ease;
      margin-right: 2.5rem;
    }

    .dropdown-menu.active {
      max-height: 200px;
    }

    .dropdown-toggle {
      position: relative;
    }

    .dropdown-toggle::after {
      content: '\f107';
      font-family: 'Font Awesome 5 Free';
      font-weight: 900;
      position: absolute;
      left: 1rem;
      top: 50%;
      transform: translateY(-50%);
      transition: transform 0.3s ease;
    }

    .dropdown-toggle.active::after {
      transform: translateY(-50%) rotate(180deg);
    }

    /* تصميم ملف المستخدم */
    .user-profile {
      display: flex;
      align-items: center;
      gap: 0.75rem;
    }

    .user-avatar {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: bold;
      background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
      color: white;
      box-shadow: var(--shadow-sm);
      transition: var(--transition);
    }

    /* تأثير عنوان الصفحة */
    h1.text-2xl {
      position: relative;
      display: inline-block;
      transition: all 0.3s ease;
    }

    h1.text-2xl::after {
      content: '';
      position: absolute;
      bottom: -5px;
      right: 0;
      width: 0;
      height: 2px;
      background: linear-gradient(to left, var(--primary), transparent);
      transition: width 0.5s ease;
    }

    h1.text-2xl:hover::after {
      width: 100%;
    }

    /* تأثيرات إضافية للصورة الرمزية */
    aside .user-avatar {
      background: rgba(255, 255, 255, 0.1);
      border: 2px solid rgba(255, 255, 255, 0.2);
    }

    .user-avatar:hover {
      transform: scale(1.1);
      box-shadow: 0 0 15px rgba(79, 70, 229, 0.3);
    }

    /* تأثير الشعار */
    .logo-reveal {
      animation: logoReveal 1.5s ease-out forwards;
      transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      border-radius: 8px;
      position: relative;
      z-index: 2;
      max-height: 100px;
      width: auto;
    }

    .logo-reveal:hover {
      transform: scale(1.08) rotate(1deg);
      filter: brightness(1.2) contrast(1.1) drop-shadow(0 10px 20px rgba(0, 0, 0, 0.25));
    }

    @keyframes logoReveal {
      0% {
        opacity: 0;
        transform: scale(0.8);
      }
      50% {
        opacity: 0.5;
        transform: scale(1.05);
      }
      100% {
        opacity: 1;
        transform: scale(1);
      }
    }

    /* تأثير إضافي للشعار */
    aside .logo-container::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, rgba(255,255,255,0.3) 0%, rgba(255,255,255,0) 50%, rgba(255,255,255,0.3) 100%);
      transform: translateX(-100%);
      transition: transform 1s ease;
    }

    aside .logo-container:hover::before {
      transform: translateX(100%);
    }

    /* تأثير الشعار */
    .logo-reveal {
      animation: logoReveal 1.5s ease-out forwards;
      transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      border-radius: 8px;
      position: relative;
      z-index: 2;
      max-height: 100px;
      width: auto;
    }

    .logo-reveal:hover {
      transform: scale(1.08) rotate(1deg);
      filter: brightness(1.2) contrast(1.1) drop-shadow(0 10px 20px rgba(0, 0, 0, 0.25));
    }

    @keyframes logoReveal {
      0% {
        opacity: 0;
        transform: scale(0.8);
      }
      50% {
        opacity: 0.5;
        transform: scale(1.05);
      }
      100% {
        opacity: 1;
        transform: scale(1);
      }
    }

    /* تأثير إضافي للشعار */
    aside .logo-container::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, rgba(255,255,255,0.3) 0%, rgba(255,255,255,0) 50%, rgba(255,255,255,0.3) 100%);
      transform: translateX(-100%);
      transition: transform 1s ease;
    }

    aside .logo-container:hover::before {
      transform: translateX(100%);
    }

    /* تحسين جدول الطلبات */
    .data-table {
      border-radius: var(--border-radius);
      overflow: hidden;
      box-shadow: var(--shadow);
    }

    .data-table thead th {
      background-color: var(--primary);
      color: white;
      font-weight: 500;
      text-transform: none;
      letter-spacing: 0;
      padding: 1rem;
    }

    .data-table tbody tr {
      transition: var(--transition);
    }

    .data-table tbody tr:hover {
      background-color: rgba(79, 70, 229, 0.05);
    }

    .data-table tbody td {
      padding: 1rem;
      vertical-align: middle;
    }
  </style>
</head>

<body>
  <!-- طبقة التراكب للأجهزة المحمولة -->
  <div id="overlay" class="overlay"></div>

  <div class="flex min-h-screen">
    <!-- القائمة الجانبية -->
    <aside class="w-64 hidden md:block">
      <div class="p-6">
        <div class="logo-container flex items-center justify-center mb-8 p-2">
          <img src="../assets/images/backgrounds/background.png" alt="شعار النظام" class="h-40 w-auto object-contain logo-reveal">
        </div>

        <div class="user-info mb-8">
          <div class="flex items-center space-x-4 space-x-reverse mb-3">
            <div class="user-avatar">
              <?php echo mb_substr($currentUser['full_name'], 0, 1, 'UTF-8'); ?>
            </div>
            <div>
              <h3 class="text-white font-semibold"><?php echo htmlspecialchars($currentUser['full_name']); ?></h3>
              <p class="text-indigo-200 text-sm"><?php echo $currentUser['role'] === 'admin' ? 'مدير النظام' : 'مستخدم'; ?></p>
            </div>
          </div>
          <div class="bg-white/10 h-0.5 rounded-full mb-3"></div>
        </div>

        <nav>
          <ul class="space-y-3">
            <!-- لوحة التحكم -->
            <li>
              <a href="../unified-dashboard.php" class="flex items-center p-3 rounded-lg text-white/80 hover:text-white">
                <i class="fas fa-tachometer-alt ml-3 text-lg"></i>
                <span>لوحة التحكم</span>
              </a>
            </li>

            <!-- إنشاء طلب جديد -->
            <li>
              <a href="../create-order-unified.php" class="flex items-center p-3 rounded-lg text-white/80 hover:text-white">
                <i class="fas fa-plus-circle ml-3 text-lg"></i>
                <span>إنشاء طلب جديد</span>
              </a>
            </li>

            <!-- قائمة الطلبات -->
            <li>
              <a href="../orders.php" class="flex items-center p-3 rounded-lg text-white active">
                <i class="fas fa-box ml-3 text-lg"></i>
                <span>قائمة الطلبات</span>
              </a>
            </li>

            <?php if ($currentUser['role'] === 'admin'): ?>
            <!-- قائمة التقارير المنسدلة -->
            <li>
              <a href="#" class="flex items-center p-3 rounded-lg text-white/80 hover:text-white dropdown-toggle" id="reportsDropdown">
                <i class="fas fa-chart-bar ml-3 text-lg"></i>
                <span>التقارير</span>
              </a>
              <ul class="dropdown-menu" id="reportsMenu">
                <li>
                  <a href="../weekly-reports.php" class="flex items-center p-2 rounded-lg text-white/80 hover:text-white">
                    <i class="fas fa-calendar-week ml-2 text-sm"></i>
                    <span>التقارير الأسبوعية</span>
                  </a>
                </li>
                <li>
                  <a href="../monthly-reports.php" class="flex items-center p-2 rounded-lg text-white/80 hover:text-white">
                    <i class="fas fa-calendar-alt ml-2 text-sm"></i>
                    <span>التقارير الشهرية</span>
                  </a>
                </li>
              </ul>
            </li>

            <!-- إدارة المستخدمين -->
            <li>
              <a href="../users.php" class="flex items-center p-3 rounded-lg text-white/80 hover:text-white">
                <i class="fas fa-users ml-3 text-lg"></i>
                <span>إدارة المستخدمين</span>
              </a>
            </li>

            <!-- الفروع -->
            <li>
              <a href="../branches.php" class="flex items-center p-3 rounded-lg text-white/80 hover:text-white">
                <i class="fas fa-code-branch ml-3 text-lg"></i>
                <span>الفروع</span>
              </a>
            </li>

            <!-- إعدادات النظام -->
            <li>
              <a href="../settings.php" class="flex items-center p-3 rounded-lg text-white/80 hover:text-white">
                <i class="fas fa-cog ml-3 text-lg"></i>
                <span>إعدادات النظام</span>
              </a>
            </li>
            <?php endif; ?>
          </ul>

          <div class="pt-6 mt-6 border-t border-white/10">
            <a href="../auth/logout.php" class="flex items-center p-3 rounded-lg text-white/80 hover:text-white">
              <i class="fas fa-sign-out-alt ml-3 text-lg"></i>
              <span>تسجيل الخروج</span>
            </a>
          </div>
        </nav>
      </div>
    </aside>

    <!-- المحتوى الرئيسي -->
    <main class="flex-1">
      <!-- الشريط العلوي -->
      <header class="top-bar">
        <div class="flex items-center">
          <button id="toggleSidebar" class="md:hidden text-gray-600 hover:text-primary p-2 rounded-lg">
            <i class="fas fa-bars text-xl"></i>
          </button>

          <!-- شعار النظام في الشريط العلوي (يظهر فقط في الأجهزة المحمولة) -->
          <div class="flex items-center md:hidden ml-3">
            <img src="../assets/images/backgrounds/background.png" alt="شعار النظام" class="h-16 w-auto object-contain logo-reveal">
          </div>

          <div class="relative ml-4 hidden md:block">
            <input type="text" placeholder="البحث..." class="bg-gray-100 rounded-full py-2 px-4 pl-10 w-64 focus:outline-none focus:ring-2 focus:ring-primary/30 focus:bg-white transition-all">
            <i class="fas fa-search absolute right-3 top-3 text-gray-400"></i>
          </div>
        </div>

        <!-- معلومات المستخدم والإشعارات -->
        <div class="flex items-center space-x-4 space-x-reverse">
          <?php if ($currentUser['role'] === 'admin'): ?>
          <div class="relative">
            <button class="relative p-2 rounded-full hover:bg-gray-100 transition-all">
              <i class="fas fa-bell text-gray-600"></i>
              <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center animate-pulse">3</span>
            </button>
          </div>
          <?php endif; ?>

          <div class="relative">
            <button class="relative p-2 rounded-full hover:bg-gray-100 transition-all">
              <i class="fas fa-envelope text-gray-600"></i>
              <?php if ($currentUser['role'] === 'admin'): ?>
              <span class="absolute -top-1 -right-1 bg-primary text-white text-xs rounded-full h-5 w-5 flex items-center justify-center">2</span>
              <?php endif; ?>
            </button>
          </div>

          <div class="border-r border-gray-300 h-8 mx-2"></div>

          <div class="user-profile">
            <div class="user-avatar">
              <?php echo mb_substr($currentUser['full_name'], 0, 1, 'UTF-8'); ?>
            </div>
            <div>
              <p class="font-medium text-sm"><?php echo htmlspecialchars($currentUser['full_name']); ?></p>
              <p class="text-xs text-gray-500"><?php echo $currentUser['role'] === 'admin' ? 'مدير النظام' : 'مستخدم'; ?></p>
            </div>
          </div>
        </div>
      </header>

    <!-- محتوى الصفحة -->
    <div class="p-6">
      <!-- رأس الصفحة -->
      <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-8">
        <div class="animate-fadeIn" style="animation-delay: 0.1s;">
          <h1 class="text-3xl font-bold text-gray-800 flex items-center">
            <span class="bg-gradient-to-r from-primary to-primary-light bg-clip-text text-transparent">
              إدارة الطلبات
            </span>
          </h1>
          <p class="text-gray-500 mt-2 flex items-center">
            <i class="fas fa-box ml-2 text-primary"></i>
            <span>عرض وإدارة جميع طلبات الشحن</span>
          </p>
        </div>

        <div class="mt-4 md:mt-0 animate-fadeIn" style="animation-delay: 0.2s;">
          <div class="flex items-center space-x-4 space-x-reverse">
            <div class="text-sm bg-indigo-50 text-indigo-700 px-3 py-1 rounded-full">
              <i class="fas fa-filter ml-2"></i>
              <span>الكل (0)</span>
            </div>


            <button onclick="window.location.href='../create-order-unified.php'" class="btn btn-secondary">
              <i class="fas fa-plus ml-2"></i>
              <span>إضافة طلب جديد</span>
            </button>
          </div>
        </div>
      </div>

      <!-- فلترة الطلبات -->
      <div class="bg-white rounded-xl shadow-sm p-4 mb-6 animate-fadeIn" style="animation-delay: 0.3s;">
        <div class="flex flex-wrap items-center justify-between gap-4">
          <!-- فلتر الفروع -->
          <div class="flex items-center">
            <button id="filterButton" class="btn btn-primary">
              <i class="fas fa-filter"></i>
              <span>تصفية</span>
            </button>
            <select id="branchFilter" class="form-input mr-2">
              <option value="">كل الفروع</option>
              <!-- سيتم تعبئة الفروع ديناميكياً -->
            </select>
          </div>

          <!-- فلتر الحالة -->
          <div class="flex items-center mr-4">
            <select id="statusFilter" class="form-input">
              <option value="">كل الحالات</option>
              <option value="قيد المعالجة">قيد المعالجة</option>
              <option value="في الطريق">في الطريق</option>
              <option value="تم التسليم">تم التسليم</option>
              <option value="ملغى">ملغى</option>
            </select>
          </div>

          <!-- فلتر التاريخ -->
          <div class="flex items-center">
            <span class="ml-2 text-gray-600">من</span>
            <div class="relative">
              <input type="date" class="form-input ml-2" id="dateFrom">
              <i class="fas fa-calendar-alt absolute left-3 top-3 text-gray-400"></i>
            </div>
            <span class="mx-2 text-gray-600">إلى</span>
            <div class="relative">
              <input type="date" class="form-input" id="dateTo">
              <i class="fas fa-calendar-alt absolute left-3 top-3 text-gray-400"></i>
            </div>
          </div>

          <!-- البحث -->
          <div class="flex items-center mr-4">
            <div class="relative">
              <input type="text" id="searchInput" class="form-input pl-10" placeholder="بحث...">
              <i class="fas fa-search absolute right-3 top-3 text-gray-400"></i>
            </div>
          </div>


        </div>
      </div>



      <!-- جدول الطلبات -->
      <div class="bg-white rounded-xl shadow-sm overflow-hidden animate-fadeIn">
        <div class="overflow-x-auto">
          <table class="data-table min-w-full divide-y divide-gray-200">
            <thead>
              <tr>
                <th scope="col" class="text-center">#</th>
                <th scope="col" class="text-right">الرقم التسلسلي</th>
                <th scope="col" class="text-right">اسم العميل</th>
                <th scope="col" class="text-right">نوع الخدمة</th>
                <th scope="col" class="text-right">نوع البضاعة</th>
                <th scope="col" class="text-right">اسم البضاعة</th>
                <th scope="col" class="text-right">مدة الوصول</th>
                <th scope="col" class="text-right">نوع الدفع</th>
                <th scope="col" class="text-right">المدفوع</th>
                <th scope="col" class="text-right">المتبقي</th>
                <th scope="col" class="text-right">الوجهة الثانية</th>
                <th scope="col" class="text-right">منطقة التسليم</th>
                <th scope="col" class="text-right">تاريخ الطلب</th>
                <th scope="col" class="text-right">التسليم</th>
                <th scope="col" class="text-right">الحالة</th>
                <th scope="col" class="text-center">إجراء</th>
              </tr>
            </thead>
            <tbody id="ordersTableBody">
              <!-- سيتم إضافة الطلبات هنا ديناميكياً -->
              <tr>
                <td colspan="16" class="text-center py-8">
                  <div class="flex flex-col items-center justify-center text-gray-500">
                    <i class="fas fa-spinner fa-spin text-4xl mb-3 text-primary"></i>
                    <p>جاري تحميل البيانات...</p>
                  </div>
                </td>
              </tr>
            </tbody>
          </table>
        </div>

        <!-- تذييل الجدول -->
        <div class="bg-gray-50 px-6 py-4 flex items-center justify-between border-t border-gray-200">
          <div class="flex-1 flex justify-between items-center sm:hidden">
            <button class="btn btn-outline-primary btn-sm">
              <i class="fas fa-chevron-right ml-1"></i>
              <span>السابق</span>
            </button>
            <button class="btn btn-outline-primary btn-sm">
              <span>التالي</span>
              <i class="fas fa-chevron-left mr-1"></i>
            </button>
          </div>
          <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
            <div>
              <p class="text-sm text-gray-700 bg-white px-4 py-2 rounded-lg shadow-sm">
                عرض
                <span id="fromCount" class="font-medium text-primary">0</span>
                إلى
                <span id="toCount" class="font-medium text-primary">0</span>
                من
                <span id="totalOrdersCount" class="font-medium text-primary">0</span>
                نتائج
              </p>
            </div>
            <div>
              <nav id="pagination" class="btn-group" aria-label="Pagination">
                <!-- سيتم إنشاء أزرار الترقيم ديناميكياً -->
              </nav>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>



  <!-- سكريبت إدارة الطلبات -->
  <script>
    // تعديل مسار API لتناسب الهيكل الحالي
    document.addEventListener('DOMContentLoaded', function() {
      // تهيئة متغيرات عامة
      let currentPage = 1;
      let totalPages = 1;
      let ordersPerPage = 10;

      // عناصر DOM
      const ordersTableBody = document.getElementById('ordersTableBody');
      const branchFilter = document.getElementById('branchFilter');
      const dateFromFilter = document.getElementById('dateFrom');
      const dateToFilter = document.getElementById('dateTo');
      const statusFilter = document.getElementById('statusFilter');
      const searchInput = document.getElementById('searchInput');
      const filterButton = document.getElementById('filterButton');
      const paginationContainer = document.getElementById('pagination');
      const totalOrdersCount = document.getElementById('totalOrdersCount');
      const fromCount = document.getElementById('fromCount');
      const toCount = document.getElementById('toCount');

      // تحميل الطلبات عند تحميل الصفحة
      loadOrders();

      // إضافة مستمعي الأحداث
      if (filterButton) {
          filterButton.addEventListener('click', function() {
              currentPage = 1;
              loadOrders();
          });
      }

      if (searchInput) {
          searchInput.addEventListener('keyup', function(e) {
              if (e.key === 'Enter') {
                  currentPage = 1;
                  loadOrders();
              }
          });
      }

      /**
       * تحميل الطلبات من الخادم
       */
      function loadOrders() {
          // إظهار مؤشر التحميل
          showLoading();

          // بناء معلمات الاستعلام
          const params = new URLSearchParams();
          params.append('page', currentPage);
          params.append('limit', ordersPerPage);

          // إضافة معلمات الفلترة
          if (branchFilter && branchFilter.value) {
              params.append('branch', branchFilter.value);
          }

          if (dateFromFilter && dateFromFilter.value) {
              params.append('date_from', dateFromFilter.value);
          }

          if (dateToFilter && dateToFilter.value) {
              params.append('date_to', dateToFilter.value);
          }

          if (statusFilter && statusFilter.value) {
              params.append('status', statusFilter.value);
          }

          if (searchInput && searchInput.value) {
              params.append('search', searchInput.value);
          }

          // إرسال طلب AJAX
          fetch(`../api/get_orders.php?${params.toString()}`)
              .then(response => response.json())
              .then(data => {
                  if (data.status === 'success') {
                      // تحديث الجدول بالبيانات
                      renderOrders(data.orders);

                      // تحديث معلومات الترقيم
                      updatePagination(data.page, data.totalPages, data.total);
                  } else {
                      // عرض رسالة الخطأ
                      showError(data.message || 'حدث خطأ أثناء تحميل البيانات');
                  }
              })
              .catch(error => {
                  console.error('Error fetching orders:', error);
                  showError('حدث خطأ في الاتصال بالخادم');
              });
      }

      /**
       * عرض الطلبات في الجدول
       * @param {Array} orders قائمة الطلبات
       */
      function renderOrders(orders) {
          // مسح محتوى الجدول
          ordersTableBody.innerHTML = '';

          if (!orders || orders.length === 0) {
              // عرض رسالة عدم وجود طلبات
              ordersTableBody.innerHTML = `
                  <tr>
                      <td colspan="16" class="text-center py-8">
                          <div class="flex flex-col items-center justify-center text-gray-500">
                              <i class="fas fa-box text-4xl mb-3 text-gray-300"></i>
                              <p>لا توجد طلبات</p>
                          </div>
                      </td>
                  </tr>
              `;
              return;
          }

          // إنشاء صفوف الجدول
          orders.forEach((order, index) => {
              // تحديد لون حالة الطلب
              let statusClass = '';
              let statusIcon = '';

              switch (order.status) {
                  case 'قيد المعالجة':
                      statusClass = 'bg-blue-100 text-blue-800';
                      statusIcon = 'clock';
                      break;
                  case 'في الطريق':
                      statusClass = 'bg-yellow-100 text-yellow-800';
                      statusIcon = 'truck';
                      break;
                  case 'تم التسليم':
                      statusClass = 'bg-green-100 text-green-800';
                      statusIcon = 'check-circle';
                      break;
                  case 'ملغى':
                      statusClass = 'bg-red-100 text-red-800';
                      statusIcon = 'times-circle';
                      break;
                  default:
                      statusClass = 'bg-gray-100 text-gray-800';
                      statusIcon = 'question-circle';
              }

              // إنشاء صف الجدول
              const row = document.createElement('tr');
              row.className = 'hover:bg-gray-50 transition-colors';
              row.innerHTML = `
                  <td class="text-center">${(currentPage - 1) * ordersPerPage + index + 1}</td>
                  <td class="font-medium">${order.orderNumber || order.order_number}</td>
                  <td>${order.clientName || order.client_name}</td>
                  <td>${order.serviceType || order.service_type || '-'}</td>
                  <td>${order.goodsType || order.goods_type || '-'}</td>
                  <td>${order.goodsName || order.goods_name || '-'}</td>
                  <td>${order.deliveryDuration || order.delivery_duration || '-'}</td>
                  <td>${order.paymentType || order.payment_type || '-'}</td>
                  <td>${order.amountPaid || order.amount_paid ? (order.amountPaid || order.amount_paid) + ' ' + (order.currency || '') : '-'}</td>
                  <td>${order.remainingAmount || order.remaining_amount ? (order.remainingAmount || order.remaining_amount) + ' ' + (order.currency || '') : '-'}</td>
                  <td>${order.secondDestination || order.second_destination || '-'}</td>
                  <td>${order.deliveryArea || order.delivery_area || '-'}</td>
                  <td>${order.uploadDate || order.order_upload_date || '-'}</td>
                  <td>${order.deliveryDate || order.scheduled_delivery_date || '-'}</td>
                  <td>
                      <span class="px-2 py-1 rounded-full text-xs ${statusClass}">
                          <i class="fas fa-${statusIcon} ml-1"></i>
                          ${order.status}
                      </span>
                  </td>
                  <td class="text-center">
                      <div class="flex items-center justify-center space-x-2 space-x-reverse">
                          <a href="order-details.php?id=${order.id}" class="p-1 text-primary hover:bg-primary/10 rounded-full transition-all" title="عرض التفاصيل">
                              <i class="fas fa-eye"></i>
                          </a>
                          <a href="edit-order.php?id=${order.id}" class="p-1 text-info hover:bg-info/10 rounded-full transition-all" title="تعديل الطلب">
                              <i class="fas fa-edit"></i>
                          </a>
                          <button class="delete-order-btn p-1 text-danger hover:bg-danger/10 rounded-full transition-all" title="حذف الطلب" data-id="${order.id}">
                              <i class="fas fa-trash-alt"></i>
                          </button>
                      </div>
                  </td>
              `;

              // إضافة الصف إلى الجدول
              ordersTableBody.appendChild(row);
          });

          // إضافة مستمعي الأحداث لأزرار الإجراءات
          addActionListeners();
      }

      /**
       * تحديث معلومات الترقيم
       * @param {number} page الصفحة الحالية
       * @param {number} pages إجمالي عدد الصفحات
       * @param {number} total إجمالي عدد الطلبات
       */
      function updatePagination(page, pages, total) {
          currentPage = page;
          totalPages = pages;

          // تحديث عداد الطلبات
          if (totalOrdersCount) {
              totalOrdersCount.textContent = total;
          }

          // تحديث نطاق العرض
          const from = (page - 1) * ordersPerPage + 1;
          const to = Math.min(page * ordersPerPage, total);

          if (fromCount) {
              fromCount.textContent = from;
          }

          if (toCount) {
              toCount.textContent = to;
          }

          // تحديث أزرار الترقيم
          if (paginationContainer) {
              renderPaginationButtons(page, pages);
          }
      }

      /**
       * إنشاء أزرار الترقيم
       * @param {number} currentPage الصفحة الحالية
       * @param {number} totalPages إجمالي عدد الصفحات
       */
      function renderPaginationButtons(currentPage, totalPages) {
          paginationContainer.innerHTML = '';

          // زر الصفحة السابقة
          const prevButton = document.createElement('button');
          prevButton.className = `btn btn-outline-primary btn-sm btn-rounded ${currentPage === 1 ? 'opacity-50 cursor-not-allowed' : ''}`;
          prevButton.innerHTML = '<i class="fas fa-chevron-right"></i>';
          prevButton.disabled = currentPage === 1;
          prevButton.addEventListener('click', () => {
              if (currentPage > 1) {
                  goToPage(currentPage - 1);
              }
          });
          paginationContainer.appendChild(prevButton);

          // أزرار الصفحات
          const maxVisiblePages = 5;
          let startPage = Math.max(1, currentPage - Math.floor(maxVisiblePages / 2));
          let endPage = Math.min(totalPages, startPage + maxVisiblePages - 1);

          if (endPage - startPage + 1 < maxVisiblePages) {
              startPage = Math.max(1, endPage - maxVisiblePages + 1);
          }

          for (let i = startPage; i <= endPage; i++) {
              const pageButton = document.createElement('button');
              pageButton.className = `btn ${i === currentPage ? 'btn-primary' : 'btn-outline-primary'} btn-sm`;
              pageButton.textContent = i;
              pageButton.addEventListener('click', () => goToPage(i));
              paginationContainer.appendChild(pageButton);
          }

          // زر الصفحة التالية
          const nextButton = document.createElement('button');
          nextButton.className = `btn btn-outline-primary btn-sm btn-rounded ${currentPage === totalPages ? 'opacity-50 cursor-not-allowed' : ''}`;
          nextButton.innerHTML = '<i class="fas fa-chevron-left"></i>';
          nextButton.disabled = currentPage === totalPages;
          nextButton.addEventListener('click', () => {
              if (currentPage < totalPages) {
                  goToPage(currentPage + 1);
              }
          });
          paginationContainer.appendChild(nextButton);
      }

      /**
       * الانتقال إلى صفحة محددة
       * @param {number} page رقم الصفحة
       */
      function goToPage(page) {
          if (page !== currentPage && page >= 1 && page <= totalPages) {
              currentPage = page;
              loadOrders();
          }
      }

      /**
       * إضافة مستمعي الأحداث لأزرار الإجراءات
       */
      function addActionListeners() {
          // أزرار حذف الطلب
          document.querySelectorAll('.delete-order-btn').forEach(btn => {
              btn.addEventListener('click', function() {
                  const orderId = this.getAttribute('data-id');
                  confirmDeleteOrder(orderId);
              });
          });
      }

      /**
       * تأكيد حذف الطلب
       * @param {number} orderId معرف الطلب
       */
      function confirmDeleteOrder(orderId) {
          if (confirm('هل أنت متأكد من حذف هذا الطلب؟')) {
              deleteOrder(orderId);
          }
      }

      /**
       * حذف الطلب
       * @param {number} orderId معرف الطلب
       */
      function deleteOrder(orderId) {
          fetch('../api/delete_order.php', {
              method: 'POST',
              headers: {
                  'Content-Type': 'application/json',
              },
              body: JSON.stringify({ id: orderId })
          })
          .then(response => response.json())
          .then(data => {
              if (data.status === 'success') {
                  // إعادة تحميل الطلبات بعد الحذف
                  loadOrders();
                  alert('تم حذف الطلب بنجاح');
              } else {
                  alert(data.message || 'فشل في حذف الطلب');
              }
          })
          .catch(error => {
              console.error('Error deleting order:', error);
              alert('حدث خطأ أثناء حذف الطلب');
          });
      }

      /**
       * إظهار مؤشر التحميل
       */
      function showLoading() {
          ordersTableBody.innerHTML = `
              <tr>
                  <td colspan="16" class="text-center py-8">
                      <div class="flex flex-col items-center justify-center text-gray-500">
                          <i class="fas fa-spinner fa-spin text-4xl mb-3 text-primary"></i>
                          <p>جاري تحميل البيانات...</p>
                      </div>
                  </td>
              </tr>
          `;
      }

      /**
       * عرض رسالة خطأ
       * @param {string} message نص الرسالة
       */
      function showError(message) {
          ordersTableBody.innerHTML = `
              <tr>
                  <td colspan="16" class="text-center py-8">
                      <div class="flex flex-col items-center justify-center text-red-500">
                          <i class="fas fa-exclamation-circle text-4xl mb-3"></i>
                          <p>${message}</p>
                      </div>
                  </td>
              </tr>
          `;
      }
    });
  </script>

  <!-- سكريبت إضافي لتحسين واجهة المستخدم -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // تهيئة القائمة الجانبية للأجهزة المحمولة
      const sidebar = document.querySelector('aside');
      const overlay = document.getElementById('overlay');
      const toggleSidebarBtn = document.getElementById('toggleSidebar');

      // إضافة مستمع حدث لزر تبديل القائمة الجانبية
      if (toggleSidebarBtn) {
        toggleSidebarBtn.addEventListener('click', function() {
          sidebar.classList.toggle('active');
          overlay.classList.toggle('active');
        });
      }

      // إغلاق القائمة الجانبية عند النقر على الخلفية
      if (overlay) {
        overlay.addEventListener('click', function() {
          sidebar.classList.remove('active');
          overlay.classList.remove('active');
        });
      }

      // تهيئة القوائم المنسدلة
      const dropdownToggles = document.querySelectorAll('.dropdown-toggle');

      dropdownToggles.forEach(toggle => {
        toggle.addEventListener('click', function(e) {
          e.preventDefault();

          // الحصول على القائمة المنسدلة المرتبطة
          const dropdownId = this.getAttribute('id');
          const dropdownMenu = document.getElementById(dropdownId.replace('Dropdown', 'Menu'));

          if (dropdownMenu) {
            // تبديل حالة القائمة المنسدلة
            dropdownMenu.classList.toggle('active');
            this.classList.toggle('active');
          }
        });
      });

      // تهيئة مودال تصدير PDF
      if (document.getElementById('pdfExportModal')) {
        // تعريف دالة عرض المودال
        window.showPdfExportModal = function() {
          document.getElementById('pdfExportModal').classList.remove('hidden');
        };

        // تعريف دالة إخفاء المودال
        window.hidePdfExportModal = function() {
          document.getElementById('pdfExportModal').classList.add('hidden');
        };

        // إضافة مستمعي الأحداث
        document.getElementById('pdfExportBtn').addEventListener('click', showPdfExportModal);
        document.getElementById('closePdfModal').addEventListener('click', hidePdfExportModal);
        document.getElementById('closePdfModalBtn').addEventListener('click', hidePdfExportModal);

        // معالجة تقديم النموذج
        document.getElementById('pdfExportForm').addEventListener('submit', function(event) {
          event.preventDefault();

          // الحصول على قيم النموذج
          const dateFrom = document.getElementById('pdf-date-from').value;
          const dateTo = document.getElementById('pdf-date-to').value;
          const branchId = document.getElementById('pdf-branch').value;
          const status = document.getElementById('pdf-status').value;

          // بناء عنوان URL للتصدير
          let exportUrl = '../api/export_orders_pdf.php?';

          if (dateFrom) {
            exportUrl += `date_from=${dateFrom}&`;
          }

          if (dateTo) {
            exportUrl += `date_to=${dateTo}&`;
          }

          if (branchId) {
            exportUrl += `branch_id=${branchId}&`;
          }

          if (status) {
            exportUrl += `status=${status}&`;
          }

          // إخفاء المودال
          hidePdfExportModal();

          // فتح نافذة جديدة لتنزيل الملف
          window.open(exportUrl, '_blank');
        });
      }
    });
  </script>
</body>

</html>
