<?php
/**
 * صفحة عرض جميع الإشعارات
 */

// تضمين ملف التهيئة
require_once 'config/config.php';

// تضمين مدير الإشعارات
require_once 'includes/notifications_manager.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    // إعادة التوجيه إلى صفحة تسجيل الدخول
    header("Location: {$root_path}auth/login.php");
    exit;
}

// الحصول على معرف المستخدم الحالي
$currentUserId = $_SESSION['user_id'];

// الحصول على جميع الإشعارات
$notifications = getUserNotifications($currentUserId, 100, true);

// تضمين الهيدر
$pageTitle = "الإشعارات";
include 'includes/header.php';
?>

<div class="container mx-auto px-4 py-8">
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800">الإشعارات</h1>
            
            <?php if (count(array_filter($notifications, function($n) { return $n['is_read'] == 0; })) > 0): ?>
            <button id="markAllReadBtn" class="bg-primary text-white px-4 py-2 rounded-md hover:bg-primary-dark transition-all">
                تعيين الكل كمقروء
            </button>
            <?php endif; ?>
        </div>
        
        <?php if (empty($notifications)): ?>
        <div class="text-center py-8">
            <i class="fas fa-bell-slash text-gray-400 text-5xl mb-4"></i>
            <p class="text-gray-500">لا توجد إشعارات</p>
        </div>
        <?php else: ?>
        <div class="notifications-container">
            <?php foreach ($notifications as $notification): ?>
            <div class="notification-row <?php echo $notification['is_read'] ? 'read' : 'unread'; ?>" data-id="<?php echo $notification['id']; ?>">
                <div class="notification-icon <?php echo $notification['type']; ?>">
                    <i class="fas <?php 
                        echo $notification['type'] === 'success' ? 'fa-check-circle' : 
                             ($notification['type'] === 'warning' ? 'fa-exclamation-triangle' : 
                             ($notification['type'] === 'error' ? 'fa-times-circle' : 'fa-info-circle')); 
                    ?>"></i>
                </div>
                <div class="notification-content">
                    <h3><?php echo htmlspecialchars($notification['title']); ?></h3>
                    <p><?php echo htmlspecialchars($notification['message']); ?></p>
                    <div class="notification-meta">
                        <span class="notification-time">
                            <i class="far fa-clock ml-1"></i>
                            <?php echo date('d/m/Y H:i', strtotime($notification['created_at'])); ?>
                        </span>
                        <?php if (!$notification['is_read']): ?>
                        <span class="unread-badge">جديد</span>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if ($notification['link']): ?>
                <a href="<?php echo $notification['link']; ?>" class="notification-link">
                    <i class="fas fa-external-link-alt"></i>
                </a>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .notifications-container {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }
    
    .notification-row {
        display: flex;
        align-items: flex-start;
        padding: 16px;
        border-radius: 8px;
        border: 1px solid #eee;
        transition: all 0.2s ease;
    }
    
    .notification-row.unread {
        background-color: #f0f7ff;
        border-color: #d0e3ff;
    }
    
    .notification-row:hover {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    }
    
    .notification-icon {
        margin-left: 16px;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        font-size: 18px;
    }
    
    .notification-icon.info {
        background-color: #e6f7ff;
        color: #1890ff;
    }
    
    .notification-icon.success {
        background-color: #f6ffed;
        color: #52c41a;
    }
    
    .notification-icon.warning {
        background-color: #fffbe6;
        color: #faad14;
    }
    
    .notification-icon.error {
        background-color: #fff2f0;
        color: #ff4d4f;
    }
    
    .notification-content {
        flex: 1;
    }
    
    .notification-content h3 {
        font-size: 16px;
        font-weight: 600;
        margin: 0 0 8px 0;
        color: #333;
    }
    
    .notification-content p {
        font-size: 14px;
        color: #666;
        margin: 0 0 8px 0;
    }
    
    .notification-meta {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    
    .notification-time {
        font-size: 12px;
        color: #999;
    }
    
    .unread-badge {
        background-color: #4c0c70;
        color: white;
        font-size: 11px;
        padding: 2px 8px;
        border-radius: 10px;
    }
    
    .notification-link {
        margin-right: 16px;
        color: #4c0c70;
        font-size: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        transition: all 0.2s ease;
    }
    
    .notification-link:hover {
        background-color: #f0f0f0;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تعيين جميع الإشعارات كمقروءة
        const markAllReadBtn = document.getElementById('markAllReadBtn');
        if (markAllReadBtn) {
            markAllReadBtn.addEventListener('click', function() {
                fetch('<?php echo $root_path; ?>api/mark_all_notifications_read.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // تحديث واجهة المستخدم
                        document.querySelectorAll('.notification-row.unread').forEach(row => {
                            row.classList.remove('unread');
                            row.classList.add('read');
                            const badge = row.querySelector('.unread-badge');
                            if (badge) {
                                badge.remove();
                            }
                        });
                        
                        // إخفاء الزر
                        markAllReadBtn.style.display = 'none';
                    }
                })
                .catch(error => console.error('خطأ:', error));
            });
        }
        
        // تعيين إشعار واحد كمقروء عند النقر عليه
        document.querySelectorAll('.notification-row').forEach(row => {
            row.addEventListener('click', function(e) {
                // تجاهل النقر على الروابط
                if (e.target.closest('.notification-link')) {
                    return;
                }
                
                const notificationId = this.getAttribute('data-id');
                
                // إرسال طلب AJAX لتعيين الإشعار كمقروء
                fetch('<?php echo $root_path; ?>api/mark_notification_read.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ id: notificationId })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // تحديث واجهة المستخدم
                        this.classList.remove('unread');
                        this.classList.add('read');
                        const badge = this.querySelector('.unread-badge');
                        if (badge) {
                            badge.remove();
                        }
                        
                        // التحقق مما إذا كانت هناك إشعارات غير مقروءة متبقية
                        const unreadNotifications = document.querySelectorAll('.notification-row.unread');
                        if (unreadNotifications.length === 0 && markAllReadBtn) {
                            markAllReadBtn.style.display = 'none';
                        }
                    }
                })
                .catch(error => console.error('خطأ:', error));
            });
        });
    });
</script>

<?php
// تضمين الفوتر
include 'includes/footer.php';
?>
