<?php
/**
 * نقطة الدخول الرئيسية للتطبيق
 *
 * هذا الملف يقوم بتوجيه المستخدم إلى الصفحة المناسبة بناءً على حالة تسجيل الدخول
 *
 * @version 1.0
 * @author فريق التطوير
 */

// تضمين ملف التكوين
require_once 'config/config.php';

// تضمين ملف دوال الأمان
require_once 'includes/security_functions.php';

// التحقق من حالة تسجيل الدخول
if (isLoggedIn()) {
    // إذا كان المستخدم مسجل الدخول، توجيهه إلى لوحة التحكم الموحدة
    header('Location: unified-dashboard.php');
    exit;
} else {
    // إذا لم يكن المستخدم مسجل الدخول، توجيهه إلى صفحة تسجيل الدخول
    header('Location: auth/login.php');
    exit;
}
