<?php
/**
 * القائمة الجانبية الموحدة
 * يتم استخدام هذا الملف في جميع صفحات النظام لعرض القائمة الجانبية بشكل موحد
 * تم التحديث: 2023
 */

// التأكد من بدء الجلسة
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// تحديد الصفحة الحالية
$current_page = basename($_SERVER['PHP_SELF']);

// تحديد المسار النسبي للصفحة الرئيسية
$root_path = '';
$current_dir = dirname($_SERVER['PHP_SELF']);

// تحديد المسار النسبي بناءً على المجلد الحالي
if (strpos($current_dir, '/orders') !== false ||
    strpos($current_dir, '/auth') !== false ||
    strpos($current_dir, '/admin') !== false ||
    strpos($current_dir, '/settings') !== false ||
    strpos($current_dir, '/reports') !== false ||
    strpos($current_dir, '/support') !== false ||
    strpos($current_dir, '/user') !== false) {
    $root_path = '../';
}

// تحديد ما إذا كانت الصفحة في مجلد الإدارة
$is_admin_page = (strpos($current_dir, '/admin') !== false);

// تحديد ما إذا كان في الصفحة الرئيسية
$is_index = ($current_page == 'index.php');

// الحصول على الصفحة الحالية من المعلمة GET إذا كانت موجودة
$current_tab = isset($_GET['page']) ? $_GET['page'] : '';

// تحديد ما إذا كانت علامة التبويب نشطة
function isTabActive($tab_name) {
    global $current_tab, $is_index, $current_page, $is_admin_page;

    // تعيين تخطيط الصفحات
    $page_mapping = [
        'dashboard' => ['index.php', 'dashboard.php'],
        'create-order' => ['create-order.php'],
        'orders' => ['orders.php'],
        'reports' => ['weekly_reports.php', 'monthly_reports.php'],
        'archive' => ['archive.php'],
        'settings' => ['settings.php', 'system_settings.php'],
        'users' => ['users.php', 'user-management.php'],
        'support' => ['support.php', 'index.php']
    ];

    if ($is_index) {
        // في الصفحة الرئيسية، تحقق من علامة التبويب
        if (empty($current_tab) && $tab_name == 'dashboard') {
            return 'active';
        }
        return ($current_tab == $tab_name) ? 'active' : '';
    } else {
        // في الصفحات الأخرى، تحقق من اسم الملف
        if (isset($page_mapping[$tab_name])) {
            if (in_array($current_page, $page_mapping[$tab_name])) {
                return 'active';
            }
        }

        // تحقق خاص بصفحات الإدارة
        if ($is_admin_page && $tab_name == 'admin') {
            return 'active';
        }

        return '';
    }
}
?>

<!-- القائمة الجانبية الموحدة -->
<aside class="sidebar sidebar-expanded fixed h-full z-30 text-white">
  <div class="h-full flex flex-col">
    <!-- شعار النظام -->
    <div class="flex items-center p-6 border-b border-indigo-400/20">
      <?php if ($is_admin_page): ?>
      <!-- شعار لوحة تحكم الإدارة -->
      <div class="w-10 h-10 rounded-full bg-gradient-to-br from-yellow-400 to-yellow-600 flex items-center justify-center shadow-lg ml-3">
        <i class="fas fa-cogs text-white text-xl"></i>
      </div>
      <h1 class="text-xl font-bold whitespace-nowrap">لوحة تحكم الإدارة</h1>
      <?php else: ?>
      <!-- شعار نظام طلبات الشحن -->
      <i class="fas fa-truck text-2xl text-yellow-300 ml-3"></i>
      <h1 class="text-xl font-bold whitespace-nowrap">نظام طلبات الشحن</h1>
      <?php endif; ?>
      <button id="toggleSidebar" class="text-indigo-200 hover:text-white mr-auto p-2 rounded-full hover:bg-indigo-700/30 transition-all">
        <i class="fas fa-chevron-right"></i>
      </button>
    </div>

    <!-- شعار الشركة -->
    <div class="logo-container flex items-center justify-center my-4 p-2">
      <img src="<?php echo $root_path; ?>assets/images/backgrounds/background.png" alt="شعار الشركة" class="h-40 w-auto object-contain logo-reveal">
    </div>

    <!-- قائمة التنقل -->
    <nav class="flex-1 overflow-y-auto p-4 space-y-2">
      <!-- لوحة التحكم - متاحة لجميع المستخدمين -->
      <?php if ($is_admin_page): ?>
      <!-- لوحة تحكم الإدارة -->
      <a href="<?php echo $root_path; ?>admin/dashboard.php" class="nav-item <?php echo isTabActive('dashboard'); ?> flex items-center px-4 py-3 group">
        <div class="w-8 h-8 rounded-lg bg-indigo-700/30 flex items-center justify-center ml-3 group-hover:bg-indigo-600/50 transition-all">
          <i class="fas fa-chart-pie text-lg"></i>
        </div>
        <span class="whitespace-nowrap">لوحة التحكم</span>
      </a>
      <?php else: ?>
        <?php if ($is_index): ?>
        <a href="#dashboard" data-page="dashboard" class="nav-item <?php echo isTabActive('dashboard'); ?> flex items-center px-4 py-3">
          <i class="fas fa-chart-pie ml-3 text-lg"></i>
          <span class="whitespace-nowrap">لوحة التحكم</span>
        </a>
        <?php else: ?>
        <a href="<?php echo $root_path; ?>index.php" class="nav-item <?php echo isTabActive('dashboard'); ?> flex items-center px-4 py-3">
          <i class="fas fa-chart-pie ml-3 text-lg"></i>
          <span class="whitespace-nowrap">لوحة التحكم</span>
        </a>
        <?php endif; ?>
      <?php endif; ?>

      <!-- إدارة الطلبات -->
      <?php if ($is_admin_page): ?>
      <!-- قائمة الطلبات للإدارة -->
      <div class="space-y-2">
        <button class="nav-item w-full flex items-center justify-between px-4 py-3 orders-toggle group">
          <div class="flex items-center">
            <div class="w-8 h-8 rounded-lg bg-indigo-700/30 flex items-center justify-center ml-3 group-hover:bg-indigo-600/50 transition-all">
              <i class="fas fa-boxes text-lg"></i>
            </div>
            <span class="whitespace-nowrap">إدارة الطلبات</span>
          </div>
          <i class="fas fa-chevron-down text-xs transition-transform"></i>
        </button>

        <div class="orders-dropdown-menu hidden space-y-1 pr-10">
          <a href="<?php echo $root_path; ?>orders/orders.php" class="nav-item <?php echo isTabActive('orders'); ?> flex items-center px-4 py-2 text-sm">
            <i class="fas fa-list ml-3"></i>
            <span class="whitespace-nowrap">قائمة الطلبات</span>
          </a>
          <a href="<?php echo $root_path; ?>orders/create-order.php" class="nav-item <?php echo isTabActive('create-order'); ?> flex items-center px-4 py-2 text-sm">
            <i class="fas fa-plus ml-3"></i>
            <span class="whitespace-nowrap">إنشاء طلب جديد</span>
          </a>
          <a href="<?php echo $root_path; ?>orders/archive.php" class="nav-item <?php echo isTabActive('archive'); ?> flex items-center px-4 py-2 text-sm">
            <i class="fas fa-archive ml-3"></i>
            <span class="whitespace-nowrap">أرشيف الطلبات</span>
          </a>
        </div>
      </div>
      <?php else: ?>
      <!-- إنشاء طلب - متاح لجميع المستخدمين -->
      <a href="<?php echo $root_path; ?>orders/create-order.php" class="nav-item <?php echo isTabActive('create-order'); ?> flex items-center px-4 py-3">
        <i class="fas fa-plus-circle ml-3 text-lg"></i>
        <span class="whitespace-nowrap">إنشاء طلب</span>
      </a>

      <!-- إدارة الطلبات - متاح لجميع المستخدمين (المستخدم العادي يرى طلباته فقط) -->
      <?php if ($is_index): ?>
      <a href="#orders" data-page="orders" class="nav-item <?php echo isTabActive('orders'); ?> flex items-center px-4 py-3">
        <i class="fas fa-boxes ml-3 text-lg"></i>
        <span class="whitespace-nowrap">إدارة الطلبات</span>
      </a>
      <?php else: ?>
      <a href="<?php echo $root_path; ?>orders/orders.php" class="nav-item <?php echo isTabActive('orders'); ?> flex items-center px-4 py-3">
        <i class="fas fa-boxes ml-3 text-lg"></i>
        <span class="whitespace-nowrap">إدارة الطلبات</span>
      </a>
      <?php endif; ?>
      <?php endif; ?>

      <!-- قائمة التقارير المنسدلة -->
      <?php if ($is_admin_page): ?>
      <!-- قائمة التقارير للإدارة -->
      <div class="space-y-2">
        <button class="nav-item w-full flex items-center justify-between px-4 py-3 reports-toggle group">
          <div class="flex items-center">
            <div class="w-8 h-8 rounded-lg bg-indigo-700/30 flex items-center justify-center ml-3 group-hover:bg-indigo-600/50 transition-all">
              <i class="fas fa-chart-bar text-lg"></i>
            </div>
            <span class="whitespace-nowrap">التقارير</span>
          </div>
          <i class="fas fa-chevron-down text-xs transition-transform duration-300"></i>
        </button>

        <div class="reports-dropdown-menu hidden space-y-1 pr-10">
          <!-- تقارير الإدارة -->
          <div class="dropdown-section mb-2">
            <div class="text-xs text-indigo-300 mb-1 pr-2">تقارير الإدارة</div>
            <a href="<?php echo $root_path; ?>reports/weekly_reports.php?type=admin" class="nav-item flex items-center px-3 py-2 text-sm">
              <i class="fas fa-calendar-week ml-2 text-sm"></i>
              <span class="whitespace-nowrap">التقارير الأسبوعية</span>
            </a>
            <a href="<?php echo $root_path; ?>reports/monthly_reports.php?type=admin" class="nav-item flex items-center px-3 py-2 text-sm">
              <i class="fas fa-calendar-alt ml-2 text-sm"></i>
              <span class="whitespace-nowrap">التقارير الشهرية</span>
            </a>
          </div>

          <!-- تقارير المستخدمين -->
          <div class="dropdown-section pt-2 border-t border-indigo-700">
            <div class="text-xs text-indigo-300 mb-1 pr-2">تقارير المستخدمين</div>
            <a href="<?php echo $root_path; ?>reports/weekly_reports.php?type=user" class="nav-item flex items-center px-3 py-2 text-sm">
              <i class="fas fa-calendar-week ml-2 text-sm"></i>
              <span class="whitespace-nowrap">التقارير الأسبوعية</span>
            </a>
            <a href="<?php echo $root_path; ?>reports/monthly_reports.php?type=user" class="nav-item flex items-center px-3 py-2 text-sm">
              <i class="fas fa-calendar-alt ml-2 text-sm"></i>
              <span class="whitespace-nowrap">التقارير الشهرية</span>
            </a>
          </div>
        </div>
      </div>
      <?php else: ?>
      <!-- قائمة التقارير للمستخدم العادي -->
      <div class="reports-dropdown relative">
        <div class="nav-item reports-toggle <?php echo isTabActive('reports'); ?> flex items-center justify-between px-4 py-3 cursor-pointer hover:bg-indigo-700/30">
          <div class="flex items-center">
            <i class="fas fa-chart-bar ml-3 text-lg"></i>
            <span class="whitespace-nowrap">التقارير</span>
          </div>
          <i class="fas fa-chevron-down text-xs transition-transform duration-300"></i>
        </div>

        <!-- عناصر القائمة المنسدلة -->
        <div class="reports-dropdown-menu hidden mr-8 mt-1 space-y-1 rounded-md bg-indigo-800 p-2">
          <!-- تقارير المستخدم - متاحة لجميع المستخدمين -->
          <div class="dropdown-section mb-2">
            <div class="text-xs text-indigo-300 mb-1 pr-2">تقارير المستخدم</div>
            <a href="<?php echo $root_path; ?>reports/weekly_reports.php?type=user" class="nav-item flex items-center px-3 py-2 text-sm">
              <i class="fas fa-calendar-week ml-2 text-sm"></i>
              <span class="whitespace-nowrap">التقارير الأسبوعية</span>
            </a>
            <a href="<?php echo $root_path; ?>reports/monthly_reports.php?type=user" class="nav-item flex items-center px-3 py-2 text-sm">
              <i class="fas fa-calendar-alt ml-2 text-sm"></i>
              <span class="whitespace-nowrap">التقارير الشهرية</span>
            </a>
          </div>

          <!-- تقارير الإدارة (للمديرين والمشرفين فقط) -->
          <?php if (isset($_SESSION['role']) && ($_SESSION['role'] === 'admin' || $_SESSION['role'] === 'manager')): ?>
          <div class="dropdown-section pt-2 border-t border-indigo-700">
            <div class="text-xs text-indigo-300 mb-1 pr-2">تقارير الإدارة</div>
            <a href="<?php echo $root_path; ?>reports/weekly_reports.php?type=admin" class="nav-item flex items-center px-3 py-2 text-sm">
              <i class="fas fa-calendar-week ml-2 text-sm"></i>
              <span class="whitespace-nowrap">التقارير الأسبوعية</span>
            </a>
            <a href="<?php echo $root_path; ?>reports/monthly_reports.php?type=admin" class="nav-item flex items-center px-3 py-2 text-sm">
              <i class="fas fa-calendar-alt ml-2 text-sm"></i>
              <span class="whitespace-nowrap">التقارير الشهرية</span>
            </a>
          </div>
          <?php endif; ?>
        </div>
      </div>
      <?php endif; ?>

      <!-- الأرشيف - متاح للمديرين فقط -->
      <?php if ($is_admin_page): ?>
      <!-- الأرشيف في لوحة تحكم الإدارة -->
      <a href="<?php echo $root_path; ?>orders/archive.php" class="nav-item <?php echo isTabActive('archive'); ?> flex items-center px-4 py-3 group">
        <div class="w-8 h-8 rounded-lg bg-indigo-700/30 flex items-center justify-center ml-3 group-hover:bg-indigo-600/50 transition-all">
          <i class="fas fa-archive text-lg"></i>
        </div>
        <span class="whitespace-nowrap">الأرشيف</span>
      </a>
      <?php else: ?>
        <?php if (isset($_SESSION['role']) && ($_SESSION['role'] === 'admin' || $_SESSION['role'] === 'manager')): ?>
          <?php if ($is_index): ?>
          <a href="#archive" data-page="archive" class="nav-item <?php echo isTabActive('archive'); ?> flex items-center px-4 py-3">
            <i class="fas fa-archive ml-3 text-lg"></i>
            <span class="whitespace-nowrap">الأرشيف</span>
          </a>
          <?php else: ?>
          <a href="<?php echo $root_path; ?>orders/archive.php" class="nav-item <?php echo isTabActive('archive'); ?> flex items-center px-4 py-3">
            <i class="fas fa-archive ml-3 text-lg"></i>
            <span class="whitespace-nowrap">الأرشيف</span>
          </a>
          <?php endif; ?>
        <?php endif; ?>
      <?php endif; ?>

      <!-- إعدادات النظام للمديرين / إعدادات الحساب للمستخدمين العاديين -->
      <?php if ($is_admin_page): ?>
      <!-- إعدادات النظام في لوحة تحكم الإدارة -->
      <div class="space-y-2">
        <button class="nav-item w-full flex items-center justify-between px-4 py-3 settings-toggle group">
          <div class="flex items-center">
            <div class="w-8 h-8 rounded-lg bg-indigo-700/30 flex items-center justify-center ml-3 group-hover:bg-indigo-600/50 transition-all">
              <i class="fas fa-cog text-lg"></i>
            </div>
            <span class="whitespace-nowrap">إعدادات النظام</span>
          </div>
          <i class="fas fa-chevron-down text-xs transition-transform duration-300"></i>
        </button>

        <div class="settings-dropdown-menu hidden space-y-1 pr-10">
          <a href="<?php echo $root_path; ?>settings/general.php" class="nav-item flex items-center px-3 py-2 text-sm">
            <i class="fas fa-sliders-h ml-2 text-sm"></i>
            <span class="whitespace-nowrap">الإعدادات العامة</span>
          </a>
          <a href="<?php echo $root_path; ?>settings/branches.php" class="nav-item flex items-center px-3 py-2 text-sm">
            <i class="fas fa-code-branch ml-2 text-sm"></i>
            <span class="whitespace-nowrap">إدارة الفروع</span>
          </a>
          <a href="<?php echo $root_path; ?>settings/shipping.php" class="nav-item flex items-center px-3 py-2 text-sm">
            <i class="fas fa-truck ml-2 text-sm"></i>
            <span class="whitespace-nowrap">إعدادات الشحن</span>
          </a>
        </div>
      </div>

      <!-- إدارة المستخدمين في لوحة تحكم الإدارة -->
      <a href="<?php echo $root_path; ?>admin/users.php" class="nav-item <?php echo isTabActive('users'); ?> flex items-center px-4 py-3 group">
        <div class="w-8 h-8 rounded-lg bg-indigo-700/30 flex items-center justify-center ml-3 group-hover:bg-indigo-600/50 transition-all">
          <i class="fas fa-users text-lg"></i>
        </div>
        <span class="whitespace-nowrap">إدارة المستخدمين</span>
      </a>
      <?php else: ?>
        <?php if (isset($_SESSION['role']) && ($_SESSION['role'] === 'admin' || $_SESSION['role'] === 'manager')): ?>
          <?php if ($is_index): ?>
          <a href="#settings" data-page="settings" class="nav-item <?php echo isTabActive('settings'); ?> flex items-center px-4 py-3">
            <i class="fas fa-cog ml-3 text-lg"></i>
            <span class="whitespace-nowrap">إعدادات النظام</span>
          </a>
          <?php else: ?>
          <a href="<?php echo $root_path; ?>settings/settings.php" class="nav-item <?php echo isTabActive('settings'); ?> flex items-center px-4 py-3">
            <i class="fas fa-cog ml-3 text-lg"></i>
            <span class="whitespace-nowrap">إعدادات النظام</span>
          </a>
          <?php endif; ?>
        <?php else: ?>
          <?php if ($is_index): ?>
          <a href="#account" data-page="account" class="nav-item <?php echo isTabActive('account'); ?> flex items-center px-4 py-3">
            <i class="fas fa-user-cog ml-3 text-lg"></i>
            <span class="whitespace-nowrap">إعدادات الحساب</span>
          </a>
          <?php else: ?>
          <a href="<?php echo $root_path; ?>user/account.php" class="nav-item <?php echo isTabActive('account'); ?> flex items-center px-4 py-3">
            <i class="fas fa-user-cog ml-3 text-lg"></i>
            <span class="whitespace-nowrap">إعدادات الحساب</span>
          </a>
          <?php endif; ?>
        <?php endif; ?>
      <?php endif; ?>

      <!-- لوحة تحكم الإدارة - متاحة للمدير والمشرف فقط (تظهر فقط في واجهة المستخدم) -->
      <?php if (!$is_admin_page && isset($_SESSION['role']) && ($_SESSION['role'] === 'admin' || $_SESSION['role'] === 'manager')): ?>
      <a href="<?php echo $root_path; ?>admin/dashboard.php" class="nav-item flex items-center px-4 py-3">
        <i class="fas fa-cogs ml-3 text-lg"></i>
        <span class="whitespace-nowrap">لوحة تحكم الإدارة</span>
      </a>
      <?php endif; ?>

      <!-- الدعم - متاح لجميع المستخدمين -->
      <?php if ($is_admin_page): ?>
      <!-- الدعم في لوحة تحكم الإدارة -->
      <a href="<?php echo $root_path; ?>support/admin.php" class="nav-item <?php echo isTabActive('support'); ?> flex items-center px-4 py-3 group">
        <div class="w-8 h-8 rounded-lg bg-indigo-700/30 flex items-center justify-center ml-3 group-hover:bg-indigo-600/50 transition-all">
          <i class="fas fa-headset text-lg"></i>
        </div>
        <span class="whitespace-nowrap">الدعم الفني</span>
      </a>
      <?php else: ?>
        <?php if ($is_index): ?>
        <a href="#support" data-page="support" class="nav-item <?php echo isTabActive('support'); ?> flex items-center px-4 py-3">
          <i class="fas fa-headset ml-3 text-lg"></i>
          <span class="whitespace-nowrap">الدعم</span>
        </a>
        <?php else: ?>
        <a href="<?php echo $root_path; ?>support/index.php" class="nav-item <?php echo isTabActive('support'); ?> flex items-center px-4 py-3">
          <i class="fas fa-headset ml-3 text-lg"></i>
          <span class="whitespace-nowrap">الدعم</span>
        </a>
        <?php endif; ?>
      <?php endif; ?>
    </nav>

    <!-- معلومات المستخدم -->
    <div class="p-4 border-t border-indigo-400/20">
      <div class="flex items-center">
        <?php if ($is_admin_page): ?>
        <!-- معلومات المستخدم في لوحة تحكم الإدارة -->
        <div class="w-10 h-10 rounded-full bg-gradient-to-br from-yellow-400 to-yellow-600 flex items-center justify-center shadow-lg ml-3">
          <i class="fas fa-user-shield text-white"></i>
        </div>
        <?php else: ?>
        <!-- معلومات المستخدم في واجهة المستخدم -->
        <div class="w-10 h-10 rounded-full bg-indigo-200 flex items-center justify-center text-indigo-700 ml-3">
          <i class="fas fa-user"></i>
        </div>
        <?php endif; ?>
        <div>
          <h3 class="text-sm font-medium user-name"><?php echo isset($currentUser['full_name']) ? htmlspecialchars($currentUser['full_name']) : 'مستخدم النظام'; ?></h3>
          <p class="text-xs text-indigo-200 user-role"><?php echo isset($currentUser['role']) ? htmlspecialchars($currentUser['role']) : 'مستخدم'; ?></p>
        </div>
        <a href="<?php echo $root_path; ?>auth/logout.php" class="mr-auto text-indigo-200 hover:text-white logout-button p-2 rounded-full hover:bg-red-500/20 transition-all" title="تسجيل الخروج">
          <i class="fas fa-sign-out-alt"></i>
        </a>
      </div>
    </div>
  </div>
</aside>

<!-- طبقة التعتيم للجوال -->
<div id="overlay" class="overlay"></div>

<!-- تضمين ملف CSS للقائمة الجانبية -->
<link rel="stylesheet" href="<?php echo $root_path; ?>css/sidebar.css">

<!-- سكريبت القائمة الجانبية -->
<script>
  // تهيئة القائمة الجانبية
  document.addEventListener('DOMContentLoaded', function() {
    // تحديد العناصر
    const toggleSidebar = document.getElementById('toggleSidebar');
    const sidebar = document.querySelector('.sidebar');
    const mainContent = document.querySelector('.main-content');
    const body = document.body;

    // إضافة فئة للصفحات المختلفة
    if (window.location.href.includes('/reports/')) {
      body.classList.add('reports-page');
    }

    // تهيئة القائمة المنسدلة للتقارير
    const reportsToggle = document.querySelector('.reports-toggle');
    const reportsDropdownMenu = document.querySelector('.reports-dropdown-menu');
    const reportsChevron = reportsToggle ? reportsToggle.querySelector('.fa-chevron-down') : null;

    // تهيئة القائمة المنسدلة للإعدادات
    const settingsToggle = document.querySelector('.settings-toggle');
    const settingsDropdownMenu = document.querySelector('.settings-dropdown-menu');
    const settingsChevron = settingsToggle ? settingsToggle.querySelector('.fa-chevron-down') : null;

    // تهيئة القائمة المنسدلة للطلبات
    const ordersToggle = document.querySelector('.orders-toggle');
    const ordersDropdownMenu = document.querySelector('.orders-dropdown-menu');
    const ordersChevron = ordersToggle ? ordersToggle.querySelector('.fa-chevron-down') : null;

    // تحديد ما إذا كانت الصفحة الحالية هي صفحة تقارير أو صفحة إدارة
    const isReportsPage = window.location.href.includes('/reports/');
    const isAdminPage = window.location.href.includes('/admin/');

    // فتح القائمة المنسدلة للتقارير تلقائياً في صفحات التقارير
    if (isReportsPage && reportsDropdownMenu) {
      reportsDropdownMenu.classList.remove('hidden');
      if (reportsChevron) {
        reportsChevron.classList.add('rotate-180');
      }
    }

    // فتح القائمة المنسدلة للإعدادات تلقائياً في صفحات الإعدادات
    const isSettingsPage = window.location.href.includes('/settings/');
    if (isSettingsPage && settingsDropdownMenu) {
      settingsDropdownMenu.classList.remove('hidden');
      if (settingsChevron) {
        settingsChevron.classList.add('rotate-180');
      }
    }

    // فتح القائمة المنسدلة للطلبات تلقائياً في صفحات الطلبات
    const isOrdersPage = window.location.href.includes('/orders/');
    if (isOrdersPage && ordersDropdownMenu) {
      ordersDropdownMenu.classList.remove('hidden');
      if (ordersChevron) {
        ordersChevron.classList.add('rotate-180');
      }
    }

      // تحديد الرابط النشط في قائمة التقارير
      if (window.location.href.includes('weekly_reports.php')) {
        const reportType = new URLSearchParams(window.location.search).get('type') || 'user';
        const activeLink = document.querySelector(`a[href*="weekly_reports.php?type=${reportType}"]`);
        if (activeLink) {
          activeLink.classList.add('active');
          activeLink.classList.add('bg-indigo-700');
        }
      } else if (window.location.href.includes('monthly_reports.php')) {
        const reportType = new URLSearchParams(window.location.search).get('type') || 'user';
        const activeLink = document.querySelector(`a[href*="monthly_reports.php?type=${reportType}"]`);
        if (activeLink) {
          activeLink.classList.add('active');
          activeLink.classList.add('bg-indigo-700');
        }
      }
    }

    // تبديل عرض قائمة التقارير المنسدلة
    if (reportsToggle && reportsDropdownMenu) {
      reportsToggle.addEventListener('click', function(e) {
        e.preventDefault();

        // تبديل عرض القائمة المنسدلة
        reportsDropdownMenu.classList.toggle('hidden');

        // تدوير أيقونة السهم
        if (reportsChevron) {
          reportsChevron.classList.toggle('rotate-180');
        }
      });

      // إغلاق القائمة المنسدلة عند النقر خارجها
      document.addEventListener('click', function(e) {
        if (!e.target.closest('.reports-dropdown') && !reportsDropdownMenu.classList.contains('hidden')) {
          reportsDropdownMenu.classList.add('hidden');
          if (reportsChevron) {
            reportsChevron.classList.remove('rotate-180');
          }
        }
      });
    }

    // تبديل عرض قائمة الإعدادات المنسدلة
    if (settingsToggle && settingsDropdownMenu) {
      settingsToggle.addEventListener('click', function(e) {
        e.preventDefault();

        // تبديل عرض القائمة المنسدلة
        settingsDropdownMenu.classList.toggle('hidden');

        // تدوير أيقونة السهم
        if (settingsChevron) {
          settingsChevron.classList.toggle('rotate-180');
        }
      });

      // إغلاق القائمة المنسدلة عند النقر خارجها
      document.addEventListener('click', function(e) {
        if (!e.target.closest('.settings-toggle') && !settingsDropdownMenu.classList.contains('hidden')) {
          settingsDropdownMenu.classList.add('hidden');
          if (settingsChevron) {
            settingsChevron.classList.remove('rotate-180');
          }
        }
      });
    }

    // تبديل عرض قائمة الطلبات المنسدلة
    if (ordersToggle && ordersDropdownMenu) {
      ordersToggle.addEventListener('click', function(e) {
        e.preventDefault();

        // تبديل عرض القائمة المنسدلة
        ordersDropdownMenu.classList.toggle('hidden');

        // تدوير أيقونة السهم
        if (ordersChevron) {
          ordersChevron.classList.toggle('rotate-180');
        }
      });

      // إغلاق القائمة المنسدلة عند النقر خارجها
      document.addEventListener('click', function(e) {
        if (!e.target.closest('.orders-toggle') && !ordersDropdownMenu.classList.contains('hidden')) {
          ordersDropdownMenu.classList.add('hidden');
          if (ordersChevron) {
            ordersChevron.classList.remove('rotate-180');
          }
        }
      });
    }

    // تبديل القائمة الجانبية
    if (toggleSidebar) {
      toggleSidebar.addEventListener('click', function() {
        sidebar.classList.toggle('sidebar-collapsed');
        sidebar.classList.toggle('sidebar-expanded');

        if (mainContent) {
          if (sidebar.classList.contains('sidebar-collapsed')) {
            mainContent.style.width = 'calc(100% - 80px)';
            mainContent.style.marginRight = '80px';
          } else {
            mainContent.style.width = 'calc(100% - 280px)';
            mainContent.style.marginRight = '280px';
          }
        }
      });
    }

    // فتح/إغلاق القائمة على الجوال
    const mobileMenuButton = document.getElementById('mobileMenuButton');
    const overlay = document.getElementById('overlay');

    // إنشاء زر القائمة للجوال إذا لم يكن موجوداً
    if (!mobileMenuButton) {
      const mobileBtn = document.createElement('button');
      mobileBtn.id = 'mobileMenuButton';
      mobileBtn.innerHTML = '<i class="fas fa-bars"></i>';
      mobileBtn.className = 'fixed top-4 right-4 z-50 bg-indigo-600 text-white p-2 rounded-lg shadow-lg md:hidden';
      document.body.appendChild(mobileBtn);

      mobileBtn.addEventListener('click', function() {
        sidebar.classList.add('sidebar-open');
        if (overlay) overlay.classList.add('overlay-open');
      });
    } else {
      mobileMenuButton.addEventListener('click', function() {
        sidebar.classList.add('sidebar-open');
        if (overlay) overlay.classList.add('overlay-open');
      });
    }

    if (overlay) {
      overlay.addEventListener('click', function() {
        sidebar.classList.remove('sidebar-open');
        overlay.classList.remove('overlay-open');
      });
    }

    // إضافة تأثير النقر على الروابط
    const navItems = document.querySelectorAll('.nav-item');
    navItems.forEach(item => {
      item.addEventListener('click', function() {
        // إضافة تأثير النقر
        const ripple = document.createElement('span');
        ripple.classList.add('nav-ripple');
        this.appendChild(ripple);

        setTimeout(() => {
          ripple.remove();
        }, 600);
      });
    });
  });
</script>

<style>
  /* تأثير النقر على الروابط */
  .nav-item {
    position: relative;
    overflow: hidden;
  }

  .nav-ripple {
    position: absolute;
    top: 50%;
    left: 50%;
    width: 5px;
    height: 5px;
    background: rgba(255, 255, 255, 0.4);
    border-radius: 100%;
    transform: scale(1);
    animation: ripple 0.6s linear;
    z-index: 1;
  }

  @keyframes ripple {
    0% {
      transform: scale(0);
      opacity: 0.5;
    }
    100% {
      transform: scale(40);
      opacity: 0;
    }
  }
</style>
