<?php
/**
 * الشريط العلوي الموحد
 * يتم استخدام هذا الملف في جميع صفحات النظام لعرض الشريط العلوي بشكل موحد
 * تم التحديث: 2023
 */

// التأكد من بدء الجلسة
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// تحديد المسار النسبي للصفحة الرئيسية
$root_path = '';
$current_dir = dirname($_SERVER['PHP_SELF']);

// تحديد المسار النسبي بناءً على المجلد الحالي
if (strpos($current_dir, '/orders') !== false ||
    strpos($current_dir, '/auth') !== false ||
    strpos($current_dir, '/admin') !== false ||
    strpos($current_dir, '/settings') !== false ||
    strpos($current_dir, '/reports') !== false ||
    strpos($current_dir, '/support') !== false ||
    strpos($current_dir, '/user') !== false) {
    $root_path = '../';
}

// الحصول على معلومات المستخدم الحالي
$currentUser = isset($currentUser) ? $currentUser : null;
if (!$currentUser && isset($_SESSION['user_id'])) {
    // إذا لم يتم تعيين معلومات المستخدم بالفعل، قم بجلبها من قاعدة البيانات
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $currentUser = $stmt->fetch();
}

// تحديد ما إذا كان المستخدم مديرًا
$isAdmin = isset($currentUser['role']) && $currentUser['role'] === 'admin';
?>

<!-- الشريط العلوي -->
<header class="top-bar bg-white shadow-sm px-6 py-3 flex items-center justify-between sticky top-0 z-20">
  <div class="flex items-center">
    <!-- زر تبديل القائمة الجانبية للأجهزة المحمولة -->
    <button id="toggleSidebar" class="md:hidden text-gray-600 hover:text-primary p-2 rounded-lg">
      <i class="fas fa-bars text-xl"></i>
    </button>

    <!-- شعار النظام في الشريط العلوي (يظهر فقط في الأجهزة المحمولة) -->
    <div class="flex items-center md:hidden ml-3">
      <img src="<?php echo $root_path; ?>assets/images/backgrounds/background.png" alt="شعار النظام" class="h-16 w-auto object-contain logo-reveal">
    </div>

    <!-- مربع البحث -->
    <div class="relative ml-4 hidden md:block">
      <input type="text" placeholder="البحث..." class="bg-gray-100 rounded-full py-2 px-4 pl-10 w-64 focus:outline-none focus:ring-2 focus:ring-primary/30 focus:bg-white transition-all">
      <i class="fas fa-search absolute right-3 top-3 text-gray-400"></i>
    </div>
  </div>

  <!-- معلومات المستخدم والإشعارات -->
  <div class="flex items-center space-x-4 space-x-reverse">
    <!-- إشعارات النظام -->
    <div class="relative">
      <?php
      // تضمين مدير الإشعارات
      require_once __DIR__ . '/notifications_manager.php';

      // الحصول على معرف المستخدم الحالي
      $currentUserId = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;

      // حساب عدد الإشعارات غير المقروءة
      $unreadCount = countUnreadNotifications($currentUserId);

      // الحصول على آخر 5 إشعارات
      $notifications = getUserNotifications($currentUserId, 5);
      ?>
      <div class="notifications-dropdown">
        <button class="relative p-2 rounded-full hover:bg-gray-100 transition-all" id="notificationsButton">
          <i class="fas fa-bell text-gray-600"></i>
          <?php if ($unreadCount > 0): ?>
          <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center animate-pulse"><?php echo $unreadCount; ?></span>
          <?php endif; ?>
        </button>

        <!-- قائمة الإشعارات -->
        <div class="notifications-menu hidden">
          <div class="notifications-header">
            <h3>الإشعارات</h3>
            <?php if ($unreadCount > 0): ?>
            <button class="mark-all-read">تعيين الكل كمقروء</button>
            <?php endif; ?>
          </div>

          <div class="notifications-list">
            <?php if (empty($notifications)): ?>
            <div class="empty-notifications">
              <p>لا توجد إشعارات جديدة</p>
            </div>
            <?php else: ?>
              <?php foreach ($notifications as $notification): ?>
              <div class="notification-item <?php echo $notification['is_read'] ? 'read' : 'unread'; ?>" data-id="<?php echo $notification['id']; ?>">
                <div class="notification-icon <?php echo $notification['type']; ?>">
                  <i class="fas <?php
                    echo $notification['type'] === 'success' ? 'fa-check-circle' :
                         ($notification['type'] === 'warning' ? 'fa-exclamation-triangle' :
                         ($notification['type'] === 'error' ? 'fa-times-circle' : 'fa-info-circle'));
                  ?>"></i>
                </div>
                <div class="notification-content">
                  <h4><?php echo htmlspecialchars($notification['title']); ?></h4>
                  <p><?php echo htmlspecialchars($notification['message']); ?></p>
                  <span class="notification-time"><?php echo date('d/m/Y H:i', strtotime($notification['created_at'])); ?></span>
                </div>
              </div>
              <?php endforeach; ?>
            <?php endif; ?>
          </div>

          <div class="notifications-footer">
            <a href="<?php echo $root_path; ?>notifications.php">عرض كل الإشعارات</a>
          </div>
        </div>
      </div>
    </div>

    <div class="border-r border-gray-300 h-8 mx-2"></div>

    <!-- معلومات المستخدم -->
    <div class="user-profile">
      <div class="user-avatar">
        <?php echo isset($currentUser['full_name']) ? mb_substr($currentUser['full_name'], 0, 1, 'UTF-8') : 'U'; ?>
      </div>
      <div>
        <p class="font-medium text-sm"><?php echo isset($currentUser['full_name']) ? htmlspecialchars($currentUser['full_name']) : 'مستخدم النظام'; ?></p>
        <p class="text-xs text-gray-500"><?php echo isset($currentUser['role']) ? ($currentUser['role'] === 'admin' ? 'مدير النظام' : 'مستخدم') : 'مستخدم'; ?></p>
      </div>
    </div>
  </div>
</header>

<!-- عرض رسائل النجاح -->
<?php if (isset($_SESSION['success_message'])): ?>
<div id="successAlert" class="bg-green-100 border-r-4 border-green-500 text-green-700 p-4 mb-6 rounded-lg mx-6 mt-6 animate-fadeIn">
  <div class="flex items-center">
    <div class="text-lg ml-3">
      <i class="fas fa-check-circle"></i>
    </div>
    <div>
      <p class="font-bold">تم بنجاح!</p>
      <p><?php echo $_SESSION['success_message']; ?></p>
    </div>
  </div>
</div>
<script>
  // إخفاء رسالة النجاح بعد 5 ثوانٍ
  setTimeout(function() {
    const successAlert = document.getElementById('successAlert');
    if (successAlert) {
      successAlert.classList.add('opacity-0');
      setTimeout(function() {
        successAlert.style.display = 'none';
      }, 500);
    }
  }, 5000);
</script>
<?php unset($_SESSION['success_message']); ?>
<?php endif; ?>

<!-- عرض رسائل الخطأ -->
<?php if (isset($_SESSION['error_message'])): ?>
<div id="errorAlert" class="bg-red-100 border-r-4 border-red-500 text-red-700 p-4 mb-6 rounded-lg mx-6 mt-6 animate-fadeIn">
  <div class="flex items-center">
    <div class="text-lg ml-3">
      <i class="fas fa-exclamation-circle"></i>
    </div>
    <div>
      <p class="font-bold">خطأ!</p>
      <p><?php echo $_SESSION['error_message']; ?></p>
    </div>
  </div>
</div>
<script>
  // إخفاء رسالة الخطأ بعد 5 ثوانٍ
  setTimeout(function() {
    const errorAlert = document.getElementById('errorAlert');
    if (errorAlert) {
      errorAlert.classList.add('opacity-0');
      setTimeout(function() {
        errorAlert.style.display = 'none';
      }, 500);
    }
  }, 5000);
</script>
<?php unset($_SESSION['error_message']); ?>
<?php endif; ?>

<style>
  /* تأثير التلاشي للتنبيهات */
  .animate-fadeIn {
    animation: fadeIn 0.5s ease-in-out;
  }

  @keyframes fadeIn {
    from {
      opacity: 0;
      transform: translateY(-10px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }

  #successAlert, #errorAlert {
    transition: opacity 0.5s ease;
  }

  /* أنماط قائمة الإشعارات */
  .notifications-dropdown {
    position: relative;
  }

  .notifications-menu {
    position: absolute;
    top: 100%;
    left: 0;
    width: 320px;
    background: white;
    border-radius: 8px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.15);
    z-index: 100;
    margin-top: 10px;
    overflow: hidden;
    transform-origin: top right;
    transition: all 0.3s ease;
  }

  .notifications-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 16px;
    border-bottom: 1px solid #eee;
  }

  .notifications-header h3 {
    font-size: 16px;
    font-weight: 600;
    color: #333;
    margin: 0;
  }

  .mark-all-read {
    font-size: 12px;
    color: #4c0c70;
    background: none;
    border: none;
    cursor: pointer;
    padding: 0;
  }

  .mark-all-read:hover {
    text-decoration: underline;
  }

  .notifications-list {
    max-height: 320px;
    overflow-y: auto;
  }

  .notification-item {
    display: flex;
    padding: 12px 16px;
    border-bottom: 1px solid #f0f0f0;
    transition: background-color 0.2s ease;
  }

  .notification-item:hover {
    background-color: #f9f9f9;
  }

  .notification-item.unread {
    background-color: #f0f7ff;
  }

  .notification-icon {
    margin-left: 12px;
    width: 36px;
    height: 36px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
  }

  .notification-icon.info {
    background-color: #e6f7ff;
    color: #1890ff;
  }

  .notification-icon.success {
    background-color: #f6ffed;
    color: #52c41a;
  }

  .notification-icon.warning {
    background-color: #fffbe6;
    color: #faad14;
  }

  .notification-icon.error {
    background-color: #fff2f0;
    color: #ff4d4f;
  }

  .notification-content {
    flex: 1;
  }

  .notification-content h4 {
    font-size: 14px;
    font-weight: 600;
    margin: 0 0 4px 0;
    color: #333;
  }

  .notification-content p {
    font-size: 13px;
    color: #666;
    margin: 0 0 4px 0;
  }

  .notification-time {
    font-size: 11px;
    color: #999;
  }

  .empty-notifications {
    padding: 24px 16px;
    text-align: center;
    color: #999;
  }

  .notifications-footer {
    padding: 12px 16px;
    text-align: center;
    border-top: 1px solid #eee;
  }

  .notifications-footer a {
    color: #4c0c70;
    font-size: 13px;
    text-decoration: none;
  }

  .notifications-footer a:hover {
    text-decoration: underline;
  }
</style>

<script>
  // تنفيذ الكود عند اكتمال تحميل الصفحة
  document.addEventListener('DOMContentLoaded', function() {
    // الحصول على عناصر الإشعارات
    const notificationsButton = document.getElementById('notificationsButton');
    const notificationsMenu = document.querySelector('.notifications-menu');
    const markAllReadButton = document.querySelector('.mark-all-read');
    const notificationItems = document.querySelectorAll('.notification-item');

    // إظهار/إخفاء قائمة الإشعارات عند النقر على الزر
    if (notificationsButton) {
      notificationsButton.addEventListener('click', function(e) {
        e.stopPropagation();
        notificationsMenu.classList.toggle('hidden');
      });
    }

    // إخفاء قائمة الإشعارات عند النقر خارجها
    document.addEventListener('click', function(e) {
      if (notificationsMenu && !notificationsMenu.contains(e.target) && e.target !== notificationsButton) {
        notificationsMenu.classList.add('hidden');
      }
    });

    // تعيين جميع الإشعارات كمقروءة
    if (markAllReadButton) {
      markAllReadButton.addEventListener('click', function() {
        // إرسال طلب AJAX لتعيين جميع الإشعارات كمقروءة
        fetch('<?php echo $root_path; ?>api/mark_all_notifications_read.php', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          }
        })
        .then(response => response.json())
        .then(data => {
          if (data.success) {
            // تحديث واجهة المستخدم
            document.querySelectorAll('.notification-item').forEach(item => {
              item.classList.remove('unread');
              item.classList.add('read');
            });

            // إخفاء عداد الإشعارات
            const notificationCounter = document.querySelector('#notificationsButton .animate-pulse');
            if (notificationCounter) {
              notificationCounter.style.display = 'none';
            }

            // إخفاء زر تعيين الكل كمقروء
            markAllReadButton.style.display = 'none';
          }
        })
        .catch(error => console.error('خطأ:', error));
      });
    }

    // تعيين إشعار واحد كمقروء عند النقر عليه
    notificationItems.forEach(item => {
      item.addEventListener('click', function() {
        const notificationId = this.getAttribute('data-id');

        // إرسال طلب AJAX لتعيين الإشعار كمقروء
        fetch('<?php echo $root_path; ?>api/mark_notification_read.php', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({ id: notificationId })
        })
        .then(response => response.json())
        .then(data => {
          if (data.success) {
            // تحديث واجهة المستخدم
            this.classList.remove('unread');
            this.classList.add('read');

            // تحديث عداد الإشعارات
            const notificationCounter = document.querySelector('#notificationsButton .animate-pulse');
            if (notificationCounter) {
              const currentCount = parseInt(notificationCounter.textContent);
              if (currentCount > 1) {
                notificationCounter.textContent = currentCount - 1;
              } else {
                notificationCounter.style.display = 'none';
              }
            }
          }
        })
        .catch(error => console.error('خطأ:', error));

        // إذا كان هناك رابط، انتقل إليه
        const link = this.getAttribute('data-link');
        if (link) {
          window.location.href = link;
        }
      });
    });
  });
</script>
