# مجلد المكونات القابلة لإعادة الاستخدام

هذا المجلد يحتوي على مكونات HTML القابلة لإعادة الاستخدام في نظام طلبات الشحن. تستخدم هذه المكونات لتوحيد مظهر وسلوك أجزاء معينة من الواجهة عبر صفحات النظام المختلفة.

## الملفات الرئيسية

- **sidebar-html.html**: القائمة الجانبية الموحدة المستخدمة في جميع صفحات النظام
- **header.html**: رأس الصفحة الموحد
- **footer.html**: تذييل الصفحة الموحد
- **modals.html**: النوافذ المنبثقة المشتركة

## كيفية الاستخدام

يتم تضمين هذه المكونات في صفحات HTML باستخدام JavaScript أو PHP.

### تضمين المكونات باستخدام JavaScript

```javascript
// تحميل القائمة الجانبية الموحدة
document.addEventListener('DOMContentLoaded', function() {
  fetch('includes/sidebar-html.html')
    .then(response => response.text())
    .then(data => {
      document.getElementById('sidebar-container').innerHTML = data;
      
      // تحديد الصفحة النشطة
      const navLinks = document.querySelectorAll('.nav-item');
      navLinks.forEach(link => {
        if (link.getAttribute('href') === 'dashboard.html') {
          link.classList.add('active');
        }
      });
    })
    .catch(error => console.error('خطأ في تحميل القائمة الجانبية:', error));
});
```

### تضمين المكونات باستخدام PHP

```php
<?php include 'includes/header.html'; ?>

<!-- محتوى الصفحة -->

<?php include 'includes/footer.html'; ?>
```

## مزايا استخدام المكونات القابلة لإعادة الاستخدام

- توحيد مظهر وسلوك الواجهة عبر جميع صفحات النظام
- تسهيل الصيانة والتحديث (تعديل في مكان واحد يؤثر على جميع الصفحات)
- تقليل تكرار الكود
- تحسين أداء التحميل من خلال التخزين المؤقت للمكونات المشتركة
