<?php
// تفعيل عرض الأخطاء
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// بدء الجلسة
session_start();

// إنشاء بيانات مستخدم وهمية للاختبار
$_SESSION['user_id'] = 1;
$_SESSION['username'] = 'admin';
$_SESSION['full_name'] = 'مدير النظام';
$_SESSION['email'] = 'admin@example.com';
$_SESSION['role'] = 'admin';
$_SESSION['branch_id'] = 1;
$_SESSION['logged_in'] = true;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>الصفحة الرئيسية</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 20px;
      background-color: #f5f5f5;
    }
    .container {
      max-width: 800px;
      margin: 0 auto;
      background-color: white;
      padding: 20px;
      border-radius: 5px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    h1 {
      color: #333;
    }
    .links {
      margin-top: 20px;
    }
    .links a {
      display: block;
      margin-bottom: 10px;
      padding: 10px;
      background-color: #4f46e5;
      color: white;
      text-decoration: none;
      border-radius: 5px;
    }
    .links a:hover {
      background-color: #3730a3;
    }
  </style>
</head>
<body>
  <div class="container">
    <h1>مرحبًا بك في نظام طلبات الشحن</h1>
    <p>مرحبًا، <?php echo htmlspecialchars($_SESSION['full_name']); ?>!</p>

    <div class="links">
      <h2>الروابط المتاحة:</h2>
      <a href="unified-dashboard.php">لوحة التحكم الموحدة</a>

      <h2>صفحات تسجيل الدخول:</h2>
      <a href="auth/login.php">صفحة تسجيل الدخول الأصلية</a>
      <a href="simple-login.php">صفحة تسجيل الدخول البسيطة</a>

      <h2>أدوات قاعدة البيانات:</h2>
      <a href="check-db.php">فحص حالة قاعدة البيانات</a>
      <a href="setup-db.php">إعداد قاعدة البيانات</a>
      <a href="database/setup_database.php">إعداد قاعدة البيانات (الأصلي)</a>

      <h2>صفحات أخرى:</h2>
      <a href="test.php">صفحة الاختبار</a>
      <a href="simple.php">صفحة بسيطة</a>
    </div>
  </div>
</body>
</html>
