# تعليمات تجهيز نظام طلبات الشحن على مجال فرعي

## مقدمة

هذا الدليل يشرح كيفية تجهيز نظام طلبات الشحن على مجال فرعي باستخدام لوحة تحكم cPanel. يمكنك استخدام هذه التعليمات لإعداد النظام على مجال فرعي مثل `shipping.yourdomain.com`.

## المتطلبات

1. **استضافة ويب**:
   - استضافة تدعم PHP 7.0 أو أعلى
   - لوحة تحكم cPanel أو ما يعادلها
   - دعم قواعد بيانات MySQL

2. **نطاق رئيسي**:
   - نطاق رئيسي فعال (مثل: yourdomain.com)
   - صلاحية إنشاء مجالات فرعية

3. **ملفات النظام**:
   - جميع ملفات نظام طلبات الشحن
   - ملف `subdomain_config.php` المرفق مع هذا الدليل

## خطوات التجهيز

### 1. إنشاء المجال الفرعي في لوحة تحكم cPanel

1. **الدخول إلى لوحة تحكم cPanel**:
   - قم بتسجيل الدخول إلى لوحة تحكم cPanel الخاصة بك.

2. **إنشاء المجال الفرعي**:
   - انتقل إلى قسم "المجالات" أو "Domains".
   - اختر "المجالات الفرعية" أو "Subdomains".
   - أدخل اسم المجال الفرعي (مثل: shipping).
   - اختر المجال الرئيسي (مثل: yourdomain.com).
   - حدد مجلد المستندات (Document Root) للمجال الفرعي (مثل: public_html/shipping).
   - انقر على "إنشاء".

   ![إنشاء المجال الفرعي](https://example.com/images/create_subdomain.png)

### 2. إنشاء قاعدة البيانات

1. **إنشاء قاعدة بيانات جديدة**:
   - انتقل إلى قسم "قواعد البيانات" أو "Databases".
   - اختر "قواعد بيانات MySQL" أو "MySQL Databases".
   - أدخل اسم قاعدة البيانات (مثل: shipping_system).
   - انقر على "إنشاء قاعدة البيانات".

2. **إنشاء مستخدم لقاعدة البيانات**:
   - في نفس الصفحة، انتقل إلى قسم "إنشاء مستخدم جديد" أو "Add New User".
   - أدخل اسم المستخدم وكلمة المرور.
   - انقر على "إنشاء مستخدم".

3. **ربط المستخدم بقاعدة البيانات**:
   - في نفس الصفحة، انتقل إلى قسم "إضافة مستخدم إلى قاعدة بيانات" أو "Add User To Database".
   - اختر المستخدم وقاعدة البيانات التي أنشأتها.
   - امنح المستخدم جميع الصلاحيات (ALL PRIVILEGES).
   - انقر على "إضافة".

   ![إنشاء قاعدة البيانات](https://example.com/images/create_database.png)

### 3. تحميل ملفات النظام

1. **تحميل الملفات إلى المجلد المحدد**:
   - استخدم مدير الملفات في cPanel أو FTP للوصول إلى مجلد المستندات للمجال الفرعي (public_html/shipping).
   - قم بتحميل جميع ملفات النظام إلى هذا المجلد.
   - تأكد من تحميل الملفات الخفية مثل .htaccess و web.config.

2. **ضبط صلاحيات الملفات والمجلدات**:
   - ضبط صلاحيات الملفات إلى 644.
   - ضبط صلاحيات المجلدات إلى 755.
   - ضبط صلاحيات المجلدات التي تحتاج إلى الكتابة (مثل مجلد الصور أو التحميلات) إلى 777.

   ![تحميل الملفات](https://example.com/images/upload_files.png)

### 4. تكوين النظام

1. **تحميل ملف `subdomain_config.php`**:
   - قم بتحميل ملف `subdomain_config.php` إلى مجلد المستندات للمجال الفرعي.

2. **الوصول إلى ملف التكوين**:
   - افتح المتصفح وانتقل إلى `https://shipping.yourdomain.com/subdomain_config.php`.
   - ستظهر صفحة تكوين المجال الفرعي.

3. **إدخال معلومات التكوين**:
   - أدخل اسم المجال الفرعي (مثل: shipping).
   - أدخل اسم المجال الرئيسي (مثل: yourdomain.com).
   - أدخل معلومات قاعدة البيانات (المضيف، اسم قاعدة البيانات، اسم المستخدم، كلمة المرور).
   - انقر على "تحديث التكوين".

   ![تكوين النظام](https://example.com/images/configure_system.png)

### 5. إعداد قاعدة البيانات

1. **استيراد هيكل قاعدة البيانات**:
   - انتقل إلى phpMyAdmin من لوحة تحكم cPanel.
   - اختر قاعدة البيانات التي أنشأتها.
   - انقر على علامة التبويب "استيراد" أو "Import".
   - اختر ملف AEW77.sql وقم باستيراده.
   - انقر على "تنفيذ" أو "Go".

2. **إنشاء جدول الطلبات**:
   - في phpMyAdmin، اختر قاعدة البيانات.
   - انقر على علامة التبويب "SQL".
   - انسخ محتوى ملف create_orders_table.sql والصقه في مربع النص.
   - انقر على "تنفيذ" أو "Go".

   ![إعداد قاعدة البيانات](https://example.com/images/setup_database.png)

### 6. اختبار النظام

1. **الوصول إلى النظام**:
   - افتح المتصفح وانتقل إلى المجال الفرعي (مثل: https://shipping.yourdomain.com).
   - تأكد من أن الصفحة الرئيسية (dashboard.html) تظهر بشكل صحيح.

2. **اختبار وظائف النظام**:
   - تأكد من عمل جميع الصفحات بشكل صحيح.
   - اختبر إنشاء طلب جديد.
   - اختبر عرض الطلبات في صفحة إدارة الطلبات.
   - اختبر الوظائف الأخرى مثل البحث والتصفية.

3. **اختبار الاتصال بقاعدة البيانات**:
   - قم بزيارة ملف check_orders.php (مثل: https://shipping.yourdomain.com/check_orders.php).
   - تأكد من أن الاتصال بقاعدة البيانات يعمل بشكل صحيح.

   ![اختبار النظام](https://example.com/images/test_system.png)

### 7. تأمين النظام

1. **تفعيل شهادة SSL**:
   - انتقل إلى قسم "الأمان" أو "Security" في لوحة تحكم cPanel.
   - اختر "Let's Encrypt SSL" أو أي خيار آخر لتفعيل SSL.
   - اختر المجال الفرعي وقم بتفعيل SSL.

2. **تأمين الملفات الحساسة**:
   - تأكد من أن ملفات التكوين مثل config.php لا يمكن الوصول إليها من المتصفح.
   - تأكد من أن مجلدات التحميل محمية بشكل صحيح.

3. **إعداد نسخ احتياطي دوري**:
   - قم بإعداد نسخ احتياطي دوري لقاعدة البيانات والملفات.
   - يمكن استخدام أداة النسخ الاحتياطي في cPanel.

   ![تأمين النظام](https://example.com/images/secure_system.png)

## استكشاف الأخطاء وإصلاحها

### مشكلة: لا يمكن الوصول إلى المجال الفرعي

- تأكد من إنشاء المجال الفرعي بشكل صحيح في لوحة تحكم cPanel.
- تأكد من أن DNS قد تم تحديثه وانتشر (قد يستغرق ذلك حتى 24 ساعة).
- تحقق من إعدادات جدار الحماية وتأكد من أنه لا يحظر الوصول إلى المجال الفرعي.

### مشكلة: لا يمكن الاتصال بقاعدة البيانات

- تأكد من صحة معلومات الاتصال بقاعدة البيانات (المضيف، اسم قاعدة البيانات، اسم المستخدم، كلمة المرور).
- تأكد من أن المستخدم لديه صلاحيات كافية للوصول إلى قاعدة البيانات.
- تحقق من أن خدمة MySQL تعمل بشكل صحيح.

### مشكلة: الصفحات لا تظهر بشكل صحيح

- تأكد من تحميل جميع ملفات النظام بشكل صحيح.
- تحقق من صلاحيات الملفات والمجلدات.
- تأكد من أن المتصفح يدعم JavaScript وأنه مفعل.
- حاول مسح ذاكرة التخزين المؤقت للمتصفح.

## الدعم الفني

إذا واجهتك أي مشكلة أثناء تجهيز النظام على مجال فرعي، يرجى التواصل مع فريق الدعم الفني.
