# خطة تنظيم مشروع نظام طلبات الشحن

## الهيكل الحالي للمشروع

يتكون المشروع حاليًا من مجموعة من الملفات والمجلدات المنظمة جزئيًا:

- ملفات HTML في المجلد الرئيسي (dashboard.html, orders.html, login-new.html, إلخ)
- ملفات CSS في مجلد css
- ملفات JavaScript في مجلد js
- ملفات الصور في مجلد images
- ملفات PHP في المجلد الرئيسي وفي مجلد api
- ملفات التكوين في المجلد الرئيسي (config.php, subdomain_config.php)
- ملفات قاعدة البيانات في المجلد الرئيسي (create_orders_table.sql)
- ملفات تحويل SVG إلى PNG (convert-svg-to-png.ps1, convert-svg-simple.ps1)

## خطة التنظيم

### 1. إنشاء هيكل مجلدات موحد

سيتم تنظيم المشروع وفقًا للهيكل التالي:

```
/
├── api/                  # ملفات API
├── assets/               # الأصول الثابتة (الصور، الأيقونات، إلخ)
│   ├── images/           # الصور
│   └── fonts/            # الخطوط
├── config/               # ملفات التكوين
├── css/                  # ملفات CSS
├── database/             # ملفات قاعدة البيانات
├── includes/             # مكونات HTML القابلة لإعادة الاستخدام
├── js/                   # ملفات JavaScript
├── pages/                # صفحات HTML
└── utils/                # أدوات وسكربتات مساعدة
```

### 2. نقل الملفات إلى المجلدات المناسبة

#### ملفات HTML
- نقل جميع ملفات HTML (باستثناء index.html و login-new.html) إلى مجلد pages
- الاحتفاظ بـ index.html و login-new.html في المجلد الرئيسي
- تغيير اسم login-new.html إلى login.html

#### ملفات PHP
- نقل ملفات API إلى مجلد api
- نقل ملفات التكوين إلى مجلد config

#### ملفات قاعدة البيانات
- نقل جميع ملفات SQL وملفات قاعدة البيانات إلى مجلد database

#### ملفات المساعدة
- نقل سكربتات التحويل والأدوات المساعدة إلى مجلد utils

### 3. تنظيف الملفات المكررة

- إزالة ملفات تسجيل الدخول المكررة (الاحتفاظ فقط بـ login-new.html)
- إزالة سكربتات تحويل SVG المكررة (الاحتفاظ بواحد فقط)
- توحيد ملفات التكوين

### 4. تحديث المراجع في الملفات

بعد نقل الملفات، سيتم تحديث جميع المراجع في الملفات لتعكس الهيكل الجديد:

- تحديث مسارات الملفات في ملفات HTML
- تحديث مسارات الملفات في ملفات CSS
- تحديث مسارات الملفات في ملفات JavaScript
- تحديث مسارات التضمين في ملفات PHP

### 5. توثيق الهيكل الجديد

- إنشاء ملف README.md في المجلد الرئيسي يشرح هيكل المشروع
- إنشاء ملفات README.md في كل مجلد رئيسي لشرح محتوياته

## خطوات التنفيذ

1. إنشاء المجلدات الجديدة
2. نقل الملفات إلى المجلدات المناسبة
3. تحديث المراجع في الملفات
4. إزالة الملفات المكررة
5. اختبار النظام للتأكد من عمله بشكل صحيح
6. توثيق الهيكل الجديد

## ملاحظات هامة

- يجب الحفاظ على تسمية الملفات الحالية لتجنب كسر الروابط
- يجب تحديث ملف .htaccess ليعكس الهيكل الجديد
- يجب اختبار النظام بعد كل خطوة للتأكد من عدم وجود أخطاء
