# دليل نشر النظام على استضافة cPanel

هذا الدليل يشرح خطوات نشر نظام طلبات الشحن على استضافة cPanel.

## المتطلبات الأساسية

1. استضافة cPanel مع دعم PHP 7.0 أو أعلى
2. دعم قواعد بيانات MySQL 5.7 أو أعلى
3. دعم SSL/TLS (موصى به للأمان)
4. مساحة تخزين كافية (على الأقل 100 ميجابايت)

## خطوات النشر

### 1. إعداد قاعدة البيانات

1. قم بتسجيل الدخول إلى لوحة تحكم cPanel الخاصة بك.
2. انتقل إلى قسم "قواعد البيانات" أو "Databases".
3. أنشئ قاعدة بيانات جديدة (مثلاً: `username_shipping`).
4. أنشئ مستخدم قاعدة بيانات جديد وقم بتعيين كلمة مرور قوية.
5. قم بإضافة المستخدم إلى قاعدة البيانات مع منحه جميع الصلاحيات.
6. قم بتدوين اسم قاعدة البيانات واسم المستخدم وكلمة المرور لاستخدامها لاحقًا.

### 2. رفع ملفات النظام

#### الطريقة الأولى: استخدام مدير الملفات في cPanel

1. قم بتسجيل الدخول إلى لوحة تحكم cPanel الخاصة بك.
2. انتقل إلى "مدير الملفات" أو "File Manager".
3. انتقل إلى المجلد العام (عادة `public_html`).
4. قم بإنشاء مجلد جديد للنظام (مثلاً: `shipping`).
5. قم برفع جميع ملفات النظام إلى هذا المجلد.

#### الطريقة الثانية: استخدام FTP

1. قم بتنزيل وتثبيت برنامج FTP (مثل FileZilla).
2. قم بالاتصال بالخادم باستخدام بيانات FTP الخاصة بك.
3. انتقل إلى المجلد العام (عادة `public_html`).
4. قم بإنشاء مجلد جديد للنظام (مثلاً: `shipping`).
5. قم برفع جميع ملفات النظام إلى هذا المجلد.

### 3. تكوين النظام

1. قم بتحرير ملف `config/db_credentials.php` وتحديث بيانات الاتصال بقاعدة البيانات:
   ```php
   return [
       'db_host' => 'localhost',
       'db_name' => 'username_shipping', // اسم قاعدة البيانات التي أنشأتها
       'db_user' => 'username_dbuser', // اسم مستخدم قاعدة البيانات
       'db_pass' => 'your_password', // كلمة مرور قاعدة البيانات
       'use_mysql' => true,
       'sqlite_db_file' => __DIR__ . '/../database/shipping.sqlite'
   ];
   ```

2. بدلاً من ذلك، يمكنك استخدام أداة إعداد قاعدة البيانات:
   - قم بزيارة `http://yourdomain.com/shipping/database/setup_cpanel_database.php?token=ASDRF43_SECURE_TOKEN`
   - قم بإدخال بيانات الاتصال بقاعدة البيانات واتبع التعليمات.

### 4. ضبط صلاحيات الملفات

1. قم بتعيين صلاحيات المجلدات التالية إلى `755` (قابلة للقراءة والتنفيذ للجميع، وقابلة للكتابة للمالك فقط):
   - `uploads`
   - `logs`
   - `cache`
   - `backups`

2. قم بتعيين صلاحيات الملفات التالية إلى `644` (قابلة للقراءة للجميع، وقابلة للكتابة للمالك فقط):
   - جميع ملفات PHP
   - جميع ملفات CSS و JavaScript
   - جميع ملفات HTML

3. قم بتعيين صلاحيات الملفات التالية إلى `600` (قابلة للقراءة والكتابة للمالك فقط):
   - `config/db_credentials.php`

### 5. تفعيل SSL/TLS (موصى به)

1. قم بتسجيل الدخول إلى لوحة تحكم cPanel الخاصة بك.
2. انتقل إلى قسم "الأمان" أو "Security".
3. ابحث عن "Let's Encrypt SSL" أو أي خيار آخر لتفعيل SSL.
4. اتبع التعليمات لتفعيل SSL للنطاق الخاص بك.
5. بعد تفعيل SSL، قم بتحرير ملف `.htaccess` وإزالة التعليق من الأسطر التالية:
   ```apache
   # إعادة توجيه HTTP إلى HTTPS
   RewriteCond %{HTTPS} off
   RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
   ```

### 6. تحسين أمان النظام

1. قم بزيارة `http://yourdomain.com/shipping/utils/security_enhancer.php` لتحسين أمان النظام.
2. تأكد من أن جميع العمليات تمت بنجاح.

### 7. اختبار النظام

1. قم بزيارة `http://yourdomain.com/shipping/` للتأكد من أن النظام يعمل بشكل صحيح.
2. قم بتسجيل الدخول باستخدام بيانات المستخدم الافتراضية:
   - اسم المستخدم: `admin`
   - كلمة المرور: `Admin123`
3. قم بتغيير كلمة المرور الافتراضية فورًا.

## استكشاف الأخطاء وإصلاحها

### مشكلة: صفحة بيضاء أو خطأ 500

1. تحقق من سجلات الخطأ في cPanel (قسم "Logs" أو "Error Log").
2. تأكد من أن إصدار PHP المستخدم هو 7.0 أو أعلى.
3. تأكد من صحة بيانات الاتصال بقاعدة البيانات.
4. تأكد من صلاحيات الملفات والمجلدات.

### مشكلة: خطأ في الاتصال بقاعدة البيانات

1. تأكد من صحة بيانات الاتصال في ملف `config/db_credentials.php`.
2. تأكد من وجود قاعدة البيانات وأن المستخدم لديه صلاحيات كافية.
3. تأكد من أن خادم قاعدة البيانات يعمل.

### مشكلة: مشاكل في تحميل الملفات

1. تأكد من صلاحيات مجلد `uploads`.
2. تأكد من أن حجم الملف لا يتجاوز الحد الأقصى المسموح به في PHP.
3. تأكد من أن نوع الملف مسموح به.

## الصيانة الدورية

### النسخ الاحتياطي

1. قم بعمل نسخة احتياطية من قاعدة البيانات بانتظام:
   - استخدم أداة "phpMyAdmin" في cPanel.
   - قم بتصدير قاعدة البيانات بتنسيق SQL.
   - قم بحفظ ملف التصدير في مكان آمن.

2. قم بعمل نسخة احتياطية من ملفات النظام بانتظام:
   - استخدم أداة "Backup" في cPanel.
   - قم بتنزيل النسخة الاحتياطية وحفظها في مكان آمن.

### التحديثات

1. قم بتحديث النظام بانتظام للحصول على أحدث الميزات وإصلاحات الأمان.
2. قبل التحديث، قم دائمًا بعمل نسخة احتياطية من قاعدة البيانات وملفات النظام.

## الخاتمة

بهذا تكون قد أكملت نشر نظام طلبات الشحن على استضافة cPanel. إذا واجهت أي مشاكل أو كان لديك أي استفسارات، يرجى التواصل مع فريق الدعم الفني.
