<?php
/**
 * سكريبت لإعادة تعيين كلمة مرور المسؤول بشكل مباشر
 */

// عرض جميع الأخطاء للمساعدة في التشخيص
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once 'config/db_connection.php';

// التحقق من وجود اتصال بقاعدة البيانات
if (!isset($conn) || !$conn) {
    die("فشل الاتصال بقاعدة البيانات");
}

// تعريف متغيرات لبيانات المدير
$adminUsername = "admin";
$adminEmail = "admin@al-ahmadigroup.com";
$adminPassword = "admin123"; // كلمة المرور الافتراضية
$adminFullName = "مدير النظام";
$adminRole = "admin";
$adminStatus = "active";
$adminIsActive = 1;

// تعريف متغير لتخزين الرسائل
$messages = [];
$errors = [];

// دالة لإضافة رسالة
function addMessage($type, $message) {
    global $messages;
    $messages[] = ['type' => $type, 'message' => $message];
}

// دالة لإضافة خطأ
function addError($message) {
    global $errors;
    $errors[] = $message;
}

try {
    // البحث عن المركز الرئيسي
    $stmt = $conn->prepare("SELECT id FROM branches WHERE name = 'المركز الرئيسي'");
    $stmt->execute();
    $headquarters = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // إذا لم يكن المركز الرئيسي موجودًا، قم بإنشائه
    if (!$headquarters) {
        $stmt = $conn->prepare("INSERT INTO branches (name, code, is_active) VALUES ('المركز الرئيسي', 'HQ', 1)");
        $stmt->execute();
        $headquartersId = $conn->lastInsertId();
        addMessage('success', 'تم إنشاء المركز الرئيسي بنجاح (المعرف: ' . $headquartersId . ')');
    } else {
        $headquartersId = $headquarters['id'];
        addMessage('info', 'المركز الرئيسي موجود بالفعل (المعرف: ' . $headquartersId . ')');
    }
    
    // البحث عن مدير النظام
    $stmt = $conn->prepare("SELECT * FROM users WHERE username = :username OR email = :email");
    $stmt->bindParam(':username', $adminUsername);
    $stmt->bindParam(':email', $adminEmail);
    $stmt->execute();
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // تشفير كلمة المرور الجديدة
    $hashedPassword = password_hash($adminPassword, PASSWORD_DEFAULT);
    
    if ($admin) {
        // تحديث بيانات المدير
        $stmt = $conn->prepare("
            UPDATE users 
            SET username = :username,
                full_name = :full_name, 
                email = :email, 
                password = :password, 
                branch_id = :branch_id,
                role = :role,
                status = :status,
                is_active = :is_active
            WHERE id = :id
        ");
        
        $stmt->bindParam(':username', $adminUsername);
        $stmt->bindParam(':full_name', $adminFullName);
        $stmt->bindParam(':email', $adminEmail);
        $stmt->bindParam(':password', $hashedPassword);
        $stmt->bindParam(':branch_id', $headquartersId);
        $stmt->bindParam(':role', $adminRole);
        $stmt->bindParam(':status', $adminStatus);
        $stmt->bindParam(':is_active', $adminIsActive);
        $stmt->bindParam(':id', $admin['id']);
        
        $stmt->execute();
        
        addMessage('success', 'تم تحديث بيانات مدير النظام بنجاح (المعرف: ' . $admin['id'] . ')');
    } else {
        // إنشاء مدير النظام
        $stmt = $conn->prepare("
            INSERT INTO users (
                username, 
                password, 
                full_name, 
                email, 
                role, 
                branch_id, 
                status, 
                is_active, 
                registration_date
            ) VALUES (
                :username, 
                :password, 
                :full_name, 
                :email, 
                :role, 
                :branch_id, 
                :status, 
                :is_active, 
                NOW()
            )
        ");
        
        $stmt->bindParam(':username', $adminUsername);
        $stmt->bindParam(':password', $hashedPassword);
        $stmt->bindParam(':full_name', $adminFullName);
        $stmt->bindParam(':email', $adminEmail);
        $stmt->bindParam(':role', $adminRole);
        $stmt->bindParam(':branch_id', $headquartersId);
        $stmt->bindParam(':status', $adminStatus);
        $stmt->bindParam(':is_active', $adminIsActive);
        
        $stmt->execute();
        $adminId = $conn->lastInsertId();
        
        addMessage('success', 'تم إنشاء مدير النظام بنجاح (المعرف: ' . $adminId . ')');
    }
    
    addMessage('success', 'تم إعادة تعيين كلمة مرور مدير النظام بنجاح. يمكنك الآن تسجيل الدخول باستخدام البيانات التالية:');
    
} catch (PDOException $e) {
    addError('حدث خطأ في قاعدة البيانات: ' . $e->getMessage());
} catch (Exception $e) {
    addError('حدث خطأ: ' . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعادة تعيين كلمة مرور مدير النظام</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }
        h1 {
            color: #4c0c70;
            text-align: center;
            margin-bottom: 30px;
            font-size: 28px;
        }
        .message {
            padding: 15px;
            margin-bottom: 15px;
            border-radius: 5px;
            font-size: 16px;
        }
        .success {
            background-color: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #c8e6c9;
        }
        .error {
            background-color: #ffebee;
            color: #c62828;
            border: 1px solid #ffcdd2;
        }
        .info {
            background-color: #e3f2fd;
            color: #1565c0;
            border: 1px solid #bbdefb;
        }
        .admin-info {
            background-color: #f3e5f5;
            padding: 20px;
            border-radius: 5px;
            margin-top: 20px;
            border: 1px solid #e1bee7;
        }
        .admin-info h2 {
            color: #6a1b9a;
            margin-top: 0;
        }
        .back-link {
            display: block;
            text-align: center;
            margin-top: 20px;
            color: #4c0c70;
            text-decoration: none;
            font-weight: bold;
        }
        .back-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>إعادة تعيين كلمة مرور مدير النظام</h1>
        
        <?php if (!empty($errors)): ?>
            <?php foreach ($errors as $error): ?>
                <div class="message error">
                    <?php echo $error; ?>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <?php foreach ($messages as $message): ?>
            <div class="message <?php echo $message['type']; ?>">
                <?php echo $message['message']; ?>
            </div>
        <?php endforeach; ?>
        
        <div class="admin-info">
            <h2>معلومات مدير النظام</h2>
            <p><strong>اسم المستخدم:</strong> <?php echo $adminUsername; ?></p>
            <p><strong>البريد الإلكتروني:</strong> <?php echo $adminEmail; ?></p>
            <p><strong>كلمة المرور:</strong> <?php echo $adminPassword; ?> (كلمة المرور الجديدة)</p>
            <p><strong>الفرع:</strong> المركز الرئيسي</p>
        </div>
        
        <a href="auth/login.php" class="back-link">العودة إلى صفحة تسجيل الدخول</a>
    </div>
</body>
</html>
