-- ملف إضافة الفهارس لتحسين أداء قاعدة البيانات
-- تاريخ الإنشاء: 2023-07-20

-- استخدام قاعدة البيانات
USE `shipping_db`;

-- إضافة فهارس لجدول الطلبات
-- فهرس للبحث حسب حالة الطلب (يستخدم في إحصائيات لوحة التحكم)
CREATE INDEX IF NOT EXISTS idx_orders_status ON orders (status);

-- فهرس للبحث حسب تاريخ الإنشاء (يستخدم في الطلبات الأخيرة والإحصائيات)
CREATE INDEX IF NOT EXISTS idx_orders_created_at ON orders (created_at);

-- فهرس للبحث حسب اسم الموظف (يستخدم في إحصائيات أفضل الموظفين)
CREATE INDEX IF NOT EXISTS idx_orders_employee_name ON orders (employee_name);

-- فهرس للبحث حسب معرف الفرع (يستخدم في إحصائيات أفضل الفروع)
CREATE INDEX IF NOT EXISTS idx_orders_branch_id ON orders (branch_id);

-- فهرس مركب للبحث حسب الفرع والتاريخ (يستخدم في إحصائيات الفروع حسب الفترة الزمنية)
CREATE INDEX IF NOT EXISTS idx_orders_branch_date ON orders (branch_id, created_at);

-- فهرس مركب للبحث حسب الموظف والتاريخ (يستخدم في إحصائيات الموظفين حسب الفترة الزمنية)
CREATE INDEX IF NOT EXISTS idx_orders_employee_date ON orders (employee_name, created_at);

-- فهرس للبحث حسب رقم الطلب (يستخدم في البحث عن الطلبات)
CREATE INDEX IF NOT EXISTS idx_orders_order_number ON orders (order_number);

-- فهرس للبحث حسب اسم العميل (يستخدم في البحث عن الطلبات)
CREATE INDEX IF NOT EXISTS idx_orders_customer_name ON orders (customer_name);

-- إضافة فهارس لجدول المستخدمين
-- فهرس للبحث حسب اسم المستخدم (يستخدم في تسجيل الدخول)
CREATE INDEX IF NOT EXISTS idx_users_username ON users (username);

-- فهرس للبحث حسب البريد الإلكتروني (يستخدم في تسجيل الدخول واستعادة كلمة المرور)
CREATE INDEX IF NOT EXISTS idx_users_email ON users (email);

-- فهرس للبحث حسب الدور (يستخدم في إدارة المستخدمين)
CREATE INDEX IF NOT EXISTS idx_users_role ON users (role);

-- إضافة فهارس لجدول الفروع
-- فهرس للبحث حسب رمز الفرع (يستخدم في إنشاء أرقام الطلبات)
CREATE INDEX IF NOT EXISTS idx_branches_code ON branches (code);

-- فهرس للبحث حسب اسم الفرع (يستخدم في البحث عن الفروع)
CREATE INDEX IF NOT EXISTS idx_branches_name ON branches (name);

-- إضافة فهارس لجدول تسلسل أرقام الطلبات
-- فهرس للبحث حسب رمز الفرع (يستخدم في إنشاء أرقام الطلبات)
CREATE INDEX IF NOT EXISTS idx_order_sequences_branch_code ON order_sequences (branch_code);

-- إضافة فهارس لجدول أرشيف الطلبات
-- فهرس للبحث حسب تاريخ الإنشاء (يستخدم في البحث في الأرشيف)
CREATE INDEX IF NOT EXISTS idx_archived_orders_created_at ON archived_orders (created_at);

-- فهرس للبحث حسب رقم الطلب (يستخدم في البحث في الأرشيف)
CREATE INDEX IF NOT EXISTS idx_archived_orders_order_number ON archived_orders (order_number);

-- فهرس للبحث حسب اسم العميل (يستخدم في البحث في الأرشيف)
CREATE INDEX IF NOT EXISTS idx_archived_orders_customer_name ON archived_orders (customer_name);

-- فهرس للبحث حسب حالة الطلب (يستخدم في البحث في الأرشيف)
CREATE INDEX IF NOT EXISTS idx_archived_orders_status ON archived_orders (status);

-- إضافة فهارس لجدول إعدادات النظام
-- فهرس للبحث حسب مفتاح الإعداد (يستخدم في الحصول على إعدادات النظام)
CREATE INDEX IF NOT EXISTS idx_system_settings_setting_key ON system_settings (setting_key);

-- فهرس للبحث حسب مجموعة الإعداد (يستخدم في الحصول على إعدادات مجموعة معينة)
CREATE INDEX IF NOT EXISTS idx_system_settings_setting_group ON system_settings (setting_group);

-- إضافة فهارس لجدول سجل النشاط
-- فهرس للبحث حسب تاريخ النشاط (يستخدم في البحث في سجل النشاط)
CREATE INDEX IF NOT EXISTS idx_activity_log_created_at ON activity_log (created_at);

-- فهرس للبحث حسب معرف المستخدم (يستخدم في البحث في سجل نشاط مستخدم معين)
CREATE INDEX IF NOT EXISTS idx_activity_log_user_id ON activity_log (user_id);

-- فهرس للبحث حسب نوع النشاط (يستخدم في البحث في سجل نشاط من نوع معين)
CREATE INDEX IF NOT EXISTS idx_activity_log_activity_type ON activity_log (activity_type);
