# مجلد قاعدة البيانات

هذا المجلد يحتوي على ملفات قاعدة البيانات الخاصة بنظام طلبات الشحن. تستخدم هذه الملفات لإنشاء وتهيئة قاعدة البيانات ونقل البيانات.

## الملفات الرئيسية

- **final_unified_database.sql**: ملف قاعدة البيانات الموحد النهائي
- **setup_unified_database.php**: ملف PHP لإعداد قاعدة البيانات باستخدام الملف الموحد
- **setup_database.php**: ملف PHP لإعداد قاعدة البيانات (تم تحديثه ليستخدم الملف الموحد النهائي)
- **migrate_orders.php**: ملف PHP لنقل البيانات من localStorage إلى قاعدة البيانات

## كيفية الاستخدام

### الطريقة 1: استخدام ملف PHP

1. قم بفتح المتصفح وانتقل إلى `http://localhost/ASDRF43/database/setup_unified_database.php`
2. سيقوم الملف بإنشاء قاعدة البيانات وجداولها وإدراج البيانات الأولية تلقائيًا

### الطريقة 2: استخدام ملف SQL مباشرة

```bash
mysql -u username -p < database/final_unified_database.sql
```

### نقل البيانات من localStorage

يمكن استخدام ملف `migrate_orders.php` لنقل البيانات من localStorage إلى قاعدة البيانات. قم بفتح الملف في المتصفح واتبع التعليمات.

## هيكل قاعدة البيانات

### جدول الفروع (branches)

يستخدم لتخزين معلومات الفروع.

| العمود | النوع | الوصف |
|--------|------|-------|
| id | int | المعرف الفريد للفرع |
| name | varchar(100) | اسم الفرع |
| code | varchar(10) | رمز الفرع (فريد) |
| address | varchar(255) | عنوان الفرع |
| phone | varchar(20) | رقم هاتف الفرع |
| email | varchar(100) | البريد الإلكتروني للفرع |
| manager | varchar(100) | مدير الفرع |
| is_active | tinyint(1) | هل الفرع نشط (1 = نشط، 0 = غير نشط) |
| created_at | timestamp | تاريخ إنشاء الفرع |
| updated_at | timestamp | تاريخ تحديث الفرع |

### جدول تسلسل أرقام الطلبات (order_sequences)

يستخدم لتخزين آخر رقم تسلسلي لكل فرع.

| العمود | النوع | الوصف |
|--------|------|-------|
| id | int | المعرف الفريد |
| branch_code | varchar(10) | رمز الفرع |
| last_sequence_number | int | آخر رقم تسلسلي |
| created_at | timestamp | تاريخ الإنشاء |
| updated_at | timestamp | تاريخ التحديث |

### جدول المستخدمين (users)

يستخدم لتخزين معلومات المستخدمين.

| العمود | النوع | الوصف |
|--------|------|-------|
| id | int | المعرف الفريد للمستخدم |
| username | varchar(50) | اسم المستخدم (فريد) |
| password | varchar(255) | كلمة المرور المشفرة |
| full_name | varchar(100) | الاسم الكامل للمستخدم |
| email | varchar(100) | البريد الإلكتروني (فريد) |
| phone | varchar(20) | رقم الهاتف |
| role | enum | دور المستخدم (admin, manager, employee, client) |
| branch_id | int | معرف الفرع الذي ينتمي إليه المستخدم |
| is_active | tinyint(1) | هل المستخدم نشط |
| status | enum | حالة المستخدم (pending, active, inactive) |
| created_at | timestamp | تاريخ الإنشاء |
| updated_at | timestamp | تاريخ التحديث |

### جدول الطلبات (orders)

يستخدم لتخزين معلومات الطلبات.

| العمود | النوع | الوصف |
|--------|------|-------|
| id | int | المعرف الفريد للطلب |
| order_number | varchar(20) | رقم الطلب (فريد) |
| client_name | varchar(100) | اسم العميل |
| service_type | varchar(50) | نوع الخدمة |
| branch_id | int | معرف الفرع |
| departure_area | varchar(100) | منطقة المغادرة |
| delivery_area | varchar(100) | منطقة التسليم |
| goods_name | varchar(100) | اسم البضاعة |
| goods_type | varchar(50) | نوع البضاعة |
| country_of_origin | varchar(50) | بلد المنشأ |
| weight | decimal(10,2) | الوزن |
| quantity | int | الكمية |
| service_fees | decimal(10,2) | رسوم الخدمة |
| payment_status | enum | حالة الدفع (مدفوع، جزئي، غير مدفوع) |
| status | enum | حالة الطلب (قيد المعالجة، في الطريق، تم التسليم، ملغى) |
| user_id | int | معرف المستخدم الذي أنشأ الطلب |

### جدول الدول (countries)

يستخدم لتخزين معلومات الدول.

| العمود | النوع | الوصف |
|--------|------|-------|
| id | int | المعرف الفريد للدولة |
| name | varchar(100) | اسم الدولة |
| code | varchar(3) | رمز الدولة (فريد) |
| flag | varchar(255) | مسار علم الدولة |
| is_active | tinyint(1) | هل الدولة نشطة |
| created_at | timestamp | تاريخ الإنشاء |
| updated_at | timestamp | تاريخ التحديث |

## التغييرات التي تم إجراؤها

1. **توحيد ملفات SQL**: تم توحيد جميع ملفات SQL في ملفين رئيسيين (MySQL و SQLite)
2. **إضافة جداول جديدة**: تم إضافة جداول جديدة مثل جدول الدول وجدول إعدادات النظام
3. **تحسين هيكل الجداول**: تم تحسين هيكل الجداول وإضافة تعليقات توضيحية
4. **إضافة العلاقات**: تم إضافة العلاقات بين الجداول باستخدام المفاتيح الأجنبية
5. **إضافة البيانات الأولية**: تم إضافة البيانات الأولية للجداول الرئيسية
