# توثيق قاعدة البيانات الموحدة

تم توحيد جميع ملفات قاعدة البيانات في ملف واحد لتسهيل عملية الإعداد والصيانة.

## الملفات الرئيسية

- **final_unified_database.sql**: ملف SQL الموحد النهائي الذي يحتوي على جميع استعلامات إنشاء الجداول والبيانات الأولية.
- **setup_unified_database.php**: ملف PHP لإعداد قاعدة البيانات باستخدام الملف الموحد.

## هيكل قاعدة البيانات

تتكون قاعدة البيانات من الجداول التالية:

1. **branches**: جدول الفروع
2. **order_sequences**: جدول تسلسل أرقام الطلبات
3. **users**: جدول المستخدمين
4. **orders**: جدول الطلبات
5. **archived_orders**: جدول أرشيف الطلبات
6. **countries**: جدول الدول
7. **system_settings**: جدول إعدادات النظام
8. **activity_log**: جدول سجل النشاط

## طريقة الإعداد

### الطريقة 1: استخدام ملف PHP

1. قم بفتح المتصفح وانتقل إلى `http://localhost/ASDRF43/database/setup_unified_database.php`
2. سيقوم الملف بإنشاء قاعدة البيانات وجداولها وإدراج البيانات الأولية تلقائيًا

### الطريقة 2: استخدام ملف SQL مباشرة

1. قم بإنشاء قاعدة بيانات جديدة باسم `shipping_db`
2. قم باستيراد ملف `final_unified_database.sql` باستخدام phpMyAdmin أو أي أداة أخرى

## بيانات الدخول الافتراضية

- **اسم المستخدم**: admin
- **كلمة المرور**: admin123

## ملاحظات هامة

- تم توحيد جميع الجداول والبيانات الأولية في ملف واحد
- تم إضافة تعليقات توضيحية لكل جدول وعمود
- تم استخدام `IGNORE` في استعلامات `INSERT` لتجنب الأخطاء في حالة وجود البيانات بالفعل
- تم استخدام `IF NOT EXISTS` في استعلامات `CREATE TABLE` لتجنب الأخطاء في حالة وجود الجداول بالفعل

## التغييرات الرئيسية

- تم دمج جميع ملفات SQL في ملف واحد
- تم توحيد هيكل الجداول وإزالة التكرار
- تم تحسين العلاقات بين الجداول
- تم إضافة جداول جديدة مثل `system_settings` و `activity_log`
- تم تحسين التعليقات والتوثيق

## الملفات التي تم توحيدها

- create_branches_table.sql
- create_countries_table.sql
- create_orders_table.sql
- create_order_sequences_table.sql
- create_users_table.sql
- database.sql
- fix_users_table.sql
- unified_schema.sql
- unified_database.sql
- unified_database_sqlite.sql

## الملفات التي يمكن حذفها بعد التوحيد

يمكن حذف الملفات التالية بعد التوحيد لأنها أصبحت غير ضرورية:

- create_branches_table.sql
- create_countries_table.sql
- create_orders_table.sql
- create_order_sequences_table.sql
- create_users_table.sql
- database.sql
- fix_users_table.sql
- unified_schema.sql
- unified_database_sqlite.sql

## المؤلف

فريق التطوير
