<?php
/**
 * ملف بيانات الاتصال بقاعدة البيانات للاستضافة على cPanel
 * يحتوي على معلومات الاتصال بقاعدة البيانات بشكل منفصل عن ملف التكوين الرئيسي
 *
 * ملاحظات أمنية:
 * 1. يجب وضع هذا الملف خارج المجلد العام للويب إذا أمكن
 * 2. يجب تعيين صلاحيات الملف بحيث لا يمكن الوصول إليه إلا من قبل خادم الويب
 * 3. يجب عدم تضمين هذا الملف في نظام التحكم بالإصدارات (مثل Git)
 */

// تعريف ثابت للتحقق من أن الملف تم استدعاؤه من ملف التكوين الرئيسي
if (!defined('SECURE_ACCESS')) {
    // منع الوصول المباشر إلى هذا الملف
    header('HTTP/1.0 403 Forbidden');
    exit('الوصول غير مصرح به');
}

// إعدادات الاتصال بقاعدة البيانات في cPanel
// قم بتغيير هذه القيم وفقًا لإعدادات قاعدة البيانات الخاصة بك في cPanel
return [
    'db_host' => 'localhost', // عادة ما تكون localhost في cPanel
    'db_name' => 'اسم_قاعدة_البيانات', // استبدل بـ اسم قاعدة البيانات التي أنشأتها
    'db_user' => 'اسم_المستخدم', // استبدل بـ اسم المستخدم الذي أنشأته
    'db_pass' => 'كلمة_المرور', // استبدل بـ كلمة المرور التي حددتها
    'use_mysql' => true, // استخدام MySQL (دائمًا true في cPanel)
    'sqlite_db_file' => __DIR__ . '/../database/shipping.sqlite' // لن يتم استخدامه في cPanel
];
