<?php
/**
 * ملف الاتصال بقاعدة البيانات
 * يستخدم هذا الملف لإنشاء اتصال بقاعدة البيانات
 *
 * @version 1.0
 * @author فريق التطوير
 */

// التحقق من تضمين ملف التكوين
if (!defined('DB_HOST')) {
    // إذا لم يتم تضمين ملف التكوين، قم بتضمينه
    $config_path = __DIR__ . '/../config.php';
    if (file_exists($config_path)) {
        require_once $config_path;
    } else {
        // إذا لم يكن ملف التكوين موجودًا، استخدم القيم الافتراضية
        define('DB_HOST', 'localhost');
        define('DB_NAME', 'shipping_db');
        define('DB_USER', 'root');
        define('DB_PASS', '');
        define('DB_CHARSET', 'utf8mb4');
        define('DEBUG_MODE', true);
    }
}

// إعدادات PDO
$dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

// إنشاء اتصال PDO
try {
    $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
    $conn = $pdo; // للتوافق مع الكود القديم

    // تعيين المتغيرات القديمة للتوافق مع الكود القديم
    $db_host = DB_HOST;
    $db_name = DB_NAME;
    $db_user = DB_USER;
    $db_pass = DB_PASS;
    $db_charset = DB_CHARSET;
} catch (PDOException $e) {
    // في بيئة التطوير، يمكن عرض رسالة الخطأ
    if (defined('DEBUG_MODE') && DEBUG_MODE) {
        echo "فشل الاتصال بقاعدة البيانات: " . $e->getMessage();
    } else {
        // في بيئة الإنتاج، يجب عدم عرض تفاصيل الخطأ للمستخدم
        echo "حدث خطأ أثناء الاتصال بقاعدة البيانات. يرجى المحاولة مرة أخرى لاحقًا.";
    }
    // تسجيل الخطأ في ملف السجل
    error_log("خطأ في الاتصال بقاعدة البيانات: " . $e->getMessage());
    exit;
}
?>
