# مجلد التكوين

هذا المجلد يحتوي على ملفات التكوين الخاصة بنظام طلبات الشحن. تستخدم هذه الملفات لتخزين إعدادات النظام وإعدادات الاتصال بقاعدة البيانات.

## الملفات الرئيسية

- **config.php**: ملف التكوين الرئيسي للنظام
- **db_credentials.php**: ملف بيانات الاتصال بقاعدة البيانات (يحتوي على معلومات حساسة)
- **.htaccess**: ملف لمنع الوصول المباشر إلى ملفات التكوين

## إعداد الأمان

### 1. حماية ملفات التكوين

تم إضافة ملف `.htaccess` لمنع الوصول المباشر إلى ملفات PHP في مجلد التكوين. هذا يمنع المستخدمين من الوصول إلى ملفات التكوين مباشرة عبر المتصفح.

### 2. فصل بيانات الاتصال

تم نقل بيانات الاتصال بقاعدة البيانات إلى ملف منفصل `db_credentials.php`. هذا يسمح بإدارة أفضل للبيانات الحساسة وتسهيل تحديثها.

### 3. التحقق من الوصول الآمن

تم إضافة آلية للتحقق من أن ملف بيانات الاتصال يتم استدعاؤه فقط من ملف التكوين الرئيسي وليس مباشرة.

## كيفية الاستخدام

يتم تضمين ملف `config.php` في ملفات PHP الأخرى للوصول إلى إعدادات النظام وإعدادات قاعدة البيانات.

### مثال على تضمين ملف التكوين

```php
// تضمين ملف التكوين الرئيسي
require_once 'config/config.php';

// استخدام اتصال قاعدة البيانات
$stmt = $pdo->prepare("SELECT * FROM orders");
$stmt->execute();
$orders = $stmt->fetchAll();
```

## تحديث بيانات الاتصال بقاعدة البيانات

لتحديث بيانات الاتصال بقاعدة البيانات، قم بتعديل ملف `db_credentials.php` فقط. لا تقم بتعديل ملف `config.php` مباشرة.

```php
// مثال لمحتوى ملف db_credentials.php
return [
    'db_host' => 'localhost',
    'db_name' => 'shipping_db',
    'db_user' => 'database_user',
    'db_pass' => 'secure_password',
    'use_mysql' => true,
    'sqlite_db_file' => __DIR__ . '/../database/shipping.sqlite'
];
```

## توصيات إضافية للإنتاج

في بيئة الإنتاج، يوصى بما يلي:

1. وضع ملف `db_credentials.php` خارج المجلد العام للويب (public_html أو www)
2. استخدام متغيرات بيئية لتخزين بيانات الاتصال بدلاً من تخزينها في ملفات
3. تشفير بيانات الاتصال في حالة تخزينها في ملفات
4. تعيين صلاحيات الملفات بحيث لا يمكن الوصول إليها إلا من قبل خادم الويب (644 أو أقل)
5. استبعاد ملفات التكوين الحساسة من نظام التحكم بالإصدارات (مثل Git)
