<?php
/**
 * ملف التكوين الرئيسي لبيئة الإنتاج
 *
 * يحتوي هذا الملف على إعدادات النظام الأساسية لبيئة الإنتاج
 * يتم استخدام هذا الملف عند تحميل النظام على الاستضافة
 *
 * @version 1.0
 * @author فريق التطوير
 */

// تحميل ملف البيئة إذا كان موجودًا
if (file_exists(__DIR__ . '/.env')) {
    $env = parse_ini_file(__DIR__ . '/.env');
    foreach ($env as $key => $value) {
        $_ENV[$key] = $value;
        putenv("$key=$value");
    }
}

// تعطيل وضع التطوير في بيئة الإنتاج
define('DEBUG_MODE', getenv('DEVELOPMENT_MODE') === 'true' ? true : false);
define('DEVELOPMENT_MODE', DEBUG_MODE);

// معلومات النظام
define('SYSTEM_NAME', getenv('SYSTEM_NAME') ?: 'نظام طلبات الشحن');
define('COMPANY_NAME', getenv('COMPANY_NAME') ?: 'مجموعة ابراهيم الاحمدي اليمنية');
define('COMPANY_LOGO', getenv('COMPANY_LOGO') ?: 'assets/images/logo.png');
define('COMPANY_ADDRESS', getenv('COMPANY_ADDRESS') ?: 'اليمن، حضرموت، المكلا');
define('COMPANY_PHONE', getenv('COMPANY_PHONE') ?: '05318281');
define('COMPANY_EMAIL', getenv('COMPANY_EMAIL') ?: 'ibrahim@al-ahmadigroup.com');
define('SYSTEM_VERSION', '1.0.0');

// إعدادات قاعدة البيانات
define('DB_HOST', getenv('DB_HOST') ?: 'localhost');
define('DB_NAME', getenv('DB_NAME') ?: 'shipping_db');
define('DB_USER', getenv('DB_USER') ?: 'root');
define('DB_PASS', getenv('DB_PASS') ?: '');
define('DB_CHARSET', getenv('DB_CHARSET') ?: 'utf8mb4');
define('USE_MYSQL', getenv('USE_MYSQL') === 'true' ? true : false);
define('SQLITE_DB_FILE', getenv('SQLITE_DB_FILE') ?: __DIR__ . '/database/shipping.sqlite');

// المسارات
$base_url = '';
if (!empty($_SERVER['HTTP_HOST'])) {
    $base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
    // إذا كان النظام في مجلد فرعي
    $script_name = dirname($_SERVER['SCRIPT_NAME']);
    if ($script_name !== '/' && $script_name !== '\\') {
        $base_url .= $script_name;
    }
}
define('BASE_URL', $base_url);
define('ADMIN_URL', BASE_URL . '/admin');
define('ASSETS_URL', BASE_URL . '/assets');

// إعدادات الأمان
define('SESSION_LIFETIME', getenv('SESSION_LIFETIME') ?: 1440); // مدة الجلسة بالثواني (24 ساعة)
define('CSRF_TOKEN_LIFETIME', 1800); // مدة صلاحية رمز CSRF بالثواني (30 دقيقة)
define('COOKIE_SECURE', getenv('COOKIE_SECURE') === 'true' ? true : false);
define('COOKIE_HTTPONLY', getenv('COOKIE_HTTPONLY') === 'true' ? true : false);

// إعدادات التحميل
define('UPLOAD_DIR', __DIR__ . '/uploads');
define('MAX_UPLOAD_SIZE', 10 * 1024 * 1024); // 10 ميجابايت
define('ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx', 'xls', 'xlsx']);

// إعدادات التصحيح
if (DEBUG_MODE) {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    error_reporting(0);

    // تسجيل الأخطاء في ملف
    ini_set('log_errors', 1);
    ini_set('error_log', __DIR__ . '/logs/error.log');
}

// التأكد من وجود مجلد السجلات
if (!file_exists(__DIR__ . '/logs')) {
    mkdir(__DIR__ . '/logs', 0755, true);
}

// تعيين منطقة زمنية افتراضية
date_default_timezone_set('Asia/Riyadh');

// تعيين ترميز افتراضي
ini_set('default_charset', 'UTF-8');

// تعيين حد الذاكرة
ini_set('memory_limit', '256M');

// تعيين وقت التنفيذ الأقصى
set_time_limit(300);
?>
