<?php
/**
 * سكريبت للتحقق من جدول المستخدمين في قاعدة البيانات
 */

// عرض جميع الأخطاء للمساعدة في التشخيص
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once 'config/db_connection.php';

// التحقق من وجود اتصال بقاعدة البيانات
if (!isset($conn) || !$conn) {
    die("فشل الاتصال بقاعدة البيانات");
}

// التحقق من وجود جدول المستخدمين
try {
    $stmt = $conn->query("SHOW TABLES LIKE 'users'");
    $tableExists = $stmt->rowCount() > 0;

    echo "<h2>نتائج التحقق من قاعدة البيانات</h2>";
    echo "<p>حالة جدول المستخدمين: " . ($tableExists ? "موجود" : "غير موجود") . "</p>";

    if ($tableExists) {
        // التحقق من هيكل جدول المستخدمين
        $stmt = $conn->query("DESCRIBE users");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "<h3>هيكل جدول المستخدمين:</h3>";
        echo "<ul>";
        foreach ($columns as $column) {
            echo "<li>{$column['Field']} - {$column['Type']}</li>";
        }
        echo "</ul>";

        // التحقق من وجود مستخدم مسؤول
        $stmt = $conn->prepare("SELECT * FROM users WHERE username = 'admin' OR email = 'admin@al-ahmadigroup.com'");
        $stmt->execute();
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);

        echo "<h3>معلومات مستخدم المسؤول:</h3>";
        if ($admin) {
            echo "<p>تم العثور على مستخدم المسؤول:</p>";
            echo "<ul>";
            echo "<li>المعرف: {$admin['id']}</li>";
            echo "<li>اسم المستخدم: {$admin['username']}</li>";
            echo "<li>البريد الإلكتروني: {$admin['email']}</li>";
            echo "<li>الدور: {$admin['role']}</li>";
            echo "<li>الحالة: " . ($admin['is_active'] ?? 'غير محدد') . "</li>";
            echo "<li>الفرع: " . ($admin['branch_id'] ?? 'غير محدد') . "</li>";
            echo "</ul>";

            // التحقق من كلمة المرور الافتراضية
            $defaultPassword = 'admin123';
            $passwordVerified = password_verify($defaultPassword, $admin['password']);
            echo "<p>التحقق من كلمة المرور الافتراضية (admin123): " . ($passwordVerified ? "صحيحة" : "غير صحيحة") . "</p>";
        } else {
            echo "<p>لم يتم العثور على مستخدم المسؤول</p>";
        }

        // عرض جميع المستخدمين
        $stmt = $conn->query("SELECT id, username, email, role, is_active, branch_id FROM users");
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "<h3>جميع المستخدمين في النظام:</h3>";
        if (count($users) > 0) {
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr><th>المعرف</th><th>اسم المستخدم</th><th>البريد الإلكتروني</th><th>الدور</th><th>الحالة</th><th>الفرع</th></tr>";
            foreach ($users as $user) {
                echo "<tr>";
                echo "<td>{$user['id']}</td>";
                echo "<td>{$user['username']}</td>";
                echo "<td>{$user['email']}</td>";
                echo "<td>{$user['role']}</td>";
                echo "<td>" . ($user['is_active'] ? 'نشط' : 'غير نشط') . "</td>";
                echo "<td>{$user['branch_id']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p>لا يوجد مستخدمين في النظام</p>";
        }
    }
} catch (PDOException $e) {
    echo "<p>حدث خطأ أثناء التحقق من قاعدة البيانات: " . $e->getMessage() . "</p>";
}
?>
