<?php
/**
 * صفحة فحص حالة قاعدة البيانات
 * تستخدم هذه الصفحة لفحص حالة قاعدة البيانات والاتصال بها
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف التكوين
require_once 'config/config.php';

// دالة لفحص وجود قاعدة البيانات
function checkDatabaseExists($host, $user, $pass, $dbname) {
    try {
        // إنشاء اتصال بالخادم بدون تحديد قاعدة البيانات
        $pdo = new PDO("mysql:host=$host", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // التحقق من وجود قاعدة البيانات
        $stmt = $pdo->query("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '$dbname'");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        return $result !== false;
    } catch (PDOException $e) {
        return false;
    }
}

// دالة لفحص وجود الجداول
function checkTablesExist($pdo, $tables) {
    $existingTables = [];
    $missingTables = [];
    
    try {
        // الحصول على قائمة الجداول الموجودة
        $stmt = $pdo->query("SHOW TABLES");
        $allTables = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        foreach ($tables as $table) {
            if (in_array($table, $allTables)) {
                $existingTables[] = $table;
            } else {
                $missingTables[] = $table;
            }
        }
        
        return [
            'existing' => $existingTables,
            'missing' => $missingTables
        ];
    } catch (PDOException $e) {
        return [
            'existing' => [],
            'missing' => $tables,
            'error' => $e->getMessage()
        ];
    }
}

// دالة لفحص عدد السجلات في الجداول
function checkTableRecords($pdo, $tables) {
    $records = [];
    
    try {
        foreach ($tables as $table) {
            $stmt = $pdo->query("SELECT COUNT(*) FROM `$table`");
            $count = $stmt->fetchColumn();
            $records[$table] = $count;
        }
        
        return $records;
    } catch (PDOException $e) {
        return [
            'error' => $e->getMessage()
        ];
    }
}

// فحص حالة قاعدة البيانات
$dbStatus = [
    'connection' => false,
    'database_exists' => false,
    'tables' => [],
    'records' => [],
    'error' => null
];

// قائمة الجداول المتوقعة
$expectedTables = [
    'branches',
    'order_sequences',
    'users',
    'orders',
    'archived_orders',
    'countries',
    'system_settings',
    'activity_log'
];

// فحص الاتصال بقاعدة البيانات
if ($pdo !== null) {
    $dbStatus['connection'] = true;
    
    // فحص وجود قاعدة البيانات
    $dbStatus['database_exists'] = checkDatabaseExists($db_host, $db_user, $db_pass, $db_name);
    
    if ($dbStatus['database_exists']) {
        // فحص وجود الجداول
        $dbStatus['tables'] = checkTablesExist($pdo, $expectedTables);
        
        // فحص عدد السجلات في الجداول الموجودة
        if (!empty($dbStatus['tables']['existing'])) {
            $dbStatus['records'] = checkTableRecords($pdo, $dbStatus['tables']['existing']);
        }
    }
} else {
    $dbStatus['error'] = 'فشل الاتصال بقاعدة البيانات';
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فحص حالة قاعدة البيانات</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        h1, h2 {
            color: #333;
        }
        .status {
            margin-bottom: 20px;
            padding: 15px;
            border-radius: 5px;
        }
        .status-success {
            background-color: #d1fae5;
            color: #065f46;
        }
        .status-warning {
            background-color: #fef3c7;
            color: #92400e;
        }
        .status-error {
            background-color: #fee2e2;
            color: #b91c1c;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            text-align: right;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #f8fafc;
        }
        .btn {
            display: inline-block;
            padding: 10px 15px;
            background-color: #4f46e5;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-right: 10px;
        }
        .btn:hover {
            background-color: #3730a3;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>فحص حالة قاعدة البيانات</h1>
        
        <div class="status <?php echo $dbStatus['connection'] ? 'status-success' : 'status-error'; ?>">
            <h2>حالة الاتصال</h2>
            <?php if ($dbStatus['connection']): ?>
                <p>تم الاتصال بقاعدة البيانات بنجاح.</p>
            <?php else: ?>
                <p>فشل الاتصال بقاعدة البيانات: <?php echo $dbStatus['error']; ?></p>
            <?php endif; ?>
        </div>
        
        <?php if ($dbStatus['connection']): ?>
            <div class="status <?php echo $dbStatus['database_exists'] ? 'status-success' : 'status-error'; ?>">
                <h2>حالة قاعدة البيانات</h2>
                <?php if ($dbStatus['database_exists']): ?>
                    <p>قاعدة البيانات <?php echo $db_name; ?> موجودة.</p>
                <?php else: ?>
                    <p>قاعدة البيانات <?php echo $db_name; ?> غير موجودة.</p>
                <?php endif; ?>
            </div>
            
            <?php if ($dbStatus['database_exists']): ?>
                <div class="status <?php echo empty($dbStatus['tables']['missing']) ? 'status-success' : 'status-warning'; ?>">
                    <h2>حالة الجداول</h2>
                    <?php if (empty($dbStatus['tables']['missing'])): ?>
                        <p>جميع الجداول المتوقعة موجودة.</p>
                    <?php else: ?>
                        <p>بعض الجداول المتوقعة غير موجودة:</p>
                        <ul>
                            <?php foreach ($dbStatus['tables']['missing'] as $table): ?>
                                <li><?php echo $table; ?></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                    
                    <?php if (!empty($dbStatus['tables']['existing'])): ?>
                        <h3>الجداول الموجودة:</h3>
                        <table>
                            <thead>
                                <tr>
                                    <th>اسم الجدول</th>
                                    <th>عدد السجلات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($dbStatus['tables']['existing'] as $table): ?>
                                    <tr>
                                        <td><?php echo $table; ?></td>
                                        <td><?php echo isset($dbStatus['records'][$table]) ? $dbStatus['records'][$table] : 'غير متاح'; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>
        
        <div>
            <a href="setup-db.php" class="btn">إعداد قاعدة البيانات</a>
            <a href="home.php" class="btn">الصفحة الرئيسية</a>
        </div>
    </div>
</body>
</html>
