<?php
// بدء الجلسة
session_start();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>تأكيد التسجيل - نظام طلبات الشحن</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/modern-auth.css">
  <style>
    .confirmation-container {
      background: rgba(255, 255, 255, 0.15);
      backdrop-filter: blur(10px);
      border-radius: 16px;
      border: 1px solid rgba(255, 255, 255, 0.3);
      box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
      padding: 40px;
      max-width: 600px;
      width: 100%;
      text-align: center;
      color: white;
      position: relative;
      z-index: 1;
    }

    .icon-container {
      width: 100px;
      height: 100px;
      background-color: rgba(255, 255, 255, 0.2);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 30px;
    }

    .icon-container i {
      font-size: 50px;
      color: white;
    }

    h1 {
      font-size: 28px;
      color: white;
      margin-bottom: 20px;
      text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    p {
      font-size: 16px;
      color: rgba(255, 255, 255, 0.8);
      line-height: 1.6;
      margin-bottom: 30px;
    }

    .btn-primary {
      background: rgba(120, 115, 245, 0.8);
      color: white;
      border: none;
      border-radius: 8px;
      padding: 15px 30px;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      text-decoration: none;
      display: inline-block;
    }

    .btn-primary:hover {
      background: rgba(120, 115, 245, 1);
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .steps-container {
      display: flex;
      justify-content: center;
      margin: 30px 0;
      flex-wrap: wrap;
    }

    .step {
      display: flex;
      flex-direction: column;
      align-items: center;
      margin: 0 15px;
      max-width: 150px;
    }

    .step-number {
      width: 40px;
      height: 40px;
      background-color: rgba(255, 255, 255, 0.2);
      color: white;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: bold;
      margin-bottom: 10px;
      border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .step-text {
      text-align: center;
      font-size: 14px;
      color: rgba(255, 255, 255, 0.8);
    }

    @media (max-width: 640px) {
      .confirmation-container {
        padding: 30px 20px;
      }

      h1 {
        font-size: 24px;
      }

      .steps-container {
        flex-direction: column;
        align-items: center;
      }

      .step {
        margin: 10px 0;
      }
    }
  </style>
</head>

<body class="modern-auth">
  <!-- خلفية الجبال -->
  <div class="mountains-bg"></div>

  <div class="confirmation-container">
    <div class="icon-container">
      <i class="fas fa-check"></i>
    </div>

    <h1>تم إنشاء حسابك بنجاح!</h1>

    <?php if (isset($_SESSION['register_success'])): ?>
    <p><?php echo $_SESSION['register_success']; unset($_SESSION['register_success']); ?></p>
    <?php else: ?>
    <p>شكراً لتسجيلك في نظام طلبات الشحن. يرجى الانتظار حتى تتم مراجعة طلبك والموافقة عليه من قبل الإدارة.</p>
    <?php endif; ?>

    <div class="steps-container">
      <div class="step">
        <div class="step-number">1</div>
        <div class="step-text">تم إنشاء الحساب</div>
      </div>
      <div class="step">
        <div class="step-number">2</div>
        <div class="step-text">في انتظار الموافقة</div>
      </div>
      <div class="step">
        <div class="step-number">3</div>
        <div class="step-text">تسجيل الدخول بعد الموافقة</div>
      </div>
    </div>

    <p>سيتم إشعارك عبر البريد الإلكتروني عند الموافقة على حسابك.</p>
    <a href="login.php" class="btn-primary">العودة إلى صفحة تسجيل الدخول</a>
  </div>
</body>

</html>
