<?php
// تضمين ملف التحقق من الجلسة
require_once 'check_session.php';

// التحقق من صلاحيات المستخدم (مسموح فقط للمدير)
if (!check_permission('admin')) {
    // إعادة توجيه المستخدم إلى الصفحة الرئيسية مع رسالة خطأ
    $_SESSION['error_message'] = 'ليس لديك صلاحية الوصول إلى هذه الصفحة';
    header('Location: dashboard.php');
    exit;
}

// الحصول على معلومات المستخدم الحالي
$currentUser = get_current_user();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>نظام طلبات الشحن | طلبات التسجيل المعلقة</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    :root {
      --primary: #4f46e5;
      --primary-light: #818cf8;
      --secondary: #f59e0b;
      --dark: #1e293b;
      --light: #f8fafc;
    }

    @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap');

    body {
      font-family: 'Tajawal', sans-serif;
      background-color: #f1f5f9;
      color: var(--dark);
    }

    /* تصميم القائمة الجانبية */
    .sidebar {
      background: #0a2056; /* azraq kahli (dark blue) */
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .sidebar-collapsed {
      width: 80px;
    }

    .sidebar-expanded {
      width: 280px;
    }

    .nav-item {
      transition: all 0.3s ease;
      border-radius: 8px;
      position: relative;
      overflow: hidden;
    }

    .nav-item:before {
      content: '';
      position: absolute;
      right: 0;
      top: 0;
      height: 100%;
      width: 0;
      background-color: rgba(255, 255, 255, 0.2);
      transition: width 0.3s ease;
    }

    .nav-item:hover:before {
      width: 4px;
    }

    .nav-item.active {
      background-color: rgba(255, 255, 255, 0.15);
      font-weight: 600;
    }

    .nav-item.active:before {
      width: 4px;
      background-color: var(--secondary);
    }

    /* تصميم المحتوى الرئيسي */
    .main-content {
      transition: margin-right 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    /* تصميم الجدول */
    .table-container {
      overflow-x: auto;
      border-radius: 0.5rem;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    th {
      background-color: #f8fafc;
      padding: 0.75rem 1rem;
      text-align: right;
      font-weight: 600;
      color: #4b5563;
      border-bottom: 1px solid #e5e7eb;
    }

    td {
      padding: 0.75rem 1rem;
      border-bottom: 1px solid #e5e7eb;
    }

    tr:hover {
      background-color: #f9fafb;
    }

    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 0.5rem 1rem;
      border-radius: 0.375rem;
      font-weight: 500;
      transition: all 0.2s;
    }

    .btn-approve {
      background-color: #10b981;
      color: white;
    }

    .btn-approve:hover {
      background-color: #059669;
    }

    .btn-reject {
      background-color: #ef4444;
      color: white;
    }

    .btn-reject:hover {
      background-color: #dc2626;
    }

    /* تصميم متجاوب */
    @media (max-width: 768px) {
      .main-content {
        margin-right: 0 !important;
      }
    }
  </style>
</head>

<body class="bg-gray-50">

  <!-- القائمة الجانبية -->
  <aside class="sidebar sidebar-expanded fixed h-full z-30 text-white">
    <div class="h-full flex flex-col">
      <!-- شعار النظام -->
      <div class="flex items-center p-6 border-b border-indigo-400/20">
        <i class="fas fa-truck text-2xl text-yellow-300 ml-3"></i>
        <h1 class="text-xl font-bold whitespace-nowrap">نظام طلبات الشحن</h1>
        <button id="toggleSidebar" class="text-indigo-200 hover:text-white mr-auto">
          <i class="fas fa-chevron-right"></i>
        </button>
      </div>

      <!-- قائمة التنقل -->
      <nav class="flex-1 overflow-y-auto p-4 space-y-2">
        <a href="dashboard.php" class="nav-item flex items-center px-4 py-3">
          <i class="fas fa-chart-pie ml-3 text-lg"></i>
          <span class="whitespace-nowrap">لوحة التحكم</span>
        </a>

        <a href="create-order.php" class="nav-item flex items-center px-4 py-3">
          <i class="fas fa-plus-circle ml-3 text-lg"></i>
          <span class="whitespace-nowrap">إنشاء طلب</span>
        </a>

        <a href="orders.php" class="nav-item flex items-center px-4 py-3">
          <i class="fas fa-boxes ml-3 text-lg"></i>
          <span class="whitespace-nowrap">إدارة الطلبات</span>
        </a>

        <a href="archive.php" class="nav-item flex items-center px-4 py-3">
          <i class="fas fa-archive ml-3 text-lg"></i>
          <span class="whitespace-nowrap">الأرشيف</span>
        </a>

        <?php if (check_permission('admin')): ?>
        <a href="settings.php" class="nav-item flex items-center px-4 py-3">
          <i class="fas fa-cog ml-3 text-lg"></i>
          <span class="whitespace-nowrap">إعدادات النظام</span>
        </a>

        <a href="users.php" class="nav-item flex items-center px-4 py-3">
          <i class="fas fa-users ml-3 text-lg"></i>
          <span class="whitespace-nowrap">المستخدمون</span>
        </a>

        <a href="pending-users.php" class="nav-item active flex items-center px-4 py-3">
          <i class="fas fa-user-clock ml-3 text-lg"></i>
          <span class="whitespace-nowrap">طلبات التسجيل المعلقة</span>
        </a>
        <?php endif; ?>
      </nav>

      <!-- معلومات المستخدم -->
      <div class="p-4 border-t border-indigo-400/20">
        <div class="flex items-center">
          <div class="w-10 h-10 rounded-full bg-indigo-200 flex items-center justify-center text-indigo-700 ml-3">
            <i class="fas fa-user"></i>
          </div>
          <div>
            <h3 class="text-sm font-medium"><?php echo htmlspecialchars($currentUser['full_name']); ?></h3>
            <p class="text-xs text-indigo-200"><?php echo htmlspecialchars($currentUser['role']); ?></p>
          </div>
          <a href="logout.php" class="mr-auto text-indigo-200 hover:text-white">
            <i class="fas fa-sign-out-alt"></i>
          </a>
        </div>
      </div>
    </div>
  </aside>

  <!-- طبقة التعتيم للجوال -->
  <div id="overlay" class="overlay"></div>

  <!-- المحتوى الرئيسي -->
  <main class="main-content min-h-screen mr-[280px]">
    <!-- شريط التنقل العلوي -->
    <header class="bg-white shadow-sm sticky top-0 z-20">
      <div class="flex items-center justify-between p-4">
        <!-- زر القائمة للجوال -->
        <button id="mobileMenuButton" class="md:hidden text-gray-600 hover:text-indigo-600">
          <i class="fas fa-bars text-xl"></i>
        </button>

        <!-- شريط البحث -->
        <div class="relative flex-1 max-w-md mx-4">
          <input type="text" id="searchInput" placeholder="بحث عن مستخدم..." class="form-input w-full pl-10 pr-4 py-2 rounded-full">
          <i class="fas fa-search absolute right-3 top-3 text-gray-400"></i>
        </div>

        <!-- إشعارات وملف المستخدم -->
        <div class="flex items-center space-x-4 space-x-reverse">
          <div class="flex items-center space-x-2 space-x-reverse">
            <div class="text-right">
              <p class="font-medium text-sm"><?php echo htmlspecialchars($currentUser['full_name']); ?></p>
              <p class="text-xs text-gray-500"><?php echo htmlspecialchars($currentUser['role']); ?></p>
            </div>
            <div
              class="h-10 w-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 font-bold">
              <?php echo mb_substr($currentUser['full_name'], 0, 1, 'UTF-8'); ?>
            </div>
          </div>
        </div>
      </div>
    </header>

    <!-- محتوى الصفحة -->
    <div class="p-6">
      <!-- رأس الصفحة -->
      <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <div>
          <h1 class="text-2xl font-bold text-gray-800 flex items-center">
            <i class="fas fa-user-clock text-indigo-600 ml-3"></i>
            طلبات التسجيل المعلقة
          </h1>
          <p class="text-gray-500 mt-1">إدارة طلبات المستخدمين الجدد الذين ينتظرون الموافقة</p>
        </div>
        <div class="mt-4 md:mt-0">
          <div class="flex items-center space-x-2 space-x-reverse">
            <span id="pendingCount" class="bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5 rounded-full">0 طلب معلق</span>
            <button id="refreshBtn" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-3 py-2 rounded-lg flex items-center">
              <i class="fas fa-sync-alt ml-2"></i>
              <span>تحديث</span>
            </button>
          </div>
        </div>
      </div>

      <!-- رسالة الحالة -->
      <div id="statusMessage" class="hidden mb-6"></div>

      <!-- جدول طلبات التسجيل المعلقة -->
      <div class="bg-white rounded-xl shadow-sm overflow-hidden">
        <div class="table-container">
          <table class="min-w-full">
            <thead>
              <tr>
                <th class="w-16">#</th>
                <th>الاسم الكامل</th>
                <th>اسم المستخدم</th>
                <th>البريد الإلكتروني</th>
                <th>رقم الهاتف</th>
                <th>تاريخ التسجيل</th>
                <th>الإجراءات</th>
              </tr>
            </thead>
            <tbody id="pendingUsersTable">
              <!-- سيتم تحميل البيانات هنا عبر JavaScript -->
              <tr>
                <td colspan="7" class="text-center py-8 text-gray-500">
                  <i class="fas fa-spinner fa-spin ml-2"></i>
                  جاري تحميل طلبات التسجيل...
                </td>
              </tr>
            </tbody>
          </table>
        </div>
        <!-- رسالة عند عدم وجود طلبات -->
        <div id="noRequestsMessage" class="hidden p-8 text-center text-gray-500">
          <i class="fas fa-check-circle text-green-500 text-4xl mb-4"></i>
          <p class="text-lg font-medium">لا توجد طلبات تسجيل معلقة</p>
          <p class="mt-2">جميع طلبات التسجيل تمت معالجتها</p>
        </div>
      </div>
    </div>
  </main>

  <!-- تضمين ملفات JavaScript -->
  <script src="js/sidebar.js"></script>
  <script src="js/pending-users.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</body>

</html>
