<?php
/**
 * صفحة إدارة المستخدمين
 * تستخدم هذه الصفحة لعرض وتعديل وحذف المستخدمين
 */

// بدء الجلسة
session_start();

// تضمين ملف التكوين الجديد
require_once 'config/config_new.php';

// تضمين ملف الدوال المساعدة
require_once 'includes/functions.php';

// تضمين ملف الاتصال بقاعدة البيانات
require_once 'config/db_config.php';

// التحقق من حالة تسجيل الدخول
if (!isLoggedIn()) {
    // إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
    header('Location: login.php');
    exit;
}

// التحقق من صلاحيات المستخدم (يجب أن يكون مسؤولاً)
if ($_SESSION['user_role'] !== 'admin') {
    // إعادة توجيه المستخدم إلى لوحة التحكم
    header('Location: dashboard.php');
    exit;
}

// معالجة طلبات الحذف
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $userId = $_GET['delete'];
    
    // لا يمكن حذف المستخدم الحالي
    if ($userId == $_SESSION['user_id']) {
        $_SESSION['user_message'] = 'لا يمكن حذف المستخدم الحالي.';
        $_SESSION['user_message_type'] = 'error';
    } else {
        try {
            // حذف المستخدم
            $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
            $result = $stmt->execute([$userId]);
            
            if ($result) {
                $_SESSION['user_message'] = 'تم حذف المستخدم بنجاح.';
                $_SESSION['user_message_type'] = 'success';
            } else {
                $_SESSION['user_message'] = 'فشل حذف المستخدم.';
                $_SESSION['user_message_type'] = 'error';
            }
        } catch (PDOException $e) {
            $_SESSION['user_message'] = 'حدث خطأ أثناء حذف المستخدم: ' . $e->getMessage();
            $_SESSION['user_message_type'] = 'error';
        }
    }
    
    // إعادة توجيه لتجنب إعادة الحذف عند تحديث الصفحة
    header('Location: manage_users.php');
    exit;
}

// معالجة طلبات تغيير الحالة
if (isset($_GET['toggle_status']) && is_numeric($_GET['toggle_status'])) {
    $userId = $_GET['toggle_status'];
    
    try {
        // الحصول على حالة المستخدم الحالية
        $stmt = $pdo->prepare("SELECT status FROM users WHERE id = ?");
        $stmt->execute([$userId]);
        $user = $stmt->fetch();
        
        if ($user) {
            // تبديل الحالة
            $newStatus = ($user['status'] === 'active') ? 'pending' : 'active';
            
            // تحديث حالة المستخدم
            $updateStmt = $pdo->prepare("UPDATE users SET status = ? WHERE id = ?");
            $result = $updateStmt->execute([$newStatus, $userId]);
            
            if ($result) {
                $_SESSION['user_message'] = 'تم تغيير حالة المستخدم بنجاح.';
                $_SESSION['user_message_type'] = 'success';
            } else {
                $_SESSION['user_message'] = 'فشل تغيير حالة المستخدم.';
                $_SESSION['user_message_type'] = 'error';
            }
        } else {
            $_SESSION['user_message'] = 'المستخدم غير موجود.';
            $_SESSION['user_message_type'] = 'error';
        }
    } catch (PDOException $e) {
        $_SESSION['user_message'] = 'حدث خطأ أثناء تغيير حالة المستخدم: ' . $e->getMessage();
        $_SESSION['user_message_type'] = 'error';
    }
    
    // إعادة توجيه لتجنب إعادة التغيير عند تحديث الصفحة
    header('Location: manage_users.php');
    exit;
}

// الحصول على قائمة المستخدمين
try {
    $stmt = $pdo->query("SELECT * FROM users ORDER BY id DESC");
    $users = $stmt->fetchAll();
} catch (PDOException $e) {
    $error = 'حدث خطأ أثناء استرداد قائمة المستخدمين: ' . $e->getMessage();
    $users = [];
}

// عنوان الصفحة
$pageTitle = 'إدارة المستخدمين';

// تضمين ملف الرأس
include 'includes/header.php';
?>

<div class="container mt-4 rtl">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">إدارة المستخدمين</h5>
                </div>
                <div class="card-body">
                    <?php if (isset($_SESSION['user_message'])): ?>
                        <div class="alert alert-<?php echo ($_SESSION['user_message_type'] === 'success') ? 'success' : 'danger'; ?> alert-dismissible fade show" role="alert">
                            <?php echo $_SESSION['user_message']; ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php unset($_SESSION['user_message'], $_SESSION['user_message_type']); ?>
                    <?php endif; ?>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>اسم المستخدم</th>
                                    <th>الاسم الكامل</th>
                                    <th>البريد الإلكتروني</th>
                                    <th>رقم الهاتف</th>
                                    <th>الدور</th>
                                    <th>الحالة</th>
                                    <th>تاريخ التسجيل</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($users)): ?>
                                    <tr>
                                        <td colspan="9" class="text-center">لا يوجد مستخدمين</td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($users as $user): ?>
                                        <tr>
                                            <td><?php echo $user['id']; ?></td>
                                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                                            <td><?php echo htmlspecialchars($user['fullname']); ?></td>
                                            <td><?php echo htmlspecialchars($user['email']); ?></td>
                                            <td><?php echo htmlspecialchars($user['phone'] ?? 'غير متوفر'); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo ($user['role'] === 'admin') ? 'danger' : (($user['role'] === 'manager') ? 'warning' : 'info'); ?>">
                                                    <?php 
                                                    switch ($user['role']) {
                                                        case 'admin':
                                                            echo 'مسؤول';
                                                            break;
                                                        case 'manager':
                                                            echo 'مدير';
                                                            break;
                                                        case 'user':
                                                            echo 'مستخدم';
                                                            break;
                                                        default:
                                                            echo $user['role'];
                                                    }
                                                    ?>
                                                </span>
                                            </td>
                                            <td>
                                                <span class="badge badge-<?php echo ($user['status'] === 'active') ? 'success' : 'secondary'; ?>">
                                                    <?php echo ($user['status'] === 'active') ? 'نشط' : 'معلق'; ?>
                                                </span>
                                            </td>
                                            <td><?php echo $user['registration_date'] ?? 'غير متوفر'; ?></td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="edit_user.php?id=<?php echo $user['id']; ?>" class="btn btn-primary" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="manage_users.php?toggle_status=<?php echo $user['id']; ?>" class="btn btn-warning" title="تغيير الحالة" onclick="return confirm('هل أنت متأكد من تغيير حالة هذا المستخدم؟')">
                                                        <i class="fas fa-sync-alt"></i>
                                                    </a>
                                                    <?php if ($user['id'] != $_SESSION['user_id']): ?>
                                                        <a href="manage_users.php?delete=<?php echo $user['id']; ?>" class="btn btn-danger" title="حذف" onclick="return confirm('هل أنت متأكد من حذف هذا المستخدم؟')">
                                                            <i class="fas fa-trash"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        <a href="register.php" class="btn btn-success">
                            <i class="fas fa-plus"></i> إضافة مستخدم جديد
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// تضمين ملف التذييل
include 'includes/footer.php';
?>
