<?php
/**
 * ملف تسجيل الخروج
 * يستخدم هذا الملف لتسجيل خروج المستخدم من النظام
 */

// بدء الجلسة
session_start();

// تسجيل معلومات تسجيل الخروج للتصحيح
error_log('تسجيل خروج المستخدم');
error_log('متغيرات الجلسة قبل تسجيل الخروج: ' . print_r($_SESSION, true));

// حفظ معلومات المستخدم للتسجيل
$userId = $_SESSION['user_id'] ?? 0;
$username = $_SESSION['username'] ?? 'غير معروف';

// حذف جميع متغيرات الجلسة
$_SESSION = array();

// حذف ملف تعريف الجلسة إذا كان موجود
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// إنهاء الجلسة
session_destroy();

// تسجيل معلومات تسجيل الخروج للتصحيح
error_log("تم تسجيل خروج المستخدم: $username (ID: $userId) بنجاح");

// إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
header('Location: ../auth/login.php');
exit;
?>
