<?php
/**
 * صفحة تسجيل الدخول المحسنة
 * تقوم هذه الصفحة بعرض نموذج تسجيل الدخول بتصميم حديث وتأثيرات متقدمة
 *
 * @version 2.0
 * @author فريق التطوير
 */

// بدء الجلسة
session_start();

// تضمين ملف التكوين الرئيسي
require_once '../config/config.php';

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

// متغيرات الخطأ والنجاح
$error = '';
$success = '';

// جلب قائمة الفروع من قاعدة البيانات
$branches = [];
try {
    // التحقق من وجود المركز الرئيسي في قاعدة البيانات
    $stmt = $conn->prepare("SELECT COUNT(*) FROM branches WHERE name = 'المركز الرئيسي'");
    $stmt->execute();
    $hqExists = (int)$stmt->fetchColumn() > 0;

    // إضافة المركز الرئيسي إذا لم يكن موجودًا
    if (!$hqExists) {
        $stmt = $conn->prepare("INSERT INTO branches (name, code, address, is_active) VALUES ('المركز الرئيسي', 'HQ', 'اليمن، حضرموت، المكلا', 1)");
        $stmt->execute();
    }

    // جلب جميع الفروع المطلوبة مع إزالة التكرار
    $stmt = $conn->prepare("
        SELECT DISTINCT b.id, b.name, b.code
        FROM branches b
        WHERE b.is_active = 1
        AND (
            b.name = 'المركز الرئيسي' OR
            b.name = 'فرع المكلا' OR b.code = 'MKL' OR
            b.name = 'فرع عدن' OR b.code = 'ADN' OR
            b.name = 'فرع شحن' OR b.code = 'SH' OR
            b.name = 'فرع صنعاء' OR b.code = 'SNA' OR
            b.name = 'فرع الصين' OR b.code = 'CN'
        )
        ORDER BY CASE
            WHEN b.name = 'المركز الرئيسي' THEN 1
            WHEN b.name = 'فرع المكلا' OR b.code = 'MKL' THEN 2
            WHEN b.name = 'فرع عدن' OR b.code = 'ADN' THEN 3
            WHEN b.name = 'فرع شحن' OR b.code = 'SH' THEN 4
            WHEN b.name = 'فرع صنعاء' OR b.code = 'SNA' THEN 5
            WHEN b.name = 'فرع الصين' OR b.code = 'CN' THEN 6
            ELSE 7
        END
    ");
    $stmt->execute();
    $fetchedBranches = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // إزالة التكرار يدويًا باستخدام الكود
    $branches = [];
    $usedCodes = [];

    foreach ($fetchedBranches as $branch) {
        $code = strtoupper(trim($branch['code']));
        // تجاهل الفروع المكررة بناءً على الكود
        if (!in_array($code, $usedCodes)) {
            $usedCodes[] = $code;
            $branches[] = $branch;
        }
    }

    // إذا لم يتم العثور على أي فروع، استخدم البيانات الافتراضية
    if (empty($branches)) {
        throw new Exception("لم يتم العثور على أي فروع في قاعدة البيانات");
    }

    // تسجيل الفروع للتصحيح
    error_log("الفروع المستخرجة: " . json_encode($branches, JSON_UNESCAPED_UNICODE));
} catch (Exception $e) {
    error_log("خطأ في جلب الفروع: " . $e->getMessage());
    // استخدام بيانات افتراضية في حالة حدوث خطأ
    $branches = [
        ['id' => 1, 'name' => 'المركز الرئيسي', 'code' => 'HQ25-01'],
        ['id' => 2, 'name' => 'فرع المكلا', 'code' => 'MKL25-01'],
        ['id' => 3, 'name' => 'فرع عدن', 'code' => 'ADN25-01'],
        ['id' => 4, 'name' => 'فرع شحن', 'code' => 'SH25-01'],
        ['id' => 5, 'name' => 'فرع صنعاء', 'code' => 'SNA25-01'],
        ['id' => 6, 'name' => 'فرع الصين', 'code' => 'CN25-01']
    ];
}

// التحقق من وجود رسالة خطأ في الجلسة
if (isset($_SESSION['login_error'])) {
    $error = $_SESSION['login_error'];
    unset($_SESSION['login_error']);
}

// التحقق من وجود رسالة نجاح في الجلسة
if (isset($_SESSION['login_success'])) {
    $success = $_SESSION['login_success'];
    unset($_SESSION['login_success']);
}

// التحقق من حالة تسجيل الدخول
if (isLoggedIn()) {
    // توجيه المستخدم إلى لوحة التحكم الموحدة
    header('Location: ../unified-dashboard.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>تسجيل الدخول - مجموعة ابراهيم الاحمدي اليمنية</title>
  <!-- Font Awesome للأيقونات -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <!-- خط Tajawal -->
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <!-- مكتبة الجسيمات المتحركة -->
  <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
  <!-- ملف CSS المميز الجديد -->
  <link rel="stylesheet" href="../assets/css/premium-login.css">
  <style>
    /* تنسيق إضافي للصفحة الجديدة */
    .company-logo {
      margin-bottom: 30px;
      text-align: center;
      padding-top: 10px;
    }

    .logo-image {
      width: 100px;
      height: 100px;
      margin: 0 auto;
      display: block;
      border-radius: 50%;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      object-fit: cover;
      background-color: white;
      padding: 5px;
    }

    .login-input {
      background-color: var(--input-bg);
      border: none;
      color: white;
    }

    .login-button {
      background-color: white;
      color: var(--text-dark);
      border-radius: 25px;
      text-transform: uppercase;
      margin-top: 20px;
    }

    .remember-forgot label {
      color: var(--primary-color);
      font-weight: 500;
    }

    .forgot-password {
      color: var(--primary-color);
      font-weight: 500;
    }

    .overlay {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), rgba(0, 0, 0, 0.2));
      z-index: -1;
      transition: background 0.5s ease;
    }

    /* أنماط وضع النهار */
    body.daytime .overlay {
      background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), rgba(0, 0, 0, 0.2));
    }

    body.daytime .login-container {
      background: rgba(255, 255, 255, 0.95);
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
    }

    /* أنماط وضع الليل */
    body.nighttime .overlay {
      background: linear-gradient(135deg, rgba(0, 0, 0, 0.3), rgba(0, 0, 0, 0.5));
    }

    body.nighttime .login-container {
      background: rgba(255, 255, 255, 0.85);
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.4);
    }

    body.nighttime .login-input {
      background: rgba(15, 42, 71, 0.95);
      border-color: rgba(255, 255, 255, 0.15);
    }

    body.nighttime .login-button {
      background-color: #f0f0f0;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.25);
    }

    body.nighttime .remember-forgot label,
    body.nighttime .forgot-password {
      color: #0a2744;
      font-weight: 600;
    }

    /* أنماط الجسيمات المتحركة */
    #particles-js {
      position: absolute;
      width: 100%;
      height: 100%;
      top: 0;
      left: 0;
      z-index: -1;
      pointer-events: none;
    }
  </style>
</head>

<body class="premium-login">
  <!-- خلفية متحركة -->
  <div class="premium-background"></div>
  <div class="overlay"></div>
  <!-- عنصر الجسيمات المتحركة -->
  <div id="particles-js"></div>

  <!-- حاوية النموذج -->
  <div class="login-container">
    <!-- شعار الشركة -->
    <div class="company-logo">
      <img src="../assets/images/backgrounds/background.png" alt="مجموعة ابراهيم الاحمدي اليمنية" class="logo-image" onerror="this.src='../assets/images/Company logo.png';">
    </div>

    <form id="loginForm" action="login_process.php" method="post">
      <!-- رمز CSRF للحماية من هجمات CSRF -->
      <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">

      <div class="input-group">
        <input type="email" name="email" class="login-input" placeholder="Email ID" required>
        <i class="fas fa-user input-icon"></i>
      </div>

      <div class="input-group">
        <input type="password" name="password" id="password" class="login-input" placeholder="Password" required>
        <i class="fas fa-lock input-icon"></i>
      </div>

      <div class="input-group branch-selection" id="branch-selection" style="display: none;">
        <select name="branch_id" id="branch_id" class="login-input">
          <option value="" disabled selected>اختر الفرع</option>
          <?php foreach ($branches as $branch): ?>
          <option value="<?php echo $branch['id']; ?>">
            <?php
            // تنسيق اسم الفرع بشكل موحد
            $displayName = $branch['name'];
            $displayCode = $branch['code'];

            // إذا كان الاسم لا يبدأ بكلمة "فرع" وليس المركز الرئيسي، أضف كلمة "فرع"
            if (strpos($displayName, 'فرع') === false && $displayName != 'المركز الرئيسي') {
                $displayName = 'فرع ' . $displayName;
            }

            echo htmlspecialchars($displayName);
            ?>
            <?php if (!empty($displayCode)): ?>
            <span class="branch-code">(<?php echo htmlspecialchars($displayCode); ?>)</span>
            <?php endif; ?>
          </option>
          <?php endforeach; ?>
        </select>
        <i class="fas fa-building input-icon"></i>
      </div>

      <div class="remember-forgot">
        <div class="checkbox-container">
          <input type="checkbox" id="remember" name="remember" class="auth-checkbox">
          <label for="remember">Remember me</label>
        </div>
        <a href="#" class="forgot-password">Forgot Password?</a>
      </div>

      <?php if (!empty($error)): ?>
      <div class="error-message">
        <?php echo $error; ?>
      </div>
      <?php endif; ?>

      <?php if (!empty($success)): ?>
      <div class="success-message">
        <?php echo $success; ?>
      </div>
      <?php endif; ?>

      <button type="submit" class="login-button">
        LOGIN
      </button>
    </form>

  </div>

  <!-- ملف JavaScript للتأثيرات -->
  <script src="../assets/js/premium-login-effects.js"></script>

  <!-- سكريبت للتحقق من مدير النظام وتحديد الخلفية حسب الوقت -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const emailInput = document.querySelector('input[name="email"]');
      const branchSelection = document.getElementById('branch-selection');
      const branchSelect = document.getElementById('branch_id');
      const backgroundElement = document.querySelector('.premium-background');

      // تحديد الخلفية حسب الوقت من اليوم
      function setBackgroundBasedOnTime() {
        const currentHour = new Date().getHours();
        // اعتبار الوقت من 6 صباحًا حتى 6 مساءً هو وقت النهار
        const isDaytime = currentHour >= 6 && currentHour < 18;

        if (isDaytime) {
          // خلفية النهار
          backgroundElement.style.backgroundImage = "url('../assets/images/backgrounds/download.gif')";
          backgroundElement.style.opacity = "0.6";
          backgroundElement.style.filter = "brightness(1.2) contrast(0.9)";
          document.body.classList.add('daytime');
          document.body.classList.remove('nighttime');
        } else {
          // خلفية الليل
          backgroundElement.style.backgroundImage = "url('../assets/images/backgrounds/downloaDd (1).gif')";
          backgroundElement.style.opacity = "0.8";
          backgroundElement.style.filter = "brightness(1) contrast(1.1)";
          document.body.classList.add('nighttime');
          document.body.classList.remove('daytime');
        }
      }

      // تطبيق الخلفية المناسبة عند تحميل الصفحة
      setBackgroundBasedOnTime();

      // تعديل إعدادات الجسيمات المتحركة حسب الوقت
      function updateParticlesSettings() {
        const currentHour = new Date().getHours();
        const isDaytime = currentHour >= 6 && currentHour < 18;

        if (isDaytime) {
          // إعدادات الجسيمات للنهار
          particlesJS("particles-js", {
            "particles": {
              "number": { "value": 50 },
              "color": { "value": "#ffffff" },
              "opacity": { "value": 0.3, "random": true },
              "size": { "value": 3, "random": true },
              "line_linked": {
                "enable": true,
                "color": "#ffffff",
                "opacity": 0.2,
                "width": 1
              },
              "move": {
                "speed": 2,
                "direction": "none",
                "random": true
              }
            }
          });
        } else {
          // إعدادات الجسيمات لليل
          particlesJS("particles-js", {
            "particles": {
              "number": { "value": 80 },
              "color": { "value": "#ffffff" },
              "opacity": { "value": 0.5, "random": true },
              "size": { "value": 3, "random": true },
              "line_linked": {
                "enable": true,
                "color": "#ffffff",
                "opacity": 0.4,
                "width": 1
              },
              "move": {
                "speed": 2,
                "direction": "none",
                "random": true
              }
            }
          });
        }
      }

      // تطبيق إعدادات الجسيمات المناسبة
      updateParticlesSettings();

      // إضافة مستمع لحدث تغيير البريد الإلكتروني
      emailInput.addEventListener('blur', function() {
        const email = this.value.trim().toLowerCase();

        // التحقق مما إذا كان البريد الإلكتروني هو بريد مدير النظام
        if (email === 'admin@al-ahmadigroup.com' || email === 'admin') {
          // إخفاء حقل اختيار الفرع
          branchSelection.style.display = 'none';

          // إزالة خاصية required من حقل اختيار الفرع
          branchSelect.removeAttribute('required');
        } else {
          // إظهار حقل اختيار الفرع
          branchSelection.style.display = 'block';

          // إضافة خاصية required إلى حقل اختيار الفرع
          branchSelect.setAttribute('required', 'required');
        }
      });

      // التحقق من البريد الإلكتروني عند تحميل الصفحة
      if (emailInput.value.trim().toLowerCase() === 'admin@al-ahmadigroup.com' || emailInput.value.trim().toLowerCase() === 'admin') {
        // إخفاء حقل اختيار الفرع
        branchSelection.style.display = 'none';

        // إزالة خاصية required من حقل اختيار الفرع
        branchSelect.removeAttribute('required');
      }
    });
  </script>
</body>

</html>
