<?php
/**
 * ملف لإنشاء مستخدم مسؤول افتراضي
 * يستخدم هذا الملف لإنشاء مستخدم مسؤول افتراضي في قاعدة البيانات
 */

// بدء الجلسة
session_start();

// تضمين ملف الاتصال بقاعدة البيانات
require_once 'config/db_config.php';

// كلمة المرور الافتراضية للمسؤول
$adminPassword = 'admin123';

// تشفير كلمة المرور
$hashedPassword = password_hash($adminPassword, PASSWORD_DEFAULT);

// تاريخ التسجيل الحالي
$registrationDate = date('Y-m-d H:i:s');

try {
    // التحقق من وجود مستخدم مسؤول
    $stmt = $pdo->prepare("SELECT id FROM users WHERE username = 'admin'");
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        echo '<div style="background-color: #ffcccc; padding: 20px; border-radius: 5px; margin: 20px; text-align: center; direction: rtl; font-family: Arial, sans-serif;">';
        echo '<h2 style="color: #cc0000;">المستخدم المسؤول موجود بالفعل</h2>';
        echo '<p>يوجد بالفعل مستخدم باسم "admin" في قاعدة البيانات.</p>';
        echo '<p><a href="login.php" style="color: #0066cc; text-decoration: none;">العودة إلى صفحة تسجيل الدخول</a></p>';
        echo '</div>';
    } else {
        // إدراج المستخدم المسؤول
        $insertStmt = $pdo->prepare("
            INSERT INTO users (username, fullname, email, password, role, status, registration_date, phone) 
            VALUES ('admin', 'مدير النظام', 'admin@example.com', ?, 'admin', 'active', ?, '123456789')
        ");
        
        $result = $insertStmt->execute([$hashedPassword, $registrationDate]);
        
        if ($result) {
            echo '<div style="background-color: #ccffcc; padding: 20px; border-radius: 5px; margin: 20px; text-align: center; direction: rtl; font-family: Arial, sans-serif;">';
            echo '<h2 style="color: #006600;">تم إنشاء المستخدم المسؤول بنجاح</h2>';
            echo '<p>تم إنشاء مستخدم مسؤول جديد بالبيانات التالية:</p>';
            echo '<ul style="list-style-type: none; padding: 0; text-align: right; margin: 20px auto; width: 300px;">';
            echo '<li><strong>اسم المستخدم:</strong> admin</li>';
            echo '<li><strong>كلمة المرور:</strong> ' . $adminPassword . '</li>';
            echo '<li><strong>البريد الإلكتروني:</strong> admin@example.com</li>';
            echo '<li><strong>الدور:</strong> مسؤول (admin)</li>';
            echo '<li><strong>الحالة:</strong> نشط (active)</li>';
            echo '</ul>';
            echo '<p style="color: #cc0000; font-weight: bold;">يرجى تغيير كلمة المرور بعد تسجيل الدخول لأول مرة!</p>';
            echo '<p><a href="login.php" style="color: #0066cc; text-decoration: none;">الذهاب إلى صفحة تسجيل الدخول</a></p>';
            echo '</div>';
        } else {
            echo '<div style="background-color: #ffcccc; padding: 20px; border-radius: 5px; margin: 20px; text-align: center; direction: rtl; font-family: Arial, sans-serif;">';
            echo '<h2 style="color: #cc0000;">فشل إنشاء المستخدم المسؤول</h2>';
            echo '<p>حدث خطأ أثناء محاولة إنشاء المستخدم المسؤول. يرجى المحاولة مرة أخرى.</p>';
            echo '</div>';
        }
    }
} catch (PDOException $e) {
    echo '<div style="background-color: #ffcccc; padding: 20px; border-radius: 5px; margin: 20px; text-align: center; direction: rtl; font-family: Arial, sans-serif;">';
    echo '<h2 style="color: #cc0000;">خطأ في قاعدة البيانات</h2>';
    echo '<p>حدث خطأ أثناء الاتصال بقاعدة البيانات: ' . $e->getMessage() . '</p>';
    echo '</div>';
}
?>
