<?php
/**
 * صفحة رفض الوصول
 * تقوم هذه الصفحة بعرض رسالة رفض الوصول للمستخدمين الذين ليس لديهم صلاحية الوصول إلى صفحة معينة
 * 
 * @version 1.0
 * @author System Developer
 */

// تضمين ملف إدارة الجلسات
require_once '../includes/session_manager.php';

// الحصول على معلومات المستخدم الحالي
$currentUser = getCurrentUser();

// الحصول على الصفحة المطلوبة
$requestedPage = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'صفحة غير معروفة';

// تسجيل محاولة الوصول غير المصرح به
if ($currentUser) {
    error_log("محاولة وصول غير مصرح به: المستخدم {$currentUser['username']} حاول الوصول إلى {$requestedPage}");
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>رفض الوصول - نظام طلبات الشحن</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Tajawal', sans-serif;
    }

    body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      background: linear-gradient(135deg, #4c0c70 0%, #6d28d9 100%);
      direction: rtl;
      padding: 20px;
    }

    .access-denied-container {
      width: 100%;
      max-width: 600px;
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(10px);
      border-radius: 16px;
      border: 1px solid rgba(255, 255, 255, 0.3);
      box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
      padding: 40px;
      text-align: center;
      color: white;
    }

    .access-denied-icon {
      font-size: 80px;
      color: #ff5757;
      margin-bottom: 20px;
      animation: pulse 2s infinite;
    }

    @keyframes pulse {
      0% {
        transform: scale(1);
        opacity: 1;
      }
      50% {
        transform: scale(1.1);
        opacity: 0.8;
      }
      100% {
        transform: scale(1);
        opacity: 1;
      }
    }

    .access-denied-title {
      font-size: 32px;
      font-weight: 700;
      margin-bottom: 20px;
      color: #ff5757;
    }

    .access-denied-message {
      font-size: 18px;
      margin-bottom: 30px;
      line-height: 1.6;
    }

    .access-denied-details {
      background: rgba(255, 255, 255, 0.1);
      border-radius: 8px;
      padding: 20px;
      margin-bottom: 30px;
      text-align: right;
    }

    .access-denied-details p {
      margin-bottom: 10px;
    }

    .access-denied-details strong {
      color: #ffcc00;
    }

    .access-denied-actions {
      display: flex;
      justify-content: center;
      gap: 20px;
      flex-wrap: wrap;
    }

    .access-denied-button {
      padding: 12px 24px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 16px;
      cursor: pointer;
      transition: all 0.3s ease;
      text-decoration: none;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .access-denied-button i {
      margin-left: 8px;
    }

    .primary-button {
      background: #3b82f6;
      color: white;
      border: none;
    }

    .primary-button:hover {
      background: #2563eb;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .secondary-button {
      background: transparent;
      color: white;
      border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .secondary-button:hover {
      background: rgba(255, 255, 255, 0.1);
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    @media (max-width: 480px) {
      .access-denied-container {
        padding: 30px 20px;
      }

      .access-denied-title {
        font-size: 24px;
      }

      .access-denied-message {
        font-size: 16px;
      }

      .access-denied-actions {
        flex-direction: column;
      }
    }
  </style>
</head>

<body>
  <div class="access-denied-container">
    <div class="access-denied-icon">
      <i class="fas fa-ban"></i>
    </div>

    <h1 class="access-denied-title">رفض الوصول</h1>

    <p class="access-denied-message">
      عذراً، ليس لديك صلاحية الوصول إلى هذه الصفحة. يرجى التواصل مع مدير النظام إذا كنت تعتقد أن هذا خطأ.
    </p>

    <?php if ($currentUser): ?>
    <div class="access-denied-details">
      <p><strong>المستخدم:</strong> <?php echo htmlspecialchars($currentUser['full_name']); ?></p>
      <p><strong>الدور:</strong> <?php echo htmlspecialchars($currentUser['role']); ?></p>
      <p><strong>الصفحة المطلوبة:</strong> <?php echo htmlspecialchars($requestedPage); ?></p>
    </div>
    <?php endif; ?>

    <div class="access-denied-actions">
      <a href="../index.php" class="access-denied-button primary-button">
        <i class="fas fa-home"></i>
        الصفحة الرئيسية
      </a>
      <a href="javascript:history.back()" class="access-denied-button secondary-button">
        <i class="fas fa-arrow-right"></i>
        العودة للصفحة السابقة
      </a>
    </div>
  </div>

  <script>
    // تسجيل محاولة الوصول غير المصرح به في وحدة التحكم
    console.log('محاولة وصول غير مصرح به');
    
    // إضافة تأثيرات بسيطة
    document.addEventListener('DOMContentLoaded', function() {
      // تأثير ظهور العناصر
      const container = document.querySelector('.access-denied-container');
      container.style.opacity = '0';
      container.style.transform = 'translateY(20px)';
      
      setTimeout(() => {
        container.style.transition = 'all 0.5s ease';
        container.style.opacity = '1';
        container.style.transform = 'translateY(0)';
      }, 100);
    });
  </script>
</body>

</html>
